/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamMotionDetector;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EventObject;

public class WebcamMotionEvent
extends EventObject {
    private static final long serialVersionUID = -7245768099221999443L;
    private final double strength;
    private final Point cog;
    private final BufferedImage previousImage;
    private final BufferedImage currentImage;
    private ArrayList<Point> points;

    public WebcamMotionEvent(WebcamMotionDetector detector, double strength, Point cog) {
        this(detector, null, null, strength, cog);
    }

    public WebcamMotionEvent(WebcamMotionDetector detector, double strength, Point cog, ArrayList<Point> points) {
        this(detector, null, null, strength, cog, points);
    }

    public WebcamMotionEvent(WebcamMotionDetector detector, BufferedImage previousImage, BufferedImage currentImage, double strength, Point cog) {
        super(detector);
        this.previousImage = previousImage;
        this.currentImage = currentImage;
        this.strength = strength;
        this.cog = cog;
    }

    public WebcamMotionEvent(WebcamMotionDetector detector, BufferedImage previousImage, BufferedImage currentImage, double strength, Point cog, ArrayList<Point> points) {
        this(detector, previousImage, currentImage, strength, cog);
        this.points = points;
    }

    public ArrayList<Point> getPoints() {
        return this.points;
    }

    public double getArea() {
        return this.strength;
    }

    public Point getCog() {
        return this.cog;
    }

    public Webcam getWebcam() {
        return this.getSource().getWebcam();
    }

    public BufferedImage getPreviousImage() {
        return this.previousImage;
    }

    public BufferedImage getCurrentImage() {
        return this.currentImage;
    }

    @Override
    public WebcamMotionDetector getSource() {
        return (WebcamMotionDetector)super.getSource();
    }
}

