/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util;

import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.util.Initializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebcamInitializer {
    private final Initializable initializable;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final CountDownLatch latch = new CountDownLatch(1);

    public WebcamInitializer(Initializable initializable) {
        this.initializable = initializable;
    }

    public void initialize() {
        if (this.initialized.compareAndSet(false, true)) {
            try {
                this.initializable.initialize();
            }
            catch (Exception e2) {
                throw new WebcamException(e2);
            }
            finally {
                this.latch.countDown();
            }
        }
        try {
            this.latch.await();
        }
        catch (InterruptedException e3) {
            return;
        }
    }

    public void teardown() {
        if (this.initialized.compareAndSet(true, false)) {
            try {
                this.initializable.teardown();
            }
            catch (Exception e2) {
                throw new WebcamException(e2);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }
}

