/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util.jh;

import com.github.sarxos.webcam.util.ImageUtils;
import com.github.sarxos.webcam.util.jh.JHFilter;
import java.awt.image.BufferedImage;

public class JHNormalizeFilter
extends JHFilter {
    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        int i2;
        int c2;
        int y;
        int x;
        int w = src.getWidth();
        int h2 = src.getHeight();
        int max2 = 1;
        for (x = 0; x < w; ++x) {
            for (y = 0; y < h2; ++y) {
                int b2;
                int g2;
                int r;
                c2 = src.getRGB(x, y);
                int a2 = ImageUtils.clamp(c2 >> 24 & 0xFF);
                i2 = a2 << 24 | (r = ImageUtils.clamp(c2 >> 16 & 0xFF)) << 16 | (g2 = ImageUtils.clamp(c2 >> 8 & 0xFF)) << 8 | (b2 = ImageUtils.clamp(c2 & 0xFF));
                if (i2 <= max2) continue;
                max2 = i2;
            }
        }
        for (x = 0; x < w; ++x) {
            for (y = 0; y < h2; ++y) {
                c2 = src.getRGB(x, y);
                i2 = c2 * 256 / max2;
                dest.setRGB(x, y, i2);
            }
        }
        return dest;
    }
}

