/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.dvi;

import com.ibm.media.codec.audio.dvi.DVIState;
import com.ibm.media.codec.audio.ima4.IMA4;

public class DVI {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1998.";

    static void encode(byte[] indata, int inOffset, byte[] outdata, int outOffset, int len2, DVIState state) {
        int outputbuffer = 0;
        int[] indexTable = IMA4.indexTable;
        int[] stepsizeTable = IMA4.stepsizeTable;
        int valpred = state.valprev;
        int index = state.index;
        int step = stepsizeTable[index];
        boolean bufferstep = false;
        while (len2 > 0) {
            int sign;
            int temp;
            int val;
            int diff;
            if ((diff = (val = indata[inOffset++] << 8 | (temp = indata[inOffset++] & 0xFF)) - valpred) < 0) {
                sign = 8;
                diff = -diff;
            } else {
                sign = 0;
            }
            int delta = 0;
            int vpdiff = step >> 3;
            if (diff >= step) {
                delta = 4;
                diff -= step;
                vpdiff += step;
            }
            if (diff >= (step >>= 1)) {
                delta |= 2;
                diff -= step;
                vpdiff += step;
            }
            if (diff >= (step >>= 1)) {
                delta |= 1;
                vpdiff += step;
            }
            valpred = sign != 0 ? (valpred -= vpdiff) : (valpred += vpdiff);
            if (valpred > Short.MAX_VALUE) {
                valpred = Short.MAX_VALUE;
            } else if (valpred < Short.MIN_VALUE) {
                valpred = Short.MIN_VALUE;
            }
            if ((index += indexTable[delta |= sign]) < 0) {
                index = 0;
            } else if (index > 88) {
                index = 88;
            }
            step = stepsizeTable[index];
            if (bufferstep) {
                outputbuffer = delta << 4;
            } else {
                outdata[outOffset++] = (byte)(delta | outputbuffer);
            }
            bufferstep = !bufferstep;
            --len2;
        }
        if (bufferstep) {
            outdata[outOffset++] = (byte)outputbuffer;
        }
        state.valprev = valpred;
        state.index = index;
    }

    public static void decode(byte[] indata, int inOffset, byte[] outdata, int outOffset, int len2, DVIState state) {
        int index;
        int inputbuffer = 0;
        boolean bufferstep = false;
        byte[] outp = outdata;
        byte[] inp = indata;
        int valpred = state.valprev;
        int lastIndex = index = state.index;
        int[] indexTable = IMA4.indexTable;
        int[] diffLUT = IMA4.diffLUT;
        while (len2 > 0) {
            int delta;
            if (bufferstep) {
                delta = inputbuffer & 0xF;
            } else {
                inputbuffer = inp[inOffset++];
                delta = inputbuffer >> 4 & 0xF;
            }
            boolean bl = bufferstep = !bufferstep;
            if ((index += indexTable[delta]) < 0) {
                index = 0;
            } else if (index > 88) {
                index = 88;
            }
            if ((valpred += diffLUT[(lastIndex << 4) + delta]) > Short.MAX_VALUE) {
                valpred = Short.MAX_VALUE;
            } else if (valpred < Short.MIN_VALUE) {
                valpred = Short.MIN_VALUE;
            }
            lastIndex = index;
            outp[outOffset++] = (byte)valpred;
            outp[outOffset++] = (byte)(valpred >> 8);
            --len2;
        }
        state.valprev = valpred;
        state.index = index;
    }
}

