/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.audio;

import com.sun.media.multiplexer.BasicMux;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class AUMux
extends BasicMux {
    private static final int HEADER_SIZE = 24;
    private static final int UNKNOWN_ENCODING = -1;
    private AudioFormat audioFormat;
    private int sampleSizeInBits;
    private int encoding;
    private double sampleRate;
    private int channels;
    private static final int AU_SUN_MAGIC = 779316836;
    private static final int AU_ULAW_8 = 1;
    private static final int AU_ALAW_8 = 27;
    private static final int AU_LINEAR_8 = 2;
    private static final int AU_LINEAR_16 = 3;
    private static final int AU_LINEAR_24 = 4;
    private static final int AU_LINEAR_32 = 5;
    private static final int AU_FLOAT = 6;
    private static final int AU_DOUBLE = 7;
    Format bigEndian = new AudioFormat(null, -1.0, -1, -1, 1, 1);

    public AUMux() {
        this.supportedInputs = new Format[1];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("audio.basic");
    }

    public String getName() {
        return "Basic Audio Multiplexer";
    }

    public int setNumTracks(int nTracks) {
        if (nTracks != 1) {
            return 1;
        }
        return super.setNumTracks(nTracks);
    }

    protected void writeHeader() {
        this.bufClear();
        this.bufWriteInt(779316836);
        this.bufWriteInt(24);
        this.bufWriteInt(-1);
        this.bufWriteInt(this.encoding);
        this.bufWriteInt((int)this.sampleRate);
        this.bufWriteInt(this.channels);
        this.bufFlush();
    }

    public Format setInputFormat(Format format2, int trackID) {
        String reason = null;
        if (!(format2 instanceof AudioFormat)) {
            return null;
        }
        this.audioFormat = (AudioFormat)format2;
        String encodingString = this.audioFormat.getEncoding();
        this.sampleSizeInBits = this.audioFormat.getSampleSizeInBits();
        if (encodingString.equalsIgnoreCase("LINEAR")) {
            if (this.sampleSizeInBits > 8 && this.audioFormat.getEndian() == 0) {
                return null;
            }
            if (this.audioFormat.getSigned() == 0) {
                return null;
            }
            if (this.audioFormat.getEndian() == -1 || this.audioFormat.getSigned() == -1) {
                this.audioFormat = (AudioFormat)this.audioFormat.intersects(this.bigEndian);
            }
        }
        this.encoding = this.getEncoding(encodingString, this.sampleSizeInBits);
        if (this.encoding == -1) {
            reason = "No support for encoding " + encodingString;
        }
        this.sampleRate = this.audioFormat.getSampleRate();
        this.channels = this.audioFormat.getChannels();
        if (reason == null) {
            return this.audioFormat;
        }
        return null;
    }

    protected void writeFooter() {
        this.seek(8);
        this.bufClear();
        this.bufWriteInt(this.fileSize - 24);
        this.bufFlush();
    }

    private int getEncoding(String encodingString, int sampleSizeInBits) {
        if (encodingString.equalsIgnoreCase("ULAW")) {
            return 1;
        }
        if (encodingString.equalsIgnoreCase("alaw")) {
            return 27;
        }
        if (encodingString.equalsIgnoreCase("LINEAR")) {
            if (sampleSizeInBits == 8) {
                return 2;
            }
            if (sampleSizeInBits == 16) {
                return 3;
            }
            if (sampleSizeInBits == 24) {
                return 4;
            }
            if (sampleSizeInBits == 32) {
                return 5;
            }
            return -1;
        }
        if (encodingString.equalsIgnoreCase("float")) {
            return 6;
        }
        if (encodingString.equalsIgnoreCase("double")) {
            return 7;
        }
        return -1;
    }
}

