/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.audio;

import com.sun.media.format.WavAudioFormat;
import com.sun.media.multiplexer.BasicMux;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.FileTypeDescriptor;

public class WAVMux
extends BasicMux {
    private AudioFormat audioFormat;
    private WavAudioFormat wavAudioFormat;
    private int sampleSizeInBits;
    private double sampleRate;
    private int channels;
    private byte[] codecSpecificHeader;
    private short wFormatTag;
    private int blockAlign = 0;
    private int bytesPerSecond = 0;
    private int dataSizeOffset;
    private int numberOfSamplesOffset;
    private int factChunkLength = 0;
    Format signed = new AudioFormat(null, -1.0, -1, -1, 0, 1);
    Format unsigned = new AudioFormat(null, -1.0, -1, -1, 0, 0);

    public WAVMux() {
        this.supportedInputs = new Format[1];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new FileTypeDescriptor("audio.x_wav");
    }

    public String getName() {
        return "WAVE Audio Multiplexer";
    }

    public Format setInputFormat(Format input, int trackID) {
        Integer formatTag;
        if (!(input instanceof AudioFormat)) {
            return null;
        }
        AudioFormat format2 = (AudioFormat)input;
        this.sampleRate = format2.getSampleRate();
        String reason = null;
        this.audioFormat = format2;
        if (format2 instanceof WavAudioFormat) {
            this.wavAudioFormat = (WavAudioFormat)format2;
        }
        String encodingString = this.audioFormat.getEncoding();
        this.sampleSizeInBits = this.audioFormat.getSampleSizeInBits();
        if (encodingString.equalsIgnoreCase("LINEAR")) {
            if (this.sampleSizeInBits > 8) {
                if (this.audioFormat.getEndian() == 1) {
                    return null;
                }
                if (this.audioFormat.getSigned() == 0) {
                    return null;
                }
                if (this.audioFormat.getEndian() == -1 || this.audioFormat.getSigned() == -1) {
                    format2 = (AudioFormat)this.audioFormat.intersects(this.signed);
                }
            } else {
                if (this.audioFormat.getSigned() == 1) {
                    return null;
                }
                if (this.audioFormat.getEndian() == -1 || this.audioFormat.getSigned() == -1) {
                    format2 = (AudioFormat)this.audioFormat.intersects(this.unsigned);
                }
            }
        }
        if ((formatTag = (Integer)WavAudioFormat.reverseFormatMapper.get(encodingString.toLowerCase())) == null) {
            reason = "Cannot handle format";
            return null;
        }
        this.wFormatTag = formatTag.shortValue();
        switch (this.wFormatTag) {
            case 2: 
            case 17: 
            case 49: {
                if (this.wavAudioFormat != null) break;
                reason = "A WavAudioFormat is required  to provide encoding specific information for this encoding " + this.wFormatTag;
            }
        }
        if (this.wavAudioFormat != null) {
            this.codecSpecificHeader = this.wavAudioFormat.getCodecSpecificHeader();
            this.bytesPerSecond = this.wavAudioFormat.getAverageBytesPerSecond();
        }
        this.sampleRate = this.audioFormat.getSampleRate();
        this.channels = this.audioFormat.getChannels();
        if (reason != null) {
            return null;
        }
        this.inputs[0] = format2;
        return format2;
    }

    public int setNumTracks(int nTracks) {
        if (nTracks != 1) {
            return 1;
        }
        return super.setNumTracks(nTracks);
    }

    protected void writeHeader() {
        int formatSize = 16;
        this.bufClear();
        this.audioFormat = (AudioFormat)this.inputs[0];
        this.codecSpecificHeader = null;
        if (this.audioFormat instanceof WavAudioFormat) {
            this.codecSpecificHeader = ((WavAudioFormat)this.audioFormat).getCodecSpecificHeader();
        }
        if (this.codecSpecificHeader != null) {
            formatSize += 2 + this.codecSpecificHeader.length;
        } else if (this.wFormatTag == 85) {
            formatSize += 14;
        }
        this.bufWriteBytes("RIFF");
        this.bufWriteInt(0);
        this.bufWriteBytes("WAVE");
        this.bufWriteBytes("fmt ");
        this.bufWriteIntLittleEndian(formatSize);
        int frameSizeInBits = this.audioFormat.getFrameSizeInBits();
        this.blockAlign = frameSizeInBits > 0 ? frameSizeInBits / 8 : this.sampleSizeInBits / 8 * this.channels;
        this.bufWriteShortLittleEndian(this.wFormatTag);
        this.bufWriteShortLittleEndian((short)this.channels);
        this.bufWriteIntLittleEndian((int)this.sampleRate);
        int frameRate = -1;
        if (this.wFormatTag == 85) {
            this.blockAlign = 1;
            frameRate = (int)this.audioFormat.getFrameRate();
            if (frameRate != -1) {
                this.bytesPerSecond = frameRate;
            }
        }
        if (this.bytesPerSecond <= 0) {
            this.bytesPerSecond = this.channels * this.sampleSizeInBits * (int)this.sampleRate / 8;
        }
        this.bufWriteIntLittleEndian(this.bytesPerSecond);
        this.bufWriteShortLittleEndian((short)this.blockAlign);
        if (this.wFormatTag == 85) {
            this.bufWriteShortLittleEndian((short)0);
        } else {
            this.bufWriteShortLittleEndian((short)this.sampleSizeInBits);
        }
        if (this.codecSpecificHeader != null) {
            this.bufWriteShortLittleEndian((short)this.codecSpecificHeader.length);
            this.bufWriteBytes(this.codecSpecificHeader);
        } else if (this.wFormatTag == 85) {
            int blockSize;
            if (frameRate > 0) {
                float temp = 72.0f * (float)frameRate * 8.0f / 8000.0f;
                temp = (float)((double)temp * (8000.0 / this.sampleRate));
                blockSize = (int)temp;
            } else {
                blockSize = 417;
            }
            this.bufWriteShortLittleEndian((short)12);
            this.bufWriteShortLittleEndian((short)1);
            this.bufWriteIntLittleEndian(2);
            this.bufWriteShortLittleEndian((short)blockSize);
            this.bufWriteShortLittleEndian((short)1);
            this.bufWriteShortLittleEndian((short)1393);
        }
        this.factChunkLength = 0;
        if (this.wFormatTag != 1) {
            this.bufWriteBytes("fact");
            this.bufWriteIntLittleEndian(4);
            this.numberOfSamplesOffset = this.filePointer;
            this.bufWriteInt(0);
            this.factChunkLength = 12;
        }
        this.bufWriteBytes("data");
        this.dataSizeOffset = this.filePointer;
        this.bufWriteInt(0);
        this.bufFlush();
    }

    protected void writeFooter() {
        this.seek(4);
        this.bufClear();
        this.bufWriteIntLittleEndian(this.fileSize - 8);
        this.bufFlush();
        this.seek(this.dataSizeOffset);
        this.bufClear();
        int dataSize = this.fileSize - (this.dataSizeOffset + 4);
        this.bufWriteIntLittleEndian(dataSize);
        this.bufFlush();
        if (this.factChunkLength > 0) {
            float duration = (float)dataSize / (float)this.bytesPerSecond;
            int numberOfSamples = (int)((double)duration * this.sampleRate);
            this.seek(this.numberOfSamplesOffset);
            this.bufClear();
            this.bufWriteIntLittleEndian(numberOfSamples);
            this.bufFlush();
        }
    }
}

