/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser;

import com.sun.media.Log;
import com.sun.media.parser.BasicPullParser;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class BasicTrack
implements Track {
    private Format format;
    private boolean enabled = true;
    protected Time duration;
    private Time startTime;
    private int numBuffers;
    private int dataSize;
    private PullSourceStream stream;
    private long minLocation;
    private long maxLocation;
    private long maxStartLocation;
    private BasicPullParser parser;
    private long sequenceNumber = 0L;
    private TrackListener listener;
    private long seekLocation = -1L;
    private long mediaSizeAtEOM = -1L;
    private boolean warnedUserOfReadPastEOM = false;

    public BasicTrack(BasicPullParser parser, Format format2, boolean enabled, Time duration, Time startTime, int numBuffers, int dataSize, PullSourceStream stream) {
        this(parser, format2, enabled, duration, startTime, numBuffers, dataSize, stream, 0L, Long.MAX_VALUE);
    }

    public BasicTrack(BasicPullParser parser, Format format2, boolean enabled, Time duration, Time startTime, int numBuffers, int dataSize, PullSourceStream stream, long minLocation, long maxLocation) {
        this.parser = parser;
        this.format = format2;
        this.enabled = enabled;
        this.duration = duration;
        this.startTime = startTime;
        this.numBuffers = numBuffers;
        this.dataSize = dataSize;
        this.stream = stream;
        this.minLocation = minLocation;
        this.maxLocation = maxLocation;
        this.maxStartLocation = maxLocation - (long)dataSize;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setEnabled(boolean t) {
        this.enabled = t;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Time getDuration() {
        return this.duration;
    }

    public Time getStartTime() {
        return this.startTime;
    }

    public void setTrackListener(TrackListener l2) {
        this.listener = l2;
    }

    public synchronized void setSeekLocation(long location) {
        this.seekLocation = location;
    }

    public synchronized long getSeekLocation() {
        return this.seekLocation;
    }

    public void readFrame(Buffer buffer) {
        byte[] data;
        boolean needToSeek;
        long location;
        if (buffer == null) {
            return;
        }
        if (!this.enabled) {
            buffer.setDiscard(true);
            return;
        }
        buffer.setFormat(this.format);
        Object obj = buffer.getData();
        BasicTrack basicTrack = this;
        synchronized (basicTrack) {
            if (this.seekLocation != -1L) {
                location = this.seekLocation;
                if (this.seekLocation < this.maxLocation) {
                    this.seekLocation = -1L;
                }
                needToSeek = true;
            } else {
                location = this.parser.getLocation(this.stream);
                needToSeek = false;
            }
        }
        if (location < this.minLocation) {
            buffer.setDiscard(true);
            return;
        }
        if (location >= this.maxLocation) {
            buffer.setLength(0);
            buffer.setEOM(true);
            return;
        }
        int needDataSize = location > this.maxStartLocation ? this.dataSize - (int)(location - this.maxStartLocation) : this.dataSize;
        if (obj == null || !(obj instanceof byte[]) || ((byte[])obj).length < needDataSize) {
            data = new byte[needDataSize];
            buffer.setData(data);
        } else {
            data = (byte[])obj;
        }
        try {
            long pos;
            if (this.parser.cacheStream != null && this.listener != null && this.parser.cacheStream.willReadBytesBlock(location, needDataSize)) {
                this.listener.readHasBlocked(this);
            }
            if (needToSeek && (pos = ((Seekable)((Object)this.stream)).seek(location)) == -2L) {
                buffer.setDiscard(true);
                return;
            }
            if (this.parser.getMediaTime() != null) {
                buffer.setTimeStamp(this.parser.getMediaTime().getNanoseconds());
            } else {
                buffer.setTimeStamp(-1L);
            }
            buffer.setDuration(-1L);
            int actualBytesRead = this.parser.readBytes(this.stream, data, needDataSize);
            buffer.setOffset(0);
            buffer.setLength(actualBytesRead);
            buffer.setSequenceNumber(++this.sequenceNumber);
        }
        catch (IOException e2) {
            if (this.maxLocation != Long.MAX_VALUE) {
                if (!this.warnedUserOfReadPastEOM) {
                    Log.warning("Warning: Attempt to read past End of Media");
                    Log.warning("This typically happens if the duration is not known or");
                    Log.warning("if the media file has incorrect header info");
                    this.warnedUserOfReadPastEOM = true;
                }
                buffer.setLength(0);
                buffer.setEOM(true);
            }
            long length = this.parser.streams[0].getContentLength();
            if (length != -1L) {
                this.maxLocation = length;
                this.maxStartLocation = this.maxLocation - (long)this.dataSize;
                this.mediaSizeAtEOM = this.maxLocation - this.minLocation;
                buffer.setLength(0);
                buffer.setDiscard(true);
            }
            this.maxLocation = this.parser.getLocation(this.stream);
            this.maxStartLocation = this.maxLocation - (long)this.dataSize;
            this.mediaSizeAtEOM = this.maxLocation - this.minLocation;
            buffer.setLength(0);
            buffer.setEOM(true);
        }
    }

    public int mapTimeToFrame(Time t) {
        return Integer.MAX_VALUE;
    }

    public Time mapFrameToTime(int frameNumber) {
        return Track.TIME_UNKNOWN;
    }

    public long getMediaSizeAtEOM() {
        return this.mediaSizeAtEOM;
    }
}

