/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.ExtBuffer;
import com.sun.media.renderer.video.HeavyComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;

public abstract class BasicVideoRenderer
extends BasicPlugIn
implements VideoRenderer,
FrameGrabbingControl {
    protected String name;
    protected transient VideoFormat[] supportedFormats = null;
    protected VideoFormat inputFormat = null;
    protected int outWidth = -1;
    protected int outHeight = -1;
    protected int inWidth = -1;
    protected int inHeight = -1;
    protected Component component = null;
    protected ComponentListener compListener = null;
    protected boolean componentAvailable = false;
    protected Rectangle bounds = null;
    protected boolean started = false;
    protected Control[] controls = null;
    protected FrameGrabbingControl frameGrabber = null;
    protected ExtBuffer lastBuffer = new ExtBuffer();
    protected Object lastData = null;
    protected Object lastHdr = null;

    public BasicVideoRenderer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedFormats;
    }

    public void open() throws ResourceUnavailableException {
    }

    public void close() {
    }

    public void reset() {
    }

    public int process(Buffer inbuffer) {
        int result2;
        if (inbuffer.getLength() == 0) {
            return 0;
        }
        ExtBuffer extBuffer = this.lastBuffer;
        synchronized (extBuffer) {
            result2 = this.doProcess(inbuffer);
            if (result2 == 0) {
                this.lastBuffer.copy(inbuffer, true);
            }
        }
        return result2;
    }

    protected abstract int doProcess(Buffer var1);

    public Format setInputFormat(Format format2) {
        if (BasicPlugIn.matches(format2, this.supportedFormats) != null) {
            this.inputFormat = (VideoFormat)format2;
            Dimension size = this.inputFormat.getSize();
            if (size != null) {
                this.inWidth = size.width;
                this.inHeight = size.height;
            }
            return format2;
        }
        return null;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public Component getComponent() {
        if (this.component == null) {
            try {
                Class<?> mshc = Class.forName("com.sun.media.renderer.video.MSHeavyComponent");
                if (mshc != null) {
                    this.component = (Component)mshc.newInstance();
                }
            }
            catch (Throwable t) {
                this.component = new HeavyComponent();
            }
            ((HeavyComponent)this.component).setRenderer(this);
            this.component.setBackground(this.getPreferredBackground());
            if (this.compListener == null) {
                this.compListener = new CompListener();
            }
            this.component.addComponentListener(this.compListener);
        }
        return this.component;
    }

    public synchronized boolean setComponent(Component comp) {
        this.reset();
        this.component = comp;
        if (this.compListener == null) {
            this.compListener = new CompListener();
        }
        this.component.addComponentListener(this.compListener);
        return true;
    }

    public void setBounds(Rectangle rect) {
        this.bounds = rect;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    protected Color getPreferredBackground() {
        return Color.black;
    }

    void resized(Component c2) {
        if (c2 != null && c2 == this.component) {
            Dimension d2 = this.component.getSize();
            this.outWidth = d2.width;
            this.outHeight = d2.height;
        }
    }

    protected synchronized void setAvailable(boolean on) {
        this.componentAvailable = on;
        if (!this.componentAvailable) {
            this.removingComponent();
        }
    }

    protected void removingComponent() {
    }

    protected Dimension myPreferredSize() {
        return new Dimension(this.inWidth, this.inHeight);
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected void repaint() {
        System.err.println("repaint call not implemented on this renderer");
    }

    public Object[] getControls() {
        if (this.controls != null) {
            return this.controls;
        }
        this.frameGrabber = this;
        this.controls = new Control[1];
        this.controls[0] = this.frameGrabber;
        return this.controls;
    }

    public Component getControlComponent() {
        return null;
    }

    public Buffer grabFrame() {
        ExtBuffer extBuffer = this.lastBuffer;
        synchronized (extBuffer) {
            Object[] newData;
            Buffer newBuffer = new Buffer();
            newBuffer.setFormat(this.lastBuffer.getFormat());
            newBuffer.setFlags(this.lastBuffer.getFlags());
            newBuffer.setLength(this.lastBuffer.getLength());
            newBuffer.setOffset(0);
            newBuffer.setHeader(this.lastBuffer.getHeader());
            newBuffer.setData(this.lastBuffer.getData());
            Object data = this.lastBuffer.getData();
            int length = this.lastBuffer.getLength();
            if (data instanceof byte[]) {
                newData = new byte[length];
            } else if (data instanceof short[]) {
                newData = new short[length];
            } else if (data instanceof int[]) {
                newData = new int[length];
            } else {
                Buffer buffer = newBuffer;
                return buffer;
            }
            System.arraycopy(data, this.lastBuffer.getOffset(), newData, 0, length);
            newBuffer.setData(newData);
            Buffer buffer = newBuffer;
            return buffer;
        }
    }

    public class CompListener
    extends ComponentAdapter {
        public void componentResized(ComponentEvent ce) {
            BasicVideoRenderer.this.resized(ce.getComponent());
        }
    }
}

