/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtsp.protocol;

import com.sun.media.rtsp.protocol.Debug;
import com.sun.media.rtsp.protocol.DescribeMessage;
import com.sun.media.rtsp.protocol.MessageType;
import com.sun.media.rtsp.protocol.OptionsMessage;
import com.sun.media.rtsp.protocol.PauseMessage;
import com.sun.media.rtsp.protocol.PlayMessage;
import com.sun.media.rtsp.protocol.ResponseMessage;
import com.sun.media.rtsp.protocol.SetParameterMessage;
import com.sun.media.rtsp.protocol.SetupMessage;
import com.sun.media.rtsp.protocol.TeardownMessage;
import java.util.StringTokenizer;

public class Message {
    private byte[] data;
    private int type;
    private Object parameter;

    public Message(int type2, Object parameter) {
    }

    public Message(byte[] data) {
        this.data = data;
        this.parseData();
    }

    private void parseData() {
        StringTokenizer st = new StringTokenizer(new String(this.data));
        this.type = new MessageType(st.nextToken()).getType();
        switch (this.type) {
            case 1: {
                this.parameter = new DescribeMessage(this.data);
                break;
            }
            case 9: {
                this.parameter = new SetupMessage(this.data);
                break;
            }
            case 6: {
                this.parameter = new PlayMessage(this.data);
                break;
            }
            case 5: {
                this.parameter = new PauseMessage(this.data);
                break;
            }
            case 11: {
                this.parameter = new TeardownMessage(this.data);
                break;
            }
            case 4: {
                this.parameter = new OptionsMessage(this.data);
                break;
            }
            case 12: {
                this.parameter = new ResponseMessage(this.data);
                break;
            }
            case 10: {
                this.parameter = new SetParameterMessage(this.data);
                break;
            }
            default: {
                Debug.println("Unknown msg type: " + this.type);
                Debug.println("Unknown msg type: " + new String(this.data));
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public Object getParameter() {
        return this.parameter;
    }
}

