/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.BasicPlayer;
import com.sun.media.ui.ColumnList;
import com.sun.media.ui.TabControl;
import com.sun.media.ui.UrlLabel;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.media.CachingControl;
import javax.media.Control;
import javax.media.Controller;
import javax.media.Duration;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.Player;
import javax.media.Time;
import javax.media.control.BitRateControl;
import javax.media.control.FormatControl;
import javax.media.control.FrameRateControl;
import javax.media.control.MonitorControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.SourceStream;

public class PropertySheet
extends Dialog
implements WindowListener,
ActionListener {
    private Player player;
    private Vector vectorControlBitRate = new Vector(1);
    private Vector vectorLabelBitRate = new Vector(1);
    private FrameRateControl controlFrameRate = null;
    private Vector vectorTrackFormats = new Vector();
    private int nAudioTrackCount = 0;
    private int nVideoTrackCount = 0;
    private Vector vectorMiscControls = new Vector();
    private Button buttonClose;
    private Label labelDuration = null;
    private Label labelPosition = null;
    private Label labelBitRate = null;
    private Label labelFrameRate = null;
    private ColumnList columnListAudio;
    private ColumnList columnListVideo;
    private static final String STR_UNKNOWN = JMFI18N.getResource("propertysheet.unknown");
    private static final String STR_UNBOUNDED = JMFI18N.getResource("propertysheet.unbounded");

    public PropertySheet(Frame parent, Player player) {
        super(parent, JMFI18N.getResource("propertysheet.title"), false);
        this.player = player;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(5, 5));
        ((Component)this).setBackground(Color.lightGray);
        Panel panel = this.createPanelButtons();
        this.add((Component)panel, "South");
        panel = this.createPanelProperties();
        this.add((Component)panel, "Center");
        Canvas canvas = new Canvas();
        this.add((Component)canvas, "North");
        canvas = new Canvas();
        this.add((Component)canvas, "East");
        canvas = new Canvas();
        this.add((Component)canvas, "West");
        this.pack();
        this.addWindowListener(this);
        this.setResizable(false);
        Dimension dim = this.getPreferredSize();
        if (dim.width > 480) {
            dim.width = 480;
        }
        ((Component)this).setBounds(100, 100, dim.width, dim.height);
        this.repaint();
    }

    private Panel createPanelProperties() throws Exception {
        TabControl tabControl = new TabControl(0);
        Panel panel = this.createPanelGeneral();
        tabControl.addPage(panel, JMFI18N.getResource("propertysheet.tab.general"));
        if (this.nVideoTrackCount > 0) {
            panel = this.createPanelVideo(this.vectorTrackFormats);
            tabControl.addPage(panel, JMFI18N.getResource("propertysheet.tab.video"));
        }
        if (this.nAudioTrackCount > 0) {
            panel = this.createPanelAudio(this.vectorTrackFormats);
            tabControl.addPage(panel, JMFI18N.getResource("propertysheet.tab.audio"));
        }
        if (!this.vectorMiscControls.isEmpty()) {
            panel = this.createPanelMisc();
            tabControl.addPage(panel, JMFI18N.getResource("propertysheet.tab.misc"));
        }
        this.update();
        return tabControl;
    }

    private Panel createPanelGeneral() throws Exception {
        Label label;
        String strValue = null;
        Panel panelGeneral = new Panel(new BorderLayout());
        Panel panel = new Panel(new BorderLayout(8, 4));
        panelGeneral.add((Component)panel, "North");
        Panel panelLabels = new Panel(new GridLayout(0, 1, 4, 4));
        panel.add((Component)panelLabels, "West");
        Panel panelData = new Panel(new GridLayout(0, 1, 4, 4));
        panel.add((Component)panelData, "Center");
        if (this.player instanceof BasicPlayer) {
            BasicPlayer playerBasic = (BasicPlayer)this.player;
            MediaLocator mediaLocator = playerBasic.getMediaLocator();
            if (mediaLocator != null) {
                strValue = mediaLocator.toString();
            }
            if (strValue != null) {
                label = new Label(JMFI18N.getResource("propertysheet.general.medialocation"), 2);
                panelLabels.add(label);
                UrlLabel labelUrl = new UrlLabel(strValue);
                panelData.add(labelUrl);
            }
            if ((strValue = playerBasic.getContentType()) != null) {
                strValue = new ContentDescriptor(strValue).toString();
                label = new Label(JMFI18N.getResource("propertysheet.general.contenttype"), 2);
                panelLabels.add(label);
                label = new Label(strValue);
                panelData.add(label);
            }
        }
        label = new Label(JMFI18N.getResource("propertysheet.general.duration"), 2);
        panelLabels.add(label);
        this.labelDuration = new Label();
        panelData.add(this.labelDuration);
        label = new Label(JMFI18N.getResource("propertysheet.general.position"), 2);
        panelLabels.add(label);
        this.labelPosition = new Label();
        panelData.add(this.labelPosition);
        this.nAudioTrackCount = 0;
        this.nVideoTrackCount = 0;
        Control[] arrControls = this.player.getControls();
        int i2 = 0;
        while (i2 < arrControls.length) {
            if (arrControls[i2] != null) {
                if (arrControls[i2] instanceof FormatControl && (!(arrControls[i2] instanceof Owned) || !(((Owned)((Object)arrControls[i2])).getOwner() instanceof SourceStream) && !(((Owned)((Object)arrControls[i2])).getOwner() instanceof DataSource))) {
                    Format format2 = ((FormatControl)arrControls[i2]).getFormat();
                    this.vectorTrackFormats.addElement(format2);
                    if (format2 instanceof AudioFormat) {
                        ++this.nAudioTrackCount;
                    } else if (format2 instanceof VideoFormat) {
                        ++this.nVideoTrackCount;
                    }
                }
                if (!(arrControls[i2] instanceof TrackControl)) {
                    if (arrControls[i2] instanceof BitRateControl) {
                        BitRateControl controlBitRateTemp = (BitRateControl)arrControls[i2];
                        if (controlBitRateTemp instanceof Owned && ((Owned)((Object)controlBitRateTemp)).getOwner() instanceof Controller) {
                            this.vectorControlBitRate.addElement(controlBitRateTemp);
                            label = new Label(JMFI18N.getResource("propertysheet.general.bitrate"), 2);
                            panelLabels.add(label);
                            this.labelBitRate = new Label();
                            this.vectorLabelBitRate.addElement(this.labelBitRate);
                            panelData.add(this.labelBitRate);
                        } else {
                            this.vectorMiscControls.addElement(arrControls[i2]);
                        }
                    } else if (arrControls[i2] instanceof FrameRateControl) {
                        FrameRateControl controlFrameRateTemp = (FrameRateControl)arrControls[i2];
                        if (controlFrameRateTemp instanceof Owned && ((Owned)((Object)controlFrameRateTemp)).getOwner() instanceof Controller) {
                            this.controlFrameRate = controlFrameRateTemp;
                            label = new Label(JMFI18N.getResource("propertysheet.general.framerate"), 2);
                            panelLabels.add(label);
                            this.labelFrameRate = new Label();
                            panelData.add(this.labelFrameRate);
                        } else {
                            this.vectorMiscControls.addElement(arrControls[i2]);
                        }
                    } else if (!(arrControls[i2] instanceof GainControl || arrControls[i2] instanceof MonitorControl || arrControls[i2] instanceof Owned && (((Owned)((Object)arrControls[i2])).getOwner() instanceof CaptureDevice || ((Owned)((Object)arrControls[i2])).getOwner() instanceof SourceStream || ((Owned)((Object)arrControls[i2])).getOwner() instanceof DataSource) || arrControls[i2] instanceof CachingControl)) {
                        this.vectorMiscControls.addElement(arrControls[i2]);
                    }
                }
            }
            ++i2;
        }
        return panelGeneral;
    }

    private Panel createPanelVideo(Vector vectorFormats) throws Exception {
        String[] arrColumnNames = new String[]{JMFI18N.getResource("propertysheet.video.track"), JMFI18N.getResource("propertysheet.video.encoding"), JMFI18N.getResource("propertysheet.video.size"), JMFI18N.getResource("propertysheet.video.framerate")};
        Panel panelVideo = new Panel(new BorderLayout());
        this.columnListVideo = new ColumnList(arrColumnNames);
        Object[] arrValues = new String[arrColumnNames.length];
        int nCount = vectorFormats.size();
        int nTrackIndex = 0;
        int i2 = 0;
        while (i2 < nCount) {
            Object objectFormat = vectorFormats.elementAt(i2);
            if (objectFormat instanceof VideoFormat) {
                VideoFormat formatVideo = (VideoFormat)objectFormat;
                arrValues[0] = new String("" + ++nTrackIndex);
                arrValues[1] = formatVideo.getEncoding();
                Dimension dimSize = formatVideo.getSize();
                arrValues[2] = dimSize == null ? new String(STR_UNKNOWN) : new String("" + dimSize.width + " x " + dimSize.height);
                float fValue = formatVideo.getFrameRate();
                arrValues[3] = fValue == -1.0f ? STR_UNKNOWN : "" + fValue;
                this.columnListVideo.addRow(arrValues);
            }
            ++i2;
        }
        this.columnListVideo.setColumnWidthAsPreferred();
        panelVideo.add((Component)this.columnListVideo, "Center");
        return panelVideo;
    }

    private Panel createPanelAudio(Vector vectorFormats) throws Exception {
        String[] arrColumnNames = new String[]{JMFI18N.getResource("propertysheet.audio.track"), JMFI18N.getResource("propertysheet.audio.encoding"), JMFI18N.getResource("propertysheet.audio.samplerate"), JMFI18N.getResource("propertysheet.audio.bitspersample"), JMFI18N.getResource("propertysheet.audio.channels")};
        Panel panelAudio = new Panel(new BorderLayout());
        this.columnListAudio = new ColumnList(arrColumnNames);
        Object[] arrValues = new String[arrColumnNames.length];
        int nCount = vectorFormats.size();
        int nTrackIndex = 0;
        int i2 = 0;
        while (i2 < nCount) {
            Object objectFormat = vectorFormats.elementAt(i2);
            if (objectFormat instanceof AudioFormat) {
                AudioFormat formatAudio = (AudioFormat)objectFormat;
                arrValues[0] = new String("" + ++nTrackIndex);
                arrValues[1] = formatAudio.getEncoding();
                double dValue = formatAudio.getSampleRate();
                arrValues[2] = dValue == -1.0 ? STR_UNKNOWN : "" + dValue;
                int nValue = formatAudio.getSampleSizeInBits();
                arrValues[3] = nValue == -1 ? STR_UNKNOWN : "" + nValue;
                nValue = formatAudio.getChannels();
                arrValues[4] = nValue == -1 ? STR_UNKNOWN : (nValue == 1 ? "" + nValue + " (" + JMFI18N.getResource("propertysheet.audio.channels.mono") + ")" : (nValue == 2 ? "" + nValue + " (" + JMFI18N.getResource("propertysheet.audio.channels.stereo") + ")" : "" + nValue));
                this.columnListAudio.addRow(arrValues);
            }
            ++i2;
        }
        this.columnListAudio.setColumnWidthAsPreferred();
        panelAudio.add((Component)this.columnListAudio, "Center");
        return panelAudio;
    }

    private Panel createPanelMisc() throws Exception {
        Panel panelMisc;
        Panel panel = panelMisc = new Panel(new BorderLayout(6, 6));
        int nSize = this.vectorMiscControls.size();
        int i2 = 0;
        while (i2 < nSize) {
            Control control = (Control)this.vectorMiscControls.elementAt(i2);
            Component comp = control.getControlComponent();
            if (comp != null && comp.getParent() == null) {
                Panel panelControl = new Panel(new BorderLayout(6, 6));
                panelControl.add(comp, "West");
                Panel panelNext = new Panel(new BorderLayout(6, 6));
                panelNext.add((Component)panelControl, "North");
                panel.add((Component)panelNext, "Center");
                panel = panelNext;
            }
            ++i2;
        }
        return panelMisc;
    }

    private Panel createPanelButtons() throws Exception {
        Panel panelButtons = new Panel(new FlowLayout(2));
        Panel panel = new Panel(new GridLayout(1, 0, 6, 6));
        panelButtons.add(panel);
        this.buttonClose = new Button(JMFI18N.getResource("propertysheet.close"));
        this.buttonClose.addActionListener(this);
        panel.add(this.buttonClose);
        return panelButtons;
    }

    public void actionPerformed(ActionEvent e2) {
        String strCmd = e2.getActionCommand();
        if (strCmd.equals(this.buttonClose.getLabel())) {
            ((Component)this).setVisible(false);
        }
    }

    public void windowOpened(WindowEvent e2) {
    }

    public void windowClosing(WindowEvent e2) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent e2) {
    }

    public void windowIconified(WindowEvent e2) {
    }

    public void windowDeiconified(WindowEvent e2) {
    }

    public void windowActivated(WindowEvent e2) {
    }

    public void windowDeactivated(WindowEvent e2) {
    }

    void update() {
        this.updateBitRate();
        this.updateFrameRate();
        this.updateMediaTime();
        this.updateDuration();
    }

    void updateDuration() {
        if (this.labelDuration != null) {
            Time timeDuration = this.player.getDuration();
            this.labelDuration.setText(this.formatTime(timeDuration));
        }
    }

    void updateBitRate() {
        if (this.vectorLabelBitRate.size() > 0) {
            int i2 = 0;
            while (i2 < this.vectorLabelBitRate.size()) {
                Label labelBitRate = (Label)this.vectorLabelBitRate.elementAt(i2);
                BitRateControl controlBitRate = (BitRateControl)this.vectorControlBitRate.elementAt(i2);
                int bitRate = controlBitRate.getBitRate();
                labelBitRate.setText(Float.toString((float)bitRate / 1000.0f) + " " + JMFI18N.getResource("propertysheet.kbps"));
                ++i2;
            }
        }
    }

    void updateFrameRate() {
        if (this.labelFrameRate != null && this.controlFrameRate != null) {
            float frameRate = this.controlFrameRate.getFrameRate();
            this.labelFrameRate.setText(Float.toString(frameRate) + " " + JMFI18N.getResource("propertysheet.fps"));
        }
    }

    void clearBRFR() {
        if (this.labelFrameRate != null) {
            this.labelFrameRate.setText("0.0 " + JMFI18N.getResource("propertysheet.fps"));
        }
        if (this.labelBitRate != null) {
            this.labelBitRate.setText("0.0 " + JMFI18N.getResource("propertysheet.kbps"));
        }
    }

    void updateMediaTime() {
        if (this.labelPosition != null) {
            Time timeMedia = this.player.getMediaTime();
            this.labelPosition.setText(this.formatTime(timeMedia));
        }
    }

    private String formatTime(Time time) {
        String strTime = new String(STR_UNKNOWN);
        if (time == null || time == Time.TIME_UNKNOWN || time == Duration.DURATION_UNKNOWN) {
            return strTime;
        }
        if (time == Duration.DURATION_UNBOUNDED) {
            return STR_UNBOUNDED;
        }
        long nano = time.getNanoseconds();
        int seconds = (int)(nano / 1000000000L);
        int hours = seconds / 3600;
        int minutes = (seconds - hours * 3600) / 60;
        seconds = seconds - hours * 3600 - minutes * 60;
        nano = nano % 1000000000L / 10000000L;
        int hours10 = hours / 10;
        int minutes10 = minutes / 10;
        int seconds10 = seconds / 10;
        long nano10 = nano / 10L;
        strTime = new String("" + hours10 + (hours %= 10) + ":" + minutes10 + (minutes %= 10) + ":" + seconds10 + (seconds %= 10) + "." + nano10 + (nano %= 10L));
        return strTime;
    }
}

