/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.util.io.ByteArrayBitInputStream;
import java.io.IOException;

public class FlacFormatException
extends IOException {
    private ByteArrayBitInputStream source;

    public FlacFormatException() {
    }

    public FlacFormatException(String message) {
        super(message);
    }

    public FlacFormatException(String message, ByteArrayBitInputStream source) {
        super(message);
        this.source = source;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this.source != null) {
            int i2 = 0;
            while (i2 < this.source.getSource().length) {
                int lineEnd = i2 + 8;
                while (i2 < lineEnd && i2 < this.source.getSource().length) {
                    String val = Integer.toBinaryString(this.source.getSource()[i2] & 0xFF);
                    while (val.length() < 8) {
                        val = "0" + val;
                    }
                    System.err.print(val + " ");
                    ++i2;
                }
                System.err.println();
            }
        }
    }
}

