/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import de.jarnbjo.flac.FlacStream;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class FlacDecoder
implements Codec {
    private static final String CODEC_NAME = "Flac decoder";
    private static final Format[] supportedInputFormats = new Format[]{new AudioFormat("audio/x-flac", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray), new AudioFormat("audio/flac", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    private static final Format[] supportedOutputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, -1, -1, -1, -1, -1, -1.0, Format.byteArray)};
    private final FlacStream flacStream = new FlacStream();

    @Override
    public Format[] getSupportedInputFormats() {
        return supportedInputFormats;
    }

    @Override
    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return supportedOutputFormats;
        }
        Format[] res = new AudioFormat[]{new AudioFormat("LINEAR", ((AudioFormat)input).getSampleRate(), ((AudioFormat)input).getSampleSizeInBits(), ((AudioFormat)input).getChannels(), 1, 1, -1, -1.0, Format.byteArray)};
        return res;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        try {
            byte[] res = this.flacStream.processPacket((byte[])in.getData());
            if (res == null) {
                return 4;
            }
            byte[] buffer = (byte[])out.getData();
            if (buffer == null || res.length > buffer.length) {
                out.setData(res);
            } else {
                System.arraycopy(res, 0, buffer, 0, res.length);
            }
            out.setOffset(0);
            out.setLength(res.length);
            return 0;
        }
        catch (IOException e2) {
            return 1;
        }
    }

    @Override
    public Format setInputFormat(Format format2) {
        return format2;
    }

    @Override
    public Format setOutputFormat(Format format2) {
        return format2;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void reset() {
    }

    @Override
    public String getName() {
        return CODEC_NAME;
    }

    @Override
    public Object getControl(String controlType) {
        return null;
    }

    @Override
    public Object[] getControls() {
        return null;
    }
}

