/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import de.jarnbjo.jmf.OggJmfPage;
import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class OggJmfStream
implements PhysicalOggStream {
    private boolean closed = false;
    private final PullSourceStream source;
    private final long[] pageOffsets;
    private final HashMap<Integer, LogicalOggStreamImpl> logicalStreams = new HashMap();

    /*
     * WARNING - void declaration
     */
    public OggJmfStream(PullSourceStream source) throws OggFormatException, FileNotFoundException, IOException {
        this.source = source;
        if (!(source instanceof Seekable)) {
            throw new OggFormatException("The source stream must be seekable.");
        }
        ArrayList<Long> po = new ArrayList<Long>();
        int pageNumber = 0;
        try {
            while (true) {
                void var6_8;
                long startPos = ((Seekable)((Object)source)).tell();
                po.add(((Seekable)((Object)source)).tell());
                OggPage oggPage = this.getNextPage(true);
                ((Seekable)((Object)source)).seek(((Seekable)((Object)source)).tell() + (long)oggPage.getTotalLength());
                LogicalOggStreamImpl los = (LogicalOggStreamImpl)this.getLogicalStream(oggPage.getStreamSerialNumber());
                if (los == null) {
                    los = new LogicalOggStreamImpl(this, oggPage.getStreamSerialNumber());
                    this.logicalStreams.put(oggPage.getStreamSerialNumber(), los);
                    ((Seekable)((Object)source)).seek(startPos);
                    OggPage oggPage2 = this.getNextPage();
                    los.checkFormat(oggPage2);
                }
                los.addPageNumberMapping(pageNumber);
                los.addGranulePosition(var6_8.getAbsoluteGranulePosition());
                ++pageNumber;
            }
        }
        catch (EndOfOggStreamException startPos) {
        }
        catch (IOException e2) {
            throw e2;
        }
        ((Seekable)((Object)source)).seek(0L);
        this.pageOffsets = new long[po.size()];
        int i2 = 0;
        for (Object e2 : po) {
            this.pageOffsets[i2++] = (Long)e2;
        }
    }

    @Override
    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    private OggPage getNextPage() throws IOException {
        return this.getNextPage(false);
    }

    private OggPage getNextPage(boolean skipData) throws IOException {
        return OggJmfPage.create(this.source, skipData);
    }

    @Override
    public OggPage getOggPage(int index) throws IOException {
        ((Seekable)((Object)this.source)).seek(this.pageOffsets[index]);
        return OggJmfPage.create(this.source);
    }

    public LogicalOggStream getLogicalStream(int serialNumber) {
        return this.logicalStreams.get(serialNumber);
    }

    @Override
    public void setTime(long granulePosition) throws IOException {
        for (LogicalOggStreamImpl o2 : this.logicalStreams.values()) {
            LogicalOggStream los = o2;
            los.setTime(granulePosition);
        }
    }

    @Override
    public boolean isSeekable() {
        return true;
    }
}

