/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import de.jarnbjo.jmf.FlacTrack;
import de.jarnbjo.jmf.OggJmfStream;
import de.jarnbjo.jmf.OggTrack;
import de.jarnbjo.jmf.VorbisTrack;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.OggFormatException;
import de.jarnbjo.ogg.PhysicalOggStream;
import de.jarnbjo.vorbis.VorbisFormatException;
import java.io.IOException;
import java.util.Collection;
import javax.media.BadHeaderException;
import javax.media.Demultiplexer;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class OggParser
implements Demultiplexer {
    private static final String DEMULTIPLEXER_NAME = "Ogg demultiplexer";
    private final ContentDescriptor[] supportedContentTypes = new ContentDescriptor[]{new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName("application/ogg")), new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName("application/x-ogg"))};
    private Track[] tracks;
    private PullDataSource source;
    private PullSourceStream stream;
    private PhysicalOggStream oggStream;

    @Override
    public Time getDuration() {
        if (this.tracks == null) {
            return Time.TIME_UNKNOWN;
        }
        long max2 = 0L;
        for (Track track : this.tracks) {
            if (track.getDuration().getNanoseconds() <= max2) continue;
            max2 = track.getDuration().getNanoseconds();
        }
        return new Time(max2);
    }

    @Override
    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedContentTypes;
    }

    @Override
    public Track[] getTracks() throws BadHeaderException, IOException {
        if (this.tracks == null) {
            try {
                Collection coll = this.oggStream.getLogicalStreams();
                this.tracks = new Track[coll.size()];
                int i2 = 0;
                for (LogicalOggStream los : coll) {
                    System.out.println("type: " + los.getFormat());
                    this.tracks[i2] = OggTrack.createInstance(los);
                    ++i2;
                }
            }
            catch (OggFormatException | VorbisFormatException e2) {
                throw new BadHeaderException(e2.getMessage());
            }
        }
        return this.tracks;
    }

    @Override
    public boolean isPositionable() {
        return true;
    }

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public Time getMediaTime() {
        return Time.TIME_UNKNOWN;
    }

    @Override
    public Time setPosition(Time time, int rounding) {
        try {
            if (this.tracks[0] instanceof VorbisTrack) {
                long sampleRate = ((VorbisTrack)this.tracks[0]).getSampleRate();
                this.oggStream.setTime(time.getNanoseconds() * sampleRate / 1000000000L);
            } else if (this.tracks[0] instanceof FlacTrack) {
                long sampleRate = ((FlacTrack)this.tracks[0]).getSampleRate();
                this.oggStream.setTime(time.getNanoseconds() * sampleRate / 1000000000L);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return Time.TIME_UNKNOWN;
    }

    @Override
    public void start() throws IOException {
        if (this.source != null) {
            this.source.start();
        }
    }

    @Override
    public void stop() {
        if (this.source != null) {
            try {
                this.source.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    @Override
    public void reset() {
        this.setPosition(new Time(0L), 0);
    }

    @Override
    public String getName() {
        return DEMULTIPLEXER_NAME;
    }

    @Override
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        try {
            if (!(source instanceof PullDataSource)) {
                throw new IncompatibleSourceException("DataSource not supported: " + source);
            }
            this.source = (PullDataSource)source;
            if (this.source.getStreams() == null || this.source.getStreams().length == 0) {
                throw new IOException("DataSource has no streams.");
            }
            if (this.source.getStreams().length > 1) {
                throw new IOException("This demultiplexer only supports data sources with one stream.");
            }
            this.stream = this.source.getStreams()[0];
            this.oggStream = new OggJmfStream(this.stream);
            if (!(this.stream instanceof Seekable)) {
                throw new IncompatibleSourceException("Stream is not seekable.");
            }
        }
        catch (IOException | RuntimeException | IncompatibleSourceException e2) {
            e2.printStackTrace();
            throw e2;
        }
    }

    @Override
    public Object getControl(String controlType) {
        return null;
    }

    @Override
    public Object[] getControls() {
        return new Object[0];
    }
}

