/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jmf;

import de.jarnbjo.jmf.OggTrack;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.theora.Header;
import de.jarnbjo.util.io.ByteArrayBitInputStream;
import java.awt.Dimension;
import java.io.IOException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.format.VideoFormat;

public class TheoraTrack
extends OggTrack {
    private final LogicalOggStream oggStream;
    private final VideoFormat format;
    private final Header header;

    public TheoraTrack(LogicalOggStream source, byte[] idHeaderData) throws IOException {
        super(source);
        this.oggStream = source;
        ByteArrayBitInputStream bd = new ByteArrayBitInputStream(idHeaderData, 1);
        this.header = new Header(bd);
        this.format = new VideoFormat("THEORA", new Dimension(this.header.getWidth(), this.header.getHeight()), -1, Format.byteArray, (float)this.header.getFrameRate());
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    @Override
    public Time getDuration() {
        long frame = this.oggStream.getMaximumGranulePosition() >> 6;
        return frame == -1L ? Duration.DURATION_UNKNOWN : new Time((double)frame / this.header.getFrameRate());
    }
}

