/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.ogg;

import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.ogg.LogicalOggStreamImpl;
import de.jarnbjo.ogg.OggPage;
import de.jarnbjo.ogg.PhysicalOggStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class OnDemandUrlStream
implements PhysicalOggStream {
    private boolean closed = false;
    private final URLConnection source;
    private final InputStream sourceStream;
    private final Object drainLock = new Object();
    private final LinkedList pageCache = new LinkedList();
    private int contentLength = 0;
    private int position = 0;
    private final HashMap<Integer, LogicalOggStream> logicalStreams = new HashMap();
    private OggPage firstPage;
    private static final int PAGECACHE_SIZE = 20;
    int pageNumber = 2;

    public OnDemandUrlStream(URL source) throws IOException {
        this.source = source.openConnection();
        this.sourceStream = this.source.getInputStream();
        this.contentLength = this.source.getContentLength();
        this.firstPage = OggPage.create(this.sourceStream);
        this.position += this.firstPage.getTotalLength();
        LogicalOggStreamImpl los = new LogicalOggStreamImpl(this, this.firstPage.getStreamSerialNumber());
        this.logicalStreams.put(this.firstPage.getStreamSerialNumber(), los);
        los.checkFormat(this.firstPage);
    }

    @Override
    public Collection getLogicalStreams() {
        return this.logicalStreams.values();
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.sourceStream.close();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public OggPage getOggPage(int index) throws IOException {
        if (this.firstPage != null) {
            OggPage tmp = this.firstPage;
            this.firstPage = null;
            return tmp;
        }
        OggPage page = OggPage.create(this.sourceStream);
        this.position += page.getTotalLength();
        return page;
    }

    private LogicalOggStream getLogicalStream(int serialNumber) {
        return this.logicalStreams.get(serialNumber);
    }

    @Override
    public void setTime(long granulePosition) throws IOException {
        throw new UnsupportedOperationException("Method not supported by this class");
    }

    @Override
    public boolean isSeekable() {
        return false;
    }
}

