/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.theora;

import de.jarnbjo.theora.TheoraFormatException;
import de.jarnbjo.util.io.BitInputStream;
import java.io.IOException;

public class Header {
    private final int[] version = new int[3];
    private final int width;
    private final int height;
    private final int fpsNumerator;
    private final int fpsDenominator;
    private final int aspectNumerator;
    private final int aspectDenominator;
    private final int keyframeFrequencyForce;
    private final int targetBitrate;
    private final int quality;
    private final String versionString;
    private static final int[] HEADER = new int[]{128, 116, 104, 101, 111, 114, 97};

    public Header(BitInputStream source) throws IOException {
        for (int i2 = 0; i2 < HEADER.length; ++i2) {
            if (source.getInt(8) == HEADER[i2]) continue;
            throw new TheoraFormatException("Theora header mismatch.");
        }
        this.version[0] = source.getInt(8);
        this.version[1] = source.getInt(8);
        this.version[2] = source.getInt(8);
        this.versionString = this.version[0] + "." + this.version[1] + "." + this.version[2];
        System.out.println("Version: " + this.versionString);
        if (this.version[0] != 3 && this.version[1] > 1) {
            throw new TheoraFormatException("Unsupported file format version: " + this.versionString);
        }
        this.width = source.getInt(16) << 4;
        this.height = source.getInt(16) << 4;
        System.out.println("width: " + this.width);
        System.out.println("height: " + this.height);
        this.fpsNumerator = source.getInt(32);
        this.fpsDenominator = source.getInt(32);
        System.out.println(this.fpsNumerator);
        System.out.println(this.fpsDenominator);
        this.aspectNumerator = source.getInt(24);
        this.aspectDenominator = source.getInt(24);
        System.out.println(this.aspectNumerator);
        System.out.println(this.aspectDenominator);
        this.keyframeFrequencyForce = 1 << source.getInt(5);
        this.targetBitrate = source.getSignedInt(24);
        this.quality = source.getSignedInt(6);
        System.out.println(this.keyframeFrequencyForce);
        System.out.println(this.targetBitrate);
        System.out.println(this.quality);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getFrameRate() {
        return (double)this.fpsNumerator / (double)this.fpsDenominator;
    }

    public int getKeyframeFrequencyForce() {
        return this.keyframeFrequencyForce;
    }
}

