/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.util.audio;

import java.io.IOException;
import javax.sound.sampled.AudioInputStream;

public class FadeableAudioInputStream
extends AudioInputStream {
    private boolean fading = false;
    private double phi = 0.0;

    public FadeableAudioInputStream(AudioInputStream stream) throws IOException {
        super(stream, stream.getFormat(), -1L);
    }

    public void fadeOut() {
        this.fading = true;
        this.phi = 0.0;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int offset, int length) throws IOException {
        int read = super.read(b2, offset, length);
        if (this.fading) {
            int j2 = 0;
            int l2 = 0;
            int r = 0;
            double gain = 0.0;
            for (int i2 = offset; i2 < offset + read; i2 += 4) {
                j2 = i2;
                l2 = b2[j2++] & 0xFF;
                l2 |= b2[j2++] << 8;
                r = b2[j2++] & 0xFF;
                r |= b2[j2] << 8;
                if (this.phi < 1.5707963267948966) {
                    this.phi += 1.5E-5;
                }
                gain = Math.cos(this.phi);
                l2 = (int)((double)l2 * gain);
                r = (int)((double)r * gain);
                j2 = i2;
                b2[j2++] = (byte)(l2 & 0xFF);
                b2[j2++] = (byte)(l2 >> 8 & 0xFF);
                b2[j2++] = (byte)(r & 0xFF);
                b2[j2++] = (byte)(r >> 8 & 0xFF);
            }
        }
        return read;
    }
}

