/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.util.io.BitInputStream;
import de.jarnbjo.vorbis.Floor;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.Mapping;
import de.jarnbjo.vorbis.MdctFloat;
import de.jarnbjo.vorbis.Mode;
import de.jarnbjo.vorbis.Residue;
import de.jarnbjo.vorbis.SetupHeader;
import de.jarnbjo.vorbis.Util;
import de.jarnbjo.vorbis.VorbisFormatException;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.IOException;

class AudioPacket {
    private final int modeNumber;
    private final Mode mode;
    private final Mapping mapping;
    private final int n;
    private final boolean blockFlag;
    private boolean previousWindowFlag;
    private boolean nextWindowFlag;
    private final int windowCenter;
    private final int leftWindowStart;
    private final int leftWindowEnd;
    private final int leftN;
    private final int rightWindowStart;
    private final int rightWindowEnd;
    private final int rightN;
    private final float[] window;
    private final float[][] pcm;
    private final int[][] pcmInt;
    private final Floor[] channelFloors;
    private final boolean[] noResidues;
    private final float[][] windows = new float[8][];

    protected AudioPacket(VorbisStream vorbis, BitInputStream source) throws IOException {
        int i2;
        int i3;
        SetupHeader sHeader = vorbis.getSetupHeader();
        IdentificationHeader iHeader = vorbis.getIdentificationHeader();
        Mode[] modes = sHeader.getModes();
        Mapping[] mappings = sHeader.getMappings();
        Residue[] residues = sHeader.getResidues();
        int channels = iHeader.getChannels();
        if (source.getInt(1) != 0) {
            throw new VorbisFormatException("Packet type mismatch when trying to create an audio packet.");
        }
        this.modeNumber = source.getInt(Util.ilog(modes.length - 1));
        try {
            this.mode = modes[this.modeNumber];
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new VorbisFormatException("Reference to invalid mode in audio packet.");
        }
        this.mapping = mappings[this.mode.getMapping()];
        int[] magnitudes = this.mapping.getMagnitudes();
        int[] angles = this.mapping.getAngles();
        this.blockFlag = this.mode.getBlockFlag();
        int blockSize0 = iHeader.getBlockSize0();
        int blockSize1 = iHeader.getBlockSize1();
        int n2 = this.n = this.blockFlag ? blockSize1 : blockSize0;
        if (this.blockFlag) {
            this.previousWindowFlag = source.getBit();
            this.nextWindowFlag = source.getBit();
        }
        this.windowCenter = this.n / 2;
        if (this.blockFlag && !this.previousWindowFlag) {
            this.leftWindowStart = this.n / 4 - blockSize0 / 4;
            this.leftWindowEnd = this.n / 4 + blockSize0 / 4;
            this.leftN = blockSize0 / 2;
        } else {
            this.leftWindowStart = 0;
            this.leftWindowEnd = this.n / 2;
            this.leftN = this.windowCenter;
        }
        if (this.blockFlag && !this.nextWindowFlag) {
            this.rightWindowStart = this.n * 3 / 4 - blockSize0 / 4;
            this.rightWindowEnd = this.n * 3 / 4 + blockSize0 / 4;
            this.rightN = blockSize0 / 2;
        } else {
            this.rightWindowStart = this.windowCenter;
            this.rightWindowEnd = this.n;
            this.rightN = this.n / 2;
        }
        this.window = this.getComputedWindow();
        this.channelFloors = new Floor[channels];
        this.noResidues = new boolean[channels];
        this.pcm = new float[channels][this.n];
        this.pcmInt = new int[channels][this.n];
        boolean allFloorsEmpty = true;
        for (i3 = 0; i3 < channels; ++i3) {
            Floor decodedFloor;
            int submapNumber = this.mapping.getMux()[i3];
            int floorNumber = this.mapping.getSubmapFloors()[submapNumber];
            this.channelFloors[i3] = decodedFloor = sHeader.getFloors()[floorNumber].decodeFloor(vorbis, source);
            boolean bl = this.noResidues[i3] = decodedFloor == null;
            if (decodedFloor == null) continue;
            allFloorsEmpty = false;
        }
        if (allFloorsEmpty) {
            return;
        }
        for (i3 = 0; i3 < magnitudes.length; ++i3) {
            if (this.noResidues[magnitudes[i3]] && this.noResidues[angles[i3]]) continue;
            this.noResidues[magnitudes[i3]] = false;
            this.noResidues[angles[i3]] = false;
        }
        Residue[] decodedResidues = new Residue[this.mapping.getSubmaps()];
        for (i2 = 0; i2 < this.mapping.getSubmaps(); ++i2) {
            int ch = 0;
            boolean[] doNotDecodeFlags = new boolean[channels];
            for (int j2 = 0; j2 < channels; ++j2) {
                if (this.mapping.getMux()[j2] != i2) continue;
                doNotDecodeFlags[ch++] = this.noResidues[j2];
            }
            int residueNumber = this.mapping.getSubmapResidues()[i2];
            Residue residue = residues[residueNumber];
            residue.decodeResidue(vorbis, source, this.mode, ch, doNotDecodeFlags, this.pcm);
        }
        for (i2 = this.mapping.getCouplingSteps() - 1; i2 >= 0; --i2) {
            double newA = 0.0;
            double newM = 0.0;
            float[] magnitudeVector = this.pcm[magnitudes[i2]];
            float[] angleVector = this.pcm[angles[i2]];
            for (int j3 = 0; j3 < magnitudeVector.length; ++j3) {
                float a2 = angleVector[j3];
                float m2 = magnitudeVector[j3];
                if (a2 > 0.0f) {
                    angleVector[j3] = m2 > 0.0f ? m2 - a2 : m2 + a2;
                    continue;
                }
                magnitudeVector[j3] = m2 > 0.0f ? m2 + a2 : m2 - a2;
                angleVector[j3] = m2;
            }
        }
        for (i2 = 0; i2 < channels; ++i2) {
            if (this.channelFloors[i2] == null) continue;
            this.channelFloors[i2].computeFloor(this.pcm[i2]);
        }
        for (i2 = 0; i2 < channels; ++i2) {
            MdctFloat mdct = this.blockFlag ? iHeader.getMdct1() : iHeader.getMdct0();
            mdct.imdct(this.pcm[i2], this.window, this.pcmInt[i2]);
        }
    }

    private float[] getComputedWindow() {
        int ix = (this.blockFlag ? 4 : 0) + (this.previousWindowFlag ? 2 : 0) + (this.nextWindowFlag ? 1 : 0);
        float[] w = this.windows[ix];
        if (w == null) {
            float x;
            int i2;
            w = new float[this.n];
            for (i2 = 0; i2 < this.leftN; ++i2) {
                x = (float)(((double)i2 + 0.5) / (double)this.leftN * Math.PI / 2.0);
                x = (float)Math.sin(x);
                x *= x;
                x = (float)((double)x * 1.5707963705062866);
                w[i2 + this.leftWindowStart] = x = (float)Math.sin(x);
            }
            i2 = this.leftWindowEnd;
            while (i2 < this.rightWindowStart) {
                w[i2++] = 1.0f;
            }
            for (i2 = 0; i2 < this.rightN; ++i2) {
                x = (float)(((double)(this.rightN - i2) - 0.5) / (double)this.rightN * Math.PI / 2.0);
                x = (float)Math.sin(x);
                x *= x;
                x = (float)((double)x * 1.5707963705062866);
                w[i2 + this.rightWindowStart] = x = (float)Math.sin(x);
            }
            this.windows[ix] = w;
        }
        return w;
    }

    protected int getNumberOfSamples() {
        return this.rightWindowStart - this.leftWindowStart;
    }

    protected int getPcm(AudioPacket previousPacket, int[][] buffer) {
        int i2;
        int channels = this.pcm.length;
        for (i2 = 0; i2 < channels; ++i2) {
            int j1 = 0;
            int j2 = previousPacket.rightWindowStart;
            int[] ppcm = previousPacket.pcmInt[i2];
            int[] tpcm = this.pcmInt[i2];
            int[] target = buffer[i2];
            for (int j3 = this.leftWindowStart; j3 < this.leftWindowEnd; ++j3) {
                int val;
                if ((val = ppcm[j2++] + tpcm[j3]) > Short.MAX_VALUE) {
                    val = Short.MAX_VALUE;
                }
                if (val < Short.MIN_VALUE) {
                    val = Short.MIN_VALUE;
                }
                target[j1++] = val;
            }
        }
        if (this.leftWindowEnd + 1 < this.rightWindowStart) {
            for (i2 = 0; i2 < channels; ++i2) {
                System.arraycopy(this.pcmInt[i2], this.leftWindowEnd, buffer[i2], this.leftWindowEnd - this.leftWindowStart, this.rightWindowStart - this.leftWindowEnd);
            }
        }
        return this.rightWindowStart - this.leftWindowStart;
    }

    protected void getPcm(AudioPacket previousPacket, byte[] buffer) {
        int channels = this.pcm.length;
        for (int i2 = 0; i2 < channels; ++i2) {
            int val;
            int j2;
            int ix = 0;
            int j22 = previousPacket.rightWindowStart;
            int[] ppcm = previousPacket.pcmInt[i2];
            int[] tpcm = this.pcmInt[i2];
            for (j2 = this.leftWindowStart; j2 < this.leftWindowEnd; ++j2) {
                if ((val = ppcm[j22++] + tpcm[j2]) > Short.MAX_VALUE) {
                    val = Short.MAX_VALUE;
                }
                if (val < Short.MIN_VALUE) {
                    val = Short.MIN_VALUE;
                }
                buffer[ix + i2 * 2 + 1] = (byte)(val & 0xFF);
                buffer[ix + i2 * 2] = (byte)(val >> 8 & 0xFF);
                ix += channels * 2;
            }
            ix = (this.leftWindowEnd - this.leftWindowStart) * channels * 2;
            for (j2 = this.leftWindowEnd; j2 < this.rightWindowStart; ++j2) {
                val = tpcm[j2];
                if (val > Short.MAX_VALUE) {
                    val = Short.MAX_VALUE;
                }
                if (val < Short.MIN_VALUE) {
                    val = Short.MIN_VALUE;
                }
                buffer[ix + i2 * 2 + 1] = (byte)(val & 0xFF);
                buffer[ix + i2 * 2] = (byte)(val >> 8 & 0xFF);
                ix += channels * 2;
            }
        }
    }

    protected float[] getWindow() {
        return this.window;
    }

    protected int getLeftWindowStart() {
        return this.leftWindowStart;
    }

    protected int getLeftWindowEnd() {
        return this.leftWindowEnd;
    }

    protected int getRightWindowStart() {
        return this.rightWindowStart;
    }

    protected int getRightWindowEnd() {
        return this.rightWindowEnd;
    }

    public int[][] getPcm() {
        return this.pcmInt;
    }

    public float[][] getFreqencyDomain() {
        return this.pcm;
    }
}

