/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.vorbis.Floor;

public final class Util {
    private Util() {
    }

    public static int ilog(int x) {
        int res = 0;
        while (x > 0) {
            x >>= 1;
            ++res;
        }
        return res;
    }

    public static float float32unpack(int x) {
        float mantissa = x & 0x1FFFFF;
        float e2 = (x & 0x7FE00000) >> 21;
        if ((x & Integer.MIN_VALUE) != 0) {
            mantissa = -mantissa;
        }
        return mantissa * (float)Math.pow(2.0, (double)e2 - 788.0);
    }

    public static int lookup1Values(int a2, int b2) {
        int res = (int)Math.pow(Math.E, Math.log(a2) / (double)b2);
        return Util.intPow(res + 1, b2) <= a2 ? res + 1 : res;
    }

    public static int intPow(int base, int e2) {
        int res = 1;
        while (e2 > 0) {
            res *= base;
            --e2;
        }
        return res;
    }

    public static boolean isBitSet(int value, int bit) {
        return (value & 1 << bit) != 0;
    }

    public static int icount(int value) {
        int res = 0;
        while (value > 0) {
            res += value & 1;
            value >>= 1;
        }
        return res;
    }

    public static int lowNeighbour(int[] v, int x) {
        int max2 = -1;
        int n2 = 0;
        for (int i2 = 0; i2 < v.length && i2 < x; ++i2) {
            if (v[i2] <= max2 || v[i2] >= v[x]) continue;
            max2 = v[i2];
            n2 = i2;
        }
        return n2;
    }

    public static int highNeighbour(int[] v, int x) {
        int min2 = Integer.MAX_VALUE;
        int n2 = 0;
        for (int i2 = 0; i2 < v.length && i2 < x; ++i2) {
            if (v[i2] >= min2 || v[i2] <= v[x]) continue;
            min2 = v[i2];
            n2 = i2;
        }
        return n2;
    }

    public static int renderPoint(int x0, int x1, int y0, int y1, int x) {
        int dy = y1 - y0;
        int ady = dy < 0 ? -dy : dy;
        int off = ady * (x - x0) / (x1 - x0);
        return dy < 0 ? y0 - off : y0 + off;
    }

    public static void renderLine(int x0, int y0, int x1, int y1, float[] v) {
        int dy = y1 - y0;
        int adx = x1 - x0;
        int base = dy / adx;
        int sy = dy < 0 ? base - 1 : base + 1;
        int x = x0;
        int y = y0;
        int err = 0;
        int ady = (dy < 0 ? -dy : dy) - (base > 0 ? base * adx : -base * adx);
        int n2 = x;
        v[n2] = v[n2] * Floor.DB_STATIC_TABLE[y];
        for (x = x0 + 1; x < x1; ++x) {
            if ((err += ady) >= adx) {
                err -= adx;
                int n3 = x;
                v[n3] = v[n3] * Floor.DB_STATIC_TABLE[y += sy];
                continue;
            }
            int n4 = x;
            v[n4] = v[n4] * Floor.DB_STATIC_TABLE[y += base];
        }
    }
}

