/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.Serializable;

public class Format
implements Cloneable,
Serializable {
    public static final int NOT_SPECIFIED = -1;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    protected String encoding;
    public static final Class intArray = new int[0].getClass();
    public static final Class shortArray = new short[0].getClass();
    public static final Class byteArray = new byte[0].getClass();
    public static final Class formatArray = new Format[0].getClass();
    protected Class dataType = byteArray;
    protected Class clz = this.getClass();
    private long encodingCode = 0L;

    public Format(String encoding) {
        this.encoding = encoding;
    }

    public Format(String encoding, Class dataType) {
        this(encoding);
        this.dataType = dataType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Class getDataType() {
        return this.dataType;
    }

    public boolean equals(Object format2) {
        if (format2 == null || this.clz != ((Format)format2).clz) {
            return false;
        }
        String otherEncoding = ((Format)format2).encoding;
        Class otherType = ((Format)format2).dataType;
        return this.dataType == otherType && (this.encoding == otherEncoding || this.encoding != null && otherEncoding != null && this.isSameEncoding((Format)format2));
    }

    public boolean matches(Format format2) {
        if (format2 == null) {
            return false;
        }
        return !(format2.encoding != null && this.encoding != null && !this.isSameEncoding(format2) || format2.dataType != null && this.dataType != null && format2.dataType != this.dataType || !this.clz.isAssignableFrom(format2.clz) && !format2.clz.isAssignableFrom(this.clz));
    }

    public Format intersects(Format other) {
        Format res;
        if (this.clz.isAssignableFrom(other.clz)) {
            res = (Format)other.clone();
        } else if (other.clz.isAssignableFrom(this.clz)) {
            res = (Format)this.clone();
        } else {
            return null;
        }
        if (res.encoding == null) {
            String string = res.encoding = this.encoding != null ? this.encoding : other.encoding;
        }
        if (res.dataType == null) {
            res.dataType = this.dataType != null ? this.dataType : other.dataType;
        }
        return res;
    }

    public boolean isSameEncoding(Format other) {
        if (this.encoding == null || other == null || other.encoding == null) {
            return false;
        }
        if (this.encoding == other.encoding) {
            return true;
        }
        if (this.encodingCode > 0L && other.encodingCode > 0L) {
            return this.encodingCode == other.encodingCode;
        }
        if (this.encoding.length() > 10) {
            return this.encoding.equalsIgnoreCase(other.encoding);
        }
        if (this.encodingCode == 0L) {
            this.encodingCode = this.getEncodingCode(this.encoding);
        }
        if (this.encodingCode <= 0L) {
            return this.encoding.equalsIgnoreCase(other.encoding);
        }
        if (other.encodingCode == 0L) {
            return other.isSameEncoding(this);
        }
        return this.encodingCode == other.encodingCode;
    }

    public boolean isSameEncoding(String encoding) {
        if (this.encoding == null || encoding == null) {
            return false;
        }
        if (this.encoding == encoding) {
            return true;
        }
        if (this.encoding.length() > 10) {
            return this.encoding.equalsIgnoreCase(encoding);
        }
        if (this.encodingCode == 0L) {
            this.encodingCode = this.getEncodingCode(this.encoding);
        }
        if (this.encodingCode < 0L) {
            return this.encoding.equalsIgnoreCase(encoding);
        }
        long otherEncodingCode = this.getEncodingCode(encoding);
        return this.encodingCode == otherEncodingCode;
    }

    private long getEncodingCode(String enc) {
        byte[] chars = enc.getBytes();
        long code = 0L;
        int i2 = 0;
        while (i2 < enc.length()) {
            byte b2 = chars[i2];
            if (b2 > 96 && b2 < 123) {
                b2 = (byte)(b2 - 32);
            }
            if ((b2 = (byte)(b2 - 32)) > 63) {
                return -1L;
            }
            code = code << 6 | (long)b2;
            ++i2;
        }
        return code;
    }

    public Format relax() {
        return (Format)this.clone();
    }

    public Object clone() {
        Format f2 = new Format(this.encoding);
        f2.copy(this);
        return f2;
    }

    protected void copy(Format f2) {
        this.dataType = f2.dataType;
    }

    public String toString() {
        return this.getEncoding();
    }
}

