/*
 * Decompiled with CFR 0.152.
 */
package javax.media.cdm;

import com.sun.media.util.Registry;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;

public class CaptureDeviceManager
extends javax.media.CaptureDeviceManager {
    static Vector devices = null;

    public CaptureDeviceManager() {
        CaptureDeviceManager.readFromRegistry();
    }

    public static synchronized Vector getDeviceList() {
        return CaptureDeviceManager.getDeviceList(null);
    }

    public static synchronized CaptureDeviceInfo getDevice(String deviceName) {
        if (devices == null) {
            return null;
        }
        Enumeration enumeration = devices.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo cdi = (CaptureDeviceInfo)enumeration.nextElement();
            if (!cdi.getName().equals(deviceName)) continue;
            return cdi;
        }
        return null;
    }

    public static synchronized Vector getDeviceList(Format format2) {
        if (devices == null) {
            return null;
        }
        if (format2 == null) {
            return devices;
        }
        Vector<CaptureDeviceInfo> newList = new Vector<CaptureDeviceInfo>();
        Enumeration enumeration = devices.elements();
        block0: while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo cdi = (CaptureDeviceInfo)enumeration.nextElement();
            Format[] formats = cdi.getFormats();
            int i2 = 0;
            while (i2 < formats.length) {
                if (formats[i2].matches(format2)) {
                    newList.addElement(cdi);
                    continue block0;
                }
                ++i2;
            }
        }
        if (newList.size() > 0) {
            return newList;
        }
        return null;
    }

    public static synchronized boolean addDevice(CaptureDeviceInfo newDevice) {
        if (newDevice != null) {
            if (devices == null) {
                devices = new Vector();
            } else {
                Enumeration enumeration = devices.elements();
                while (enumeration.hasMoreElements()) {
                    CaptureDeviceInfo cdi = (CaptureDeviceInfo)enumeration.nextElement();
                    if (!cdi.equals(newDevice)) continue;
                    return false;
                }
            }
            devices.addElement(newDevice);
            return true;
        }
        return false;
    }

    public static synchronized boolean removeDevice(CaptureDeviceInfo device) {
        if (devices == null || device == null || device.getName() == null) {
            return false;
        }
        Enumeration enumeration = devices.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo cdi = (CaptureDeviceInfo)enumeration.nextElement();
            if (cdi != device) continue;
            devices.removeElement(cdi);
            return true;
        }
        return false;
    }

    public static synchronized void commit() throws IOException {
        Registry r = new Registry();
        Registry.removeGroup("CDM");
        if (devices == null) {
            Registry.set("CDM.nDevices", new Integer(0));
        } else {
            Registry.set("CDM.nDevices", new Integer(devices.size()));
            int i2 = 0;
            Enumeration enumeration = devices.elements();
            while (enumeration.hasMoreElements()) {
                CaptureDeviceInfo cdi = (CaptureDeviceInfo)enumeration.nextElement();
                Registry.set("CDM." + i2, cdi);
                ++i2;
            }
        }
        try {
            Registry.commit();
        }
        catch (Exception e2) {
            System.err.println("Exception on commit = " + e2);
        }
    }

    private static synchronized void readFromRegistry() {
        if (devices != null) {
            return;
        }
        devices = new Vector();
        Registry r = new Registry();
        Object size = Registry.get("CDM.nDevices");
        if (size == null || (Integer)size == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < (Integer)size) {
            Object cdi = Registry.get("CDM." + i2);
            if (cdi != null && cdi instanceof CaptureDeviceInfo) {
                devices.addElement(cdi);
            }
            ++i2;
        }
    }

    static {
        CaptureDeviceManager.readFromRegistry();
    }
}

