/*
 * Decompiled with CFR 0.152.
 */
package jmapps.registry;

import com.sun.media.util.DynamicPlugIn;
import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugInManager;
import javax.media.Renderer;
import jmapps.registry.VectorEditor;
import jmapps.registry.VectorPanel;
import jmapps.ui.JMPanel;

public class PerTypePanel
extends JMPanel
implements VectorEditor {
    VectorPanel panelPlugIns;
    Vector pluginVector;
    Vector pluginArray;
    TextArea textArea;
    int type;
    private static boolean jdkInit = false;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    static final String[] pluginTypes;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Thread;

    public PerTypePanel(int type2) {
        this.type = type2;
        this.setLayout(new GridLayout(1, 2, 6, 6));
        this.panelPlugIns = new VectorPanel(pluginTypes[type2], this, type2);
        this.add(this.panelPlugIns);
        Panel panel = new Panel(new BorderLayout());
        this.add(panel);
        Label label = new Label(JMFI18N.getResource("jmfregistry.plugin.details.label"));
        panel.add((Component)label, "North");
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        panel.add((Component)this.textArea, "Center");
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class == null ? (class$java$lang$Class = PerTypePanel.class$("java.lang.Class")) : class$java$lang$Class).getMethod("forName", class$java$lang$String == null ? (class$java$lang$String = PerTypePanel.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PerTypePanel.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
            getSystemClassLoaderM = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PerTypePanel.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = PerTypePanel.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader), null);
            getContextClassLoaderM = (class$java$lang$Thread == null ? (class$java$lang$Thread = PerTypePanel.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
        }
        catch (Throwable t) {
            forName3ArgsM = null;
            return false;
        }
        return true;
    }

    static Class getClassForName(String className) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(className);
            }
            catch (Exception e2) {
                if (!PerTypePanel.checkIfJDK12()) {
                    throw new ClassNotFoundException(e2.getMessage());
                }
            }
            catch (Error e3) {
                if (PerTypePanel.checkIfJDK12()) break block9;
                throw e3;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = PerTypePanel.class$("java.lang.Class")) : class$java$lang$Class), className, new Boolean(true), systemClassLoader);
        }
        catch (Throwable e4) {
            try {
                ClassLoader contextClassLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class == null ? (class$java$lang$Class = PerTypePanel.class$("java.lang.Class")) : class$java$lang$Class), className, new Boolean(true), contextClassLoader);
            }
            catch (Exception e5) {
                throw new ClassNotFoundException(e5.getMessage());
            }
            catch (Error e6) {
                throw e6;
            }
        }
    }

    public Vector stringArrayToVector(String[] array) {
        Vector<String> v = new Vector<String>();
        if (array != null) {
            int i2 = 0;
            while (i2 < array.length) {
                v.addElement(array[i2]);
                ++i2;
            }
        }
        return v;
    }

    public String[] vectorToStringArray(Vector v) {
        String[] sa = new String[v.size()];
        Enumeration e2 = v.elements();
        int i2 = 0;
        while (e2.hasMoreElements()) {
            sa[i2++] = (String)e2.nextElement();
        }
        return sa;
    }

    public Vector getList(int code) {
        this.pluginVector = PlugInManager.getPlugInList(null, null, this.type);
        if (this.pluginVector == null) {
            this.pluginVector = new Vector(1);
        }
        return this.pluginVector;
    }

    public void setList(int code, Vector v) {
        this.pluginVector = v;
    }

    public void commit(int code) {
        PlugInManager.setPlugInList(this.pluginVector, this.type);
        try {
            PlugInManager.commit();
        }
        catch (IOException ioe) {
            System.err.println("PlugInManager.commit() - " + ioe);
        }
    }

    public boolean addToList(int code, String value) {
        try {
            int type2;
            String className = value;
            Class pic = PerTypePanel.getClassForName(className);
            Object instance = pic.newInstance();
            Format[] inputs = null;
            Format[] outputs = null;
            if (instance instanceof Demultiplexer) {
                type2 = 1;
                inputs = ((Demultiplexer)instance).getSupportedInputContentDescriptors();
                outputs = new Format[]{};
            } else if (instance instanceof Renderer) {
                type2 = 4;
                inputs = ((Renderer)instance).getSupportedInputFormats();
                outputs = new Format[]{};
            } else if (instance instanceof Multiplexer) {
                type2 = 5;
                inputs = new Format[]{};
                outputs = ((Multiplexer)instance).getSupportedOutputContentDescriptors(null);
            } else if (instance instanceof Effect) {
                type2 = 3;
                inputs = ((Effect)instance).getSupportedInputFormats();
                outputs = ((Effect)instance).getSupportedOutputFormats(null);
            } else if (instance instanceof Codec) {
                type2 = 2;
                inputs = ((Codec)instance).getSupportedInputFormats();
                outputs = ((Codec)instance).getSupportedOutputFormats(null);
            } else {
                type2 = 0;
            }
            if (instance instanceof DynamicPlugIn) {
                inputs = ((DynamicPlugIn)instance).getBaseInputFormats();
                outputs = ((DynamicPlugIn)instance).getBaseOutputFormats();
            }
            if (type2 != 0 && PlugInManager.addPlugIn(className, inputs, outputs, type2)) {
                return true;
            }
        }
        catch (Exception e2) {
            System.err.println(e2);
        }
        return false;
    }

    public void selectedIndex(int code, int index) {
        String name = null;
        String text = "";
        Format[] input = null;
        Format[] output = null;
        if (index >= 0) {
            name = (String)this.pluginVector.elementAt(index);
        }
        if (name != null) {
            input = PlugInManager.getSupportedInputFormats(name, this.type);
        }
        if (input != null) {
            text = text + JMFI18N.getResource("jmfregistry.details.informats") + "---->\n\n" + this.printFormats(input) + "\n\n";
        }
        if (name != null) {
            output = PlugInManager.getSupportedOutputFormats(name, this.type);
        }
        if (output != null) {
            text = text + JMFI18N.getResource("jmfregistry.details.outformats") + "--->\n\n" + this.printFormats(output) + "\n\n";
        }
        this.textArea.setText(text);
    }

    private String printFormats(Object fa) {
        if (!(fa instanceof Format[])) {
            return "null";
        }
        Format[] formats = (Format[])fa;
        String text = "";
        int i2 = 0;
        while (i2 < formats.length) {
            text = text + i2 + ". " + formats[i2].getClass().getName() + "\n  " + formats[i2] + "\n";
            ++i2;
        }
        return text;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        pluginTypes = new String[]{JMFI18N.getResource("jmfregistry.plugin"), JMFI18N.getResource("jmfregistry.plugin.demultiplexer"), JMFI18N.getResource("jmfregistry.plugin.codec"), JMFI18N.getResource("jmfregistry.plugin.effect"), JMFI18N.getResource("jmfregistry.plugin.renderer"), JMFI18N.getResource("jmfregistry.plugin.multiplexer")};
    }
}

