/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.rtp.util.Signed;
import com.sun.media.util.JMFI18N;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.RemoteListener;
import javax.media.rtp.SessionListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.NewParticipantEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.ReceiverReportEvent;
import javax.media.rtp.event.RemoteEvent;
import javax.media.rtp.event.SenderReportEvent;
import javax.media.rtp.event.SessionEvent;
import javax.media.rtp.event.TimeoutEvent;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.ReceiverReport;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import jmapps.rtp.ViewParticipantInfo;
import jmapps.rtp.ViewParticipantList;
import jmapps.rtp.ViewReceiverReport;
import jmapps.rtp.ViewReportBlock;
import jmapps.rtp.ViewRtpStreamInfo;
import jmapps.rtp.ViewSenderReport;
import jmapps.ui.JMPanel;
import jmapps.ui.TreeControl;
import jmapps.ui.TreeNode;

public class PanelParticipants
extends JMPanel
implements ComponentListener,
ActionListener,
SessionListener,
ReceiveStreamListener,
RemoteListener {
    private SessionManager mngrSession;
    private TreeControl controlTree = null;
    private JMPanel panelView = null;
    private CardLayout layoutView = null;
    private JMPanel panelCurrentView = null;
    private static final int MARGINH = 6;
    public static final String PARTICIPANTS = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants");
    public static final String REMOTE_RECEIVE_STREAM = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.remotereceivestream");
    public static final String UNKNOWN_STREAM = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.unknownstream");
    public static final String REPORT = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.report");
    public static final String LATEST_SENDER_REPORT = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.latestsenderreport");
    public static final String REPORT_BLOCK = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.reportblock");
    public static final String REPORT_BLOCK_BY_ME = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.reportblockbyme");
    public static final String SENDER_REPORT_BLOCK = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.senderreportblock");

    public PanelParticipants(SessionManager mngrSession) {
        this.mngrSession = mngrSession;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.addComponentListener(this);
        this.setLayout(null);
        this.controlTree = new TreeControl();
        this.add(this.controlTree);
        this.layoutView = new CardLayout();
        this.panelView = new JMPanel(this.layoutView);
        this.panelView.setEtchedBorder();
        this.add(this.panelView);
        TreeNode nodeRoot = this.controlTree.createRootElement(PARTICIPANTS);
        ViewParticipantList panel = new ViewParticipantList(this.mngrSession);
        nodeRoot.setUserData(panel);
        this.fillParticipantsNode(nodeRoot);
        this.controlTree.setCurrentElement(nodeRoot);
        nodeRoot.addActionListener(this);
        this.setViewPanel(nodeRoot);
        this.mngrSession.addSessionListener(this);
        this.mngrSession.addReceiveStreamListener(this);
        this.mngrSession.addRemoteListener(this);
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(480, 360);
        return dim;
    }

    public void actionPerformed(ActionEvent event) {
        Object objSource = event.getSource();
        if (objSource == null || !(objSource instanceof TreeNode)) {
            return;
        }
        String strAction = event.getActionCommand();
        if (!strAction.equals("Node Added")) {
            if (strAction.equals("Node Removed")) {
                this.removeViewPanel((TreeNode)objSource);
            } else if (!strAction.equals("Node Expanded") && !strAction.equals("Node Collapsed")) {
                if (strAction.equals("Node Set Current")) {
                    this.setViewPanel((TreeNode)objSource);
                } else if (strAction.equals("Node Reset Current")) {
                    // empty if block
                }
            }
        }
    }

    public void update(SessionEvent event) {
        if (event instanceof NewParticipantEvent) {
            Participant participant = ((NewParticipantEvent)event).getParticipant();
            this.addParticipant(participant);
        }
    }

    public void update(RemoteEvent event) {
        Object objPanel;
        TreeNode node;
        Participant participant;
        if (event instanceof ReceiverReportEvent && (participant = ((ReceiverReportEvent)event).getReport().getParticipant()) != null && participant.getStreams().size() == 0 && (node = this.findParticipantListNode()) != null) {
            objPanel = node.getUserData();
            if (objPanel != null && objPanel instanceof ViewParticipantList) {
                ((ViewParticipantList)objPanel).updateFields();
            }
            ReceiverReport reportReceiver = ((ReceiverReportEvent)event).getReport();
            this.addReport(participant, (Report)reportReceiver);
        }
        if (event instanceof SenderReportEvent && (participant = ((SenderReportEvent)event).getReport().getParticipant()) != null && participant.getStreams().size() > 0 && (node = this.findParticipantListNode()) != null) {
            objPanel = node.getUserData();
            if (objPanel != null && objPanel instanceof ViewParticipantList) {
                ((ViewParticipantList)objPanel).updateFields();
            }
            SenderReport reportSender = ((SenderReportEvent)event).getReport();
            this.addReport(participant, (Report)reportSender);
        }
    }

    public void update(ReceiveStreamEvent event) {
        ReceiveStream stream;
        Participant participant;
        if (event instanceof TimeoutEvent || event instanceof ByeEvent) {
            participant = null;
            stream = null;
            if (event instanceof TimeoutEvent && ((TimeoutEvent)event).participantLeaving()) {
                participant = ((TimeoutEvent)event).getParticipant();
            }
            if (event instanceof ByeEvent && ((ByeEvent)event).participantLeaving()) {
                participant = ((ByeEvent)event).getParticipant();
            } else if (event instanceof TimeoutEvent) {
                stream = ((TimeoutEvent)event).getReceiveStream();
            } else if (event instanceof ByeEvent) {
                stream = ((ByeEvent)event).getReceiveStream();
            }
            if (participant != null) {
                this.removeParticipant(participant);
            }
            if (stream != null) {
                this.removeRtpStream(stream);
            }
        }
        if (event instanceof NewReceiveStreamEvent) {
            stream = ((NewReceiveStreamEvent)event).getReceiveStream();
            participant = stream.getParticipant();
            if (participant == null) {
                return;
            }
            TreeNode node = this.findParticipantNode(participant);
            if (node == null) {
                this.addParticipant(participant);
            }
            this.addRtpStream(participant, (RTPStream)stream);
            node = this.findParticipantListNode();
            Object objPanel = node.getUserData();
            if (objPanel != null && objPanel instanceof ViewParticipantList) {
                ((ViewParticipantList)objPanel).updateFields();
            }
        }
        if (event instanceof InactiveReceiveStreamEvent) {
            // empty if block
        }
        if (event instanceof ActiveReceiveStreamEvent) {
            // empty if block
        }
    }

    public void componentResized(ComponentEvent event) {
        this.layoutComponents();
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
    }

    public void componentHidden(ComponentEvent event) {
    }

    private void fillParticipantsNode(TreeNode nodeParent) {
        LocalParticipant objParticipant;
        Vector vectorParticipants = this.mngrSession.getRemoteParticipants();
        if (!vectorParticipants.contains(objParticipant = this.mngrSession.getLocalParticipant())) {
            vectorParticipants.addElement(objParticipant);
        }
        Vector vector2 = this.mngrSession.getActiveParticipants();
        int nCount = vector2.size();
        int i2 = 0;
        while (i2 < nCount) {
            objParticipant = vector2.elementAt(i2);
            if (!vectorParticipants.contains(objParticipant)) {
                vectorParticipants.addElement(objParticipant);
            }
            ++i2;
        }
        vector2 = this.mngrSession.getPassiveParticipants();
        nCount = vector2.size();
        i2 = 0;
        while (i2 < nCount) {
            objParticipant = vector2.elementAt(i2);
            if (!vectorParticipants.contains(objParticipant)) {
                vectorParticipants.addElement(objParticipant);
            }
            ++i2;
        }
        nCount = vectorParticipants.size();
        i2 = 0;
        while (i2 < nCount) {
            objParticipant = vectorParticipants.elementAt(i2);
            if (objParticipant != null && objParticipant instanceof Participant) {
                String strName = ((Participant)objParticipant).getCNAME();
                TreeNode node = this.controlTree.createSubElement(nodeParent, strName);
                ViewParticipantInfo panel = new ViewParticipantInfo(this.mngrSession, objParticipant);
                node.setUserData(panel);
                this.fillParticipantInfoNode(node, objParticipant);
                node.addActionListener(this);
            }
            ++i2;
        }
    }

    private void fillParticipantInfoNode(TreeNode nodeParent, Participant participant) {
        if (participant == null) {
            return;
        }
        Vector vectorStreams = participant.getStreams();
        int nCount = vectorStreams.size();
        int i2 = 0;
        while (i2 < nCount) {
            Object objStream = vectorStreams.elementAt(i2);
            if (objStream != null && objStream instanceof RTPStream) {
                this.addRtpStream(nodeParent, (RTPStream)objStream);
            }
            ++i2;
        }
        Vector vectorReports = participant.getReports();
        nCount = vectorReports.size();
        i2 = 0;
        while (i2 < nCount) {
            Object objReport = vectorReports.elementAt(i2);
            if (objReport != null && objReport instanceof Report) {
                this.addReport(nodeParent, (Report)objReport);
            }
            ++i2;
        }
    }

    private void fillStreamInfoNode(TreeNode nodeParent, RTPStream streamRtp) {
        if (streamRtp == null) {
            return;
        }
        SenderReport reportSender = streamRtp.getSenderReport();
        if (reportSender != null) {
            String strName = this.createStreamLatestReportNodeName();
            TreeNode node = this.controlTree.createSubElement(nodeParent, strName);
            ViewSenderReport panel = new ViewSenderReport(this.mngrSession, reportSender);
            node.setUserData(panel);
            this.fillReportInfoNode(node, reportSender);
            node.addActionListener(this);
        }
    }

    private void fillReportInfoNode(TreeNode nodeParent, Report objReport) {
        this.updateReportBlocks(nodeParent, objReport);
    }

    private void addParticipant(Participant participant) {
        if (participant == null) {
            return;
        }
        TreeNode nodeParent = this.findParticipantListNode();
        TreeNode node = this.findParticipantNode(participant);
        if (node != null) {
            return;
        }
        String strName = participant.getCNAME();
        node = this.controlTree.createSubElement(nodeParent, strName);
        ViewParticipantInfo panel = new ViewParticipantInfo(this.mngrSession, participant);
        node.setUserData(panel);
        this.fillParticipantInfoNode(node, participant);
        node.addActionListener(this);
        Object objPanel = nodeParent.getUserData();
        if (objPanel != null && objPanel instanceof ViewParticipantList) {
            ((ViewParticipantList)objPanel).updateFields();
        }
    }

    private void removeParticipant(Participant participant) {
        TreeNode node = this.findParticipantNode(participant);
        if (node == null) {
            return;
        }
        TreeNode nodeParent = this.findParticipantListNode();
        this.controlTree.destroySubElement(nodeParent, node);
        Object objPanel = nodeParent.getUserData();
        if (objPanel != null && objPanel instanceof ViewParticipantList) {
            ((ViewParticipantList)objPanel).updateFields();
        }
    }

    private void addRtpStream(Participant participant, RTPStream stream) {
        TreeNode nodeParticipant = this.findParticipantNode(participant);
        this.addRtpStream(nodeParticipant, stream);
    }

    private void addRtpStream(TreeNode nodeParticipant, RTPStream stream) {
        if (nodeParticipant == null) {
            return;
        }
        TreeNode nodeStream = this.findStreamNode(nodeParticipant, stream);
        if (nodeStream != null) {
            return;
        }
        String strName = this.createStreamNodeName(stream);
        nodeStream = this.controlTree.createSubElement(nodeParticipant, strName);
        ViewRtpStreamInfo panel = new ViewRtpStreamInfo(this.mngrSession, stream);
        nodeStream.setUserData(panel);
        this.fillStreamInfoNode(nodeStream, stream);
        nodeStream.addActionListener(this);
    }

    private void removeRtpStream(RTPStream stream) {
        Participant participant = stream.getParticipant();
        if (participant == null) {
            return;
        }
        TreeNode nodeParticipant = this.findParticipantNode(participant);
        this.removeRtpStream(nodeParticipant, stream);
    }

    private void removeRtpStream(TreeNode nodeParticipant, RTPStream stream) {
        if (nodeParticipant == null) {
            return;
        }
        TreeNode nodeStream = this.findStreamNode(nodeParticipant, stream);
        if (nodeStream == null) {
            return;
        }
        this.controlTree.destroySubElement(nodeParticipant, nodeStream);
    }

    private void addReport(Participant participant, Report report) {
        if (participant == null) {
            return;
        }
        TreeNode nodeParticipant = this.findParticipantNode(participant);
        this.addReport(nodeParticipant, report);
    }

    private void addReport(TreeNode nodeParticipant, Report report) {
        Object objPanel;
        if (nodeParticipant == null) {
            return;
        }
        String strName = this.createReportNodeName(report);
        TreeNode node = nodeParticipant.getSubElement(strName);
        if (node != null) {
            objPanel = node.getUserData();
            if (objPanel != null) {
                if (objPanel instanceof ViewReceiverReport && report instanceof ReceiverReport) {
                    ((ViewReceiverReport)objPanel).updateFields((ReceiverReport)report);
                } else if (objPanel instanceof ViewSenderReport && report instanceof SenderReport) {
                    ((ViewSenderReport)objPanel).updateFields((SenderReport)report);
                }
            }
            this.updateReportBlocks(node, report);
        } else {
            node = this.controlTree.createSubElement(nodeParticipant, strName);
            objPanel = report instanceof SenderReport ? new ViewSenderReport(this.mngrSession, (SenderReport)report) : (report instanceof ReceiverReport ? new ViewReceiverReport((ReceiverReport)report) : null);
            node.setUserData(objPanel);
            this.fillReportInfoNode(node, report);
            node.addActionListener(this);
            objPanel = nodeParticipant.getUserData();
            if (objPanel != null && objPanel instanceof ViewParticipantInfo) {
                ((ViewParticipantInfo)objPanel).updateFields(report);
            }
        }
        if (report instanceof SenderReport) {
            node = this.findStreamNode(nodeParticipant, ((SenderReport)report).getStream());
            if (node != null) {
                node = this.findStreamLatestReportNode(node);
            }
            if (node != null) {
                objPanel = node.getUserData();
                if (objPanel != null && objPanel instanceof ViewSenderReport) {
                    ((ViewSenderReport)objPanel).updateFields((SenderReport)report);
                }
                this.updateReportBlocks(node, report);
            }
        }
    }

    private void updateReportBlocks(TreeNode nodeReport, Report report) {
        block13: {
            block12: {
                Object objPanel;
                ViewReportBlock panel;
                if (report == null) {
                    return;
                }
                if (!(report instanceof SenderReport)) break block12;
                SenderReport reportSender = (SenderReport)report;
                Feedback feedback = reportSender.getSenderFeedback();
                String strName = REPORT_BLOCK_BY_ME;
                TreeNode node = nodeReport.getSubElement(strName);
                if (node == null) {
                    node = this.controlTree.createSubElement(nodeReport, strName);
                    panel = new ViewReportBlock(feedback);
                    node.setUserData(panel);
                    node.addActionListener(this);
                } else {
                    objPanel = node.getUserData();
                    if (objPanel != null && objPanel instanceof ViewReportBlock) {
                        ((ViewReportBlock)objPanel).updateFields(feedback);
                    }
                }
                Vector vectorFeedbacks = reportSender.getFeedbackReports();
                int nCount = vectorFeedbacks.size();
                int i2 = 0;
                while (i2 < nCount) {
                    feedback = (Feedback)vectorFeedbacks.elementAt(i2);
                    strName = SENDER_REPORT_BLOCK + " " + i2;
                    node = nodeReport.getSubElement(strName);
                    if (node == null) {
                        node = this.controlTree.createSubElement(nodeReport, strName);
                        panel = new ViewReportBlock(feedback);
                        node.setUserData(panel);
                        node.addActionListener(this);
                    } else {
                        objPanel = node.getUserData();
                        if (objPanel != null && objPanel instanceof ViewReportBlock) {
                            ((ViewReportBlock)objPanel).updateFields(feedback);
                        }
                    }
                    ++i2;
                }
                break block13;
            }
            if (!(report instanceof ReceiverReport)) break block13;
            ReceiverReport reportReceiver = (ReceiverReport)report;
            Vector vectorFeedbacks = reportReceiver.getFeedbackReports();
            int nCount = vectorFeedbacks.size();
            int i2 = 0;
            while (i2 < nCount) {
                Feedback feedback = (Feedback)vectorFeedbacks.elementAt(i2);
                String strName = REPORT_BLOCK + " " + i2;
                TreeNode node = nodeReport.getSubElement(strName);
                if (node == null) {
                    node = this.controlTree.createSubElement(nodeReport, strName);
                    ViewReportBlock panel = new ViewReportBlock(feedback);
                    node.setUserData(panel);
                    node.addActionListener(this);
                } else {
                    Object objPanel = node.getUserData();
                    if (objPanel != null && objPanel instanceof ViewReportBlock) {
                        ((ViewReportBlock)objPanel).updateFields(feedback);
                    }
                }
                ++i2;
            }
        }
    }

    private TreeNode findParticipantListNode() {
        TreeNode nodeRoot = this.controlTree.getRootElement();
        return nodeRoot;
    }

    private TreeNode findParticipantNode(Participant participant) {
        TreeNode nodeRoot = this.controlTree.getRootElement();
        TreeNode node = nodeRoot.getSubElement(participant.getCNAME());
        return node;
    }

    private TreeNode findStreamNode(TreeNode nodeParticipant, RTPStream stream) {
        String strName = this.createStreamNodeName(stream);
        TreeNode node = nodeParticipant.getSubElement(strName);
        return node;
    }

    private TreeNode findStreamLatestReportNode(TreeNode nodeStream) {
        String strName = this.createStreamLatestReportNodeName();
        TreeNode node = nodeStream.getSubElement(strName);
        return node;
    }

    private String createStreamNodeName(RTPStream stream) {
        if (stream == null) {
            return null;
        }
        String strName = stream instanceof ReceiveStream ? REMOTE_RECEIVE_STREAM + ": " : UNKNOWN_STREAM + ": ";
        strName = strName + stream.getParticipant().getCNAME();
        return strName;
    }

    private String createReportNodeName(Report report) {
        long lSSRC = report.getSSRC();
        String strName = REPORT + " " + Signed.UnsignedInt((int)lSSRC);
        return strName;
    }

    private String createStreamLatestReportNodeName() {
        String strName = LATEST_SENDER_REPORT;
        return strName;
    }

    private void setViewPanel(TreeNode node) {
        if (node == null) {
            return;
        }
        Object objData = node.getUserData();
        String strName = node.getFullPathName();
        if (objData != null && objData instanceof JMPanel) {
            this.panelCurrentView = (JMPanel)objData;
            if (this.panelCurrentView.getParent() == null) {
                this.panelView.add((Component)this.panelCurrentView, strName);
            }
            this.layoutView.show(this.panelView, strName);
        }
    }

    private void removeViewPanel(TreeNode node) {
        Object objData = node.getUserData();
        if (objData != null && objData instanceof JMPanel && ((JMPanel)objData).getParent() == this.panelView) {
            this.panelView.remove((JMPanel)objData);
        }
        this.setViewPanel(this.controlTree.getCurrentElement());
    }

    private void layoutComponents() {
        Dimension dim = this.getSize();
        int nWidthTree = (dim.width - 6) / 2;
        if (this.controlTree != null) {
            this.controlTree.setBounds(0, 0, nWidthTree, dim.height);
        }
        if (this.panelView != null) {
            this.panelView.setBounds(nWidthTree + 6, 0, dim.width - (nWidthTree + 6), dim.height);
            this.panelView.doLayout();
        }
        this.repaint();
    }
}

