/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import java.awt.event.ActionListener;
import java.util.Vector;
import javax.media.Format;
import javax.media.control.TrackControl;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;

public abstract class TrackPanel
extends JMPanel {
    protected TrackControl trackControl = null;
    protected Format[] arrSupportedFormats = null;
    protected Vector vectorContSuppFormats = new Vector();
    protected ActionListener listenerEnableTrack = null;

    public TrackPanel(TrackControl trackControl, ActionListener listenerEnableTrack) {
        this.trackControl = trackControl;
        this.listenerEnableTrack = listenerEnableTrack;
        this.arrSupportedFormats = trackControl.getSupportedFormats();
    }

    public TrackControl getTrackControl() {
        return this.trackControl;
    }

    public void updateTrack() {
        if (!this.isTrackEnabled()) {
            this.trackControl.setEnabled(false);
            return;
        }
        Format format2 = this.getFormat();
        if (format2 == null) {
            MessageDialog.createErrorDialog(this.getFrame(), "Internal error. Unable to match choosen format. Track will be disabled.");
            this.trackControl.setEnabled(false);
        } else {
            this.trackControl.setEnabled(true);
            this.trackControl.setFormat(format2);
        }
    }

    public abstract boolean isTrackEnabled();

    public abstract Format getFormat();
}

