/*
 * Decompiled with CFR 0.152.
 */
package junit.awtui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Vector;
import junit.awtui.AboutDialog;
import junit.awtui.Logo;
import junit.awtui.ProgressBar;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;

public class TestRunner
extends BaseTestRunner {
    protected Frame fFrame;
    protected Vector fExceptions;
    protected Vector fFailedTests;
    protected Thread fRunner;
    protected TestResult fTestResult;
    protected TextArea fTraceArea;
    protected TextField fSuiteField;
    protected Button fRun;
    protected ProgressBar fProgressIndicator;
    protected List fFailureList;
    protected Logo fLogo;
    protected Label fNumberOfErrors;
    protected Label fNumberOfFailures;
    protected Label fNumberOfRuns;
    protected Button fQuitButton;
    protected Button fRerunButton;
    protected TextField fStatusLine;
    protected Checkbox fUseLoadingRunner;
    protected static final Font PLAIN_FONT = new Font("dialog", 0, 12);
    private static final int GAP = 4;
    static /* synthetic */ Class class$junit$runner$BaseTestRunner;

    private void about() {
        AboutDialog about = new AboutDialog(this.fFrame);
        about.setModal(true);
        about.setLocation(300, 300);
        about.setVisible(true);
    }

    public void testStarted(String testName) {
        this.showInfo("Running: " + testName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnded(String testName) {
        this.setLabelValue(this.fNumberOfRuns, this.fTestResult.runCount());
        TestRunner testRunner = this;
        synchronized (testRunner) {
            this.fProgressIndicator.step(this.fTestResult.wasSuccessful());
        }
    }

    public void testFailed(int status2, Test test, Throwable t) {
        switch (status2) {
            case 1: {
                this.fNumberOfErrors.setText(Integer.toString(this.fTestResult.errorCount()));
                this.appendFailure("Error", test, t);
                break;
            }
            case 2: {
                this.fNumberOfFailures.setText(Integer.toString(this.fTestResult.failureCount()));
                this.appendFailure("Failure", test, t);
            }
        }
    }

    protected void addGrid(Panel p, Component co, int x, int y, int w, int fill, double wx, int anchor) {
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = x;
        c2.gridy = y;
        c2.gridwidth = w;
        c2.anchor = anchor;
        c2.weightx = wx;
        c2.fill = fill;
        if (fill == 1 || fill == 3) {
            c2.weighty = 1.0;
        }
        c2.insets = new Insets(y == 0 ? 4 : 0, x == 0 ? 4 : 0, 4, 4);
        p.add(co, c2);
    }

    private void appendFailure(String kind, Test test, Throwable t) {
        kind = kind + ": " + test;
        String msg = t.getMessage();
        if (msg != null) {
            kind = kind + ":" + TestRunner.truncate(msg);
        }
        this.fFailureList.add(kind);
        this.fExceptions.addElement(t);
        this.fFailedTests.addElement(test);
        if (this.fFailureList.getItemCount() == 1) {
            this.fFailureList.select(0);
            this.failureSelected();
        }
    }

    protected Menu createJUnitMenu() {
        Menu menu = new Menu("JUnit");
        MenuItem mi = new MenuItem("About...");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TestRunner.this.about();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new MenuItem("Exit");
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        menu.add(mi);
        return menu;
    }

    protected void createMenus(MenuBar mb) {
        mb.add(this.createJUnitMenu());
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected Frame createUI(String suiteName) {
        Frame frame = new Frame("JUnit");
        Image icon = this.loadFrameIcon();
        if (icon != null) {
            frame.setIconImage(icon);
        }
        frame.setLayout(new BorderLayout(0, 0));
        frame.setBackground(SystemColor.control);
        final Frame finalFrame = frame;
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                finalFrame.dispose();
                System.exit(0);
            }
        });
        MenuBar mb = new MenuBar();
        this.createMenus(mb);
        frame.setMenuBar(mb);
        Label suiteLabel = new Label("Test class name:");
        this.fSuiteField = new TextField(suiteName != null ? suiteName : "");
        this.fSuiteField.selectAll();
        this.fSuiteField.requestFocus();
        this.fSuiteField.setFont(PLAIN_FONT);
        this.fSuiteField.setColumns(40);
        this.fSuiteField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                TestRunner.this.runSuite();
            }
        });
        this.fSuiteField.addTextListener(new TextListener(){

            public void textValueChanged(TextEvent e2) {
                TestRunner.this.fRun.setEnabled(TestRunner.this.fSuiteField.getText().length() > 0);
                TestRunner.this.fStatusLine.setText("");
            }
        });
        this.fRun = new Button("Run");
        this.fRun.setEnabled(false);
        this.fRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                TestRunner.this.runSuite();
            }
        });
        boolean useLoader = this.useReloadingTestSuiteLoader();
        this.fUseLoadingRunner = new Checkbox("Reload classes every run", useLoader);
        if (TestRunner.inVAJava()) {
            this.fUseLoadingRunner.setVisible(false);
        }
        this.fProgressIndicator = new ProgressBar();
        this.fNumberOfErrors = new Label("0000", 2);
        this.fNumberOfErrors.setText("0");
        this.fNumberOfErrors.setFont(PLAIN_FONT);
        this.fNumberOfFailures = new Label("0000", 2);
        this.fNumberOfFailures.setText("0");
        this.fNumberOfFailures.setFont(PLAIN_FONT);
        this.fNumberOfRuns = new Label("0000", 2);
        this.fNumberOfRuns.setText("0");
        this.fNumberOfRuns.setFont(PLAIN_FONT);
        Panel numbersPanel = this.createCounterPanel();
        Label failureLabel = new Label("Errors and Failures:");
        this.fFailureList = new List(5);
        this.fFailureList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e2) {
                TestRunner.this.failureSelected();
            }
        });
        this.fRerunButton = new Button("Run");
        this.fRerunButton.setEnabled(false);
        this.fRerunButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                TestRunner.this.rerun();
            }
        });
        Panel failedPanel = new Panel(new GridLayout(0, 1, 0, 2));
        failedPanel.add(this.fRerunButton);
        this.fTraceArea = new TextArea();
        this.fTraceArea.setRows(5);
        this.fTraceArea.setColumns(60);
        this.fStatusLine = new TextField();
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setEditable(false);
        this.fStatusLine.setForeground(Color.red);
        this.fQuitButton = new Button("Exit");
        this.fQuitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                System.exit(0);
            }
        });
        this.fLogo = new Logo();
        Panel panel = new Panel(new GridBagLayout());
        this.addGrid(panel, suiteLabel, 0, 0, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fSuiteField, 0, 1, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fRun, 2, 1, 1, 2, 0.0, 10);
        this.addGrid(panel, this.fUseLoadingRunner, 0, 2, 2, 0, 1.0, 17);
        this.addGrid(panel, this.fProgressIndicator, 0, 3, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fLogo, 2, 3, 1, 0, 0.0, 11);
        this.addGrid(panel, numbersPanel, 0, 4, 2, 0, 0.0, 17);
        this.addGrid(panel, failureLabel, 0, 5, 2, 2, 1.0, 17);
        this.addGrid(panel, this.fFailureList, 0, 6, 2, 1, 1.0, 17);
        this.addGrid(panel, failedPanel, 2, 6, 1, 2, 0.0, 10);
        this.addGrid(panel, this.fTraceArea, 0, 7, 2, 1, 1.0, 17);
        this.addGrid(panel, this.fStatusLine, 0, 8, 2, 2, 1.0, 10);
        this.addGrid(panel, this.fQuitButton, 2, 8, 1, 2, 0.0, 10);
        frame.add((Component)panel, "Center");
        frame.pack();
        return frame;
    }

    protected Panel createCounterPanel() {
        Panel numbersPanel = new Panel(new GridBagLayout());
        this.addToCounterPanel(numbersPanel, new Label("Runs:"), 0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0));
        this.addToCounterPanel(numbersPanel, this.fNumberOfRuns, 1, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 40));
        this.addToCounterPanel(numbersPanel, new Label("Errors:"), 2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToCounterPanel(numbersPanel, this.fNumberOfErrors, 3, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 40));
        this.addToCounterPanel(numbersPanel, new Label("Failures:"), 4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0));
        this.addToCounterPanel(numbersPanel, this.fNumberOfFailures, 5, 0, 1, 1, 0.33, 0.0, 10, 2, new Insets(0, 8, 0, 0));
        return numbersPanel;
    }

    private void addToCounterPanel(Panel counter, Component comp, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.insets = insets;
        counter.add(comp, constraints);
    }

    public void failureSelected() {
        this.fRerunButton.setEnabled(this.isErrorSelected());
        this.showErrorTrace();
    }

    private boolean isErrorSelected() {
        return this.fFailureList.getSelectedIndex() != -1;
    }

    private Image loadFrameIcon() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL url = (class$junit$runner$BaseTestRunner == null ? (class$junit$runner$BaseTestRunner = TestRunner.class$("junit.runner.BaseTestRunner")) : class$junit$runner$BaseTestRunner).getResource("smalllogo.gif");
            return toolkit.createImage((ImageProducer)url.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Thread getRunner() {
        return this.fRunner;
    }

    public static void main(String[] args) {
        new TestRunner().start(args);
    }

    public static void run(Class test) {
        String[] args = new String[]{test.getName()};
        TestRunner.main(args);
    }

    public void rerun() {
        int index = this.fFailureList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        Test test = (Test)this.fFailedTests.elementAt(index);
        this.rerunTest(test);
    }

    private void rerunTest(Test test) {
        if (!(test instanceof TestCase)) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        Test reloadedTest = null;
        TestCase rerunTest = (TestCase)test;
        try {
            Class reloadedTestClass = this.getLoader().reload(test.getClass());
            reloadedTest = TestSuite.createTest(reloadedTestClass, rerunTest.getName());
        }
        catch (Exception e2) {
            this.showInfo("Could not reload " + test.toString());
            return;
        }
        TestResult result2 = new TestResult();
        reloadedTest.run(result2);
        String message = reloadedTest.toString();
        if (result2.wasSuccessful()) {
            this.showInfo(message + " was successful");
        } else if (result2.errorCount() == 1) {
            this.showStatus(message + " had an error");
        } else {
            this.showStatus(message + " had a failure");
        }
    }

    protected void reset() {
        this.setLabelValue(this.fNumberOfErrors, 0);
        this.setLabelValue(this.fNumberOfFailures, 0);
        this.setLabelValue(this.fNumberOfRuns, 0);
        this.fProgressIndicator.reset();
        this.fRerunButton.setEnabled(false);
        this.fFailureList.removeAll();
        this.fExceptions = new Vector(10);
        this.fFailedTests = new Vector(10);
        this.fTraceArea.setText("");
    }

    protected void runFailed(String message) {
        this.showStatus(message);
        this.fRun.setLabel("Run");
        this.fRunner = null;
    }

    public synchronized void runSuite() {
        if (this.fRunner != null && this.fTestResult != null) {
            this.fTestResult.stop();
        } else {
            this.setLoading(this.shouldReload());
            this.fRun.setLabel("Stop");
            this.showInfo("Initializing...");
            this.reset();
            this.showInfo("Load Test Case...");
            final Test testSuite = this.getTest(this.fSuiteField.getText());
            if (testSuite != null) {
                this.fRunner = new Thread(){

                    public void run() {
                        TestRunner.this.fTestResult = TestRunner.this.createTestResult();
                        TestRunner.this.fTestResult.addListener(TestRunner.this);
                        TestRunner.this.fProgressIndicator.start(testSuite.countTestCases());
                        TestRunner.this.showInfo("Running...");
                        long startTime = System.currentTimeMillis();
                        testSuite.run(TestRunner.this.fTestResult);
                        if (TestRunner.this.fTestResult.shouldStop()) {
                            TestRunner.this.showStatus("Stopped");
                        } else {
                            long endTime = System.currentTimeMillis();
                            long runTime = endTime - startTime;
                            TestRunner.this.showInfo("Finished: " + TestRunner.this.elapsedTimeAsString(runTime) + " seconds");
                        }
                        TestRunner.this.fTestResult = null;
                        TestRunner.this.fRun.setLabel("Run");
                        TestRunner.this.fRunner = null;
                        System.gc();
                    }
                };
                this.fRunner.start();
            }
        }
    }

    private boolean shouldReload() {
        return !TestRunner.inVAJava() && this.fUseLoadingRunner.getState();
    }

    private void setLabelValue(Label label, int value) {
        label.setText(Integer.toString(value));
        label.invalidate();
        label.getParent().validate();
    }

    public void setSuiteName(String suite) {
        this.fSuiteField.setText(suite);
    }

    private void showErrorTrace() {
        int index = this.fFailureList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        Throwable t = (Throwable)this.fExceptions.elementAt(index);
        this.fTraceArea.setText(TestRunner.getFilteredTrace(t));
    }

    private void showInfo(String message) {
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setForeground(Color.black);
        this.fStatusLine.setText(message);
    }

    protected void clearStatus() {
        this.showStatus("");
    }

    private void showStatus(String status2) {
        this.fStatusLine.setFont(PLAIN_FONT);
        this.fStatusLine.setForeground(Color.red);
        this.fStatusLine.setText(status2);
    }

    public void start(String[] args) {
        String suiteName = this.processArguments(args);
        this.fFrame = this.createUI(suiteName);
        this.fFrame.setLocation(200, 200);
        this.fFrame.setVisible(true);
        if (suiteName != null) {
            this.setSuiteName(suiteName);
            this.runSuite();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

