/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestResult;

public abstract class TestCase
extends Assert
implements Test {
    private String fName;

    public TestCase() {
        this.fName = null;
    }

    public TestCase(String name) {
        this.fName = name;
    }

    public int countTestCases() {
        return 1;
    }

    protected TestResult createResult() {
        return new TestResult();
    }

    public TestResult run() {
        TestResult result2 = this.createResult();
        this.run(result2);
        return result2;
    }

    public void run(TestResult result2) {
        result2.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runBare() throws Throwable {
        Throwable exception;
        block11: {
            exception = null;
            this.setUp();
            this.runTest();
            Object var4_2 = null;
            try {
                this.tearDown();
            }
            catch (Throwable tearingDown) {
                if (exception == null) {
                    exception = tearingDown;
                }
                break block11;
            }
            {
                catch (Throwable running2) {
                    exception = running2;
                    Object var4_3 = null;
                    try {
                        this.tearDown();
                    }
                    catch (Throwable tearingDown) {
                        if (exception == null) {
                            exception = tearingDown;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block12: {
                    Object var4_4 = null;
                    try {
                        this.tearDown();
                    }
                    catch (Throwable tearingDown) {
                        if (exception != null) break block12;
                        exception = tearingDown;
                    }
                }
                throw throwable;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void runTest() throws Throwable {
        TestCase.assertNotNull(this.fName);
        Method runMethod = null;
        try {
            runMethod = this.getClass().getMethod(this.fName, null);
        }
        catch (NoSuchMethodException e2) {
            TestCase.fail("Method \"" + this.fName + "\" not found");
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            TestCase.fail("Method \"" + this.fName + "\" should be public");
        }
        try {
            runMethod.invoke((Object)this, (Object[])new Class[0]);
        }
        catch (InvocationTargetException e3) {
            e3.fillInStackTrace();
            throw e3.getTargetException();
        }
        catch (IllegalAccessException e4) {
            e4.fillInStackTrace();
            throw e4;
        }
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public String toString() {
        return this.getName() + "(" + this.getClass().getName() + ")";
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }
}

