/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.runner.TestCollector;

public abstract class ClassPathTestCollector
implements TestCollector {
    static final int SUFFIX_LENGTH = ".class".length();

    public Enumeration collectTests() {
        String classPath = System.getProperty("java.class.path");
        Hashtable result2 = this.collectFilesInPath(classPath);
        return result2.elements();
    }

    public Hashtable collectFilesInPath(String classPath) {
        Hashtable result2 = this.collectFilesInRoots(this.splitClassPath(classPath));
        return result2;
    }

    Hashtable collectFilesInRoots(Vector roots) {
        Hashtable result2 = new Hashtable(100);
        Enumeration e2 = roots.elements();
        while (e2.hasMoreElements()) {
            this.gatherFiles(new File((String)e2.nextElement()), "", result2);
        }
        return result2;
    }

    void gatherFiles(File classRoot, String classFileName, Hashtable result2) {
        File thisRoot = new File(classRoot, classFileName);
        if (thisRoot.isFile()) {
            if (this.isTestClass(classFileName)) {
                String className = this.classNameFromFile(classFileName);
                result2.put(className, className);
            }
            return;
        }
        String[] contents = thisRoot.list();
        if (contents != null) {
            for (int i2 = 0; i2 < contents.length; ++i2) {
                this.gatherFiles(classRoot, classFileName + File.separatorChar + contents[i2], result2);
            }
        }
    }

    Vector splitClassPath(String classPath) {
        Vector<String> result2 = new Vector<String>();
        String separator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classPath, separator);
        while (tokenizer.hasMoreTokens()) {
            result2.addElement(tokenizer.nextToken());
        }
        return result2;
    }

    protected boolean isTestClass(String classFileName) {
        return classFileName.endsWith(".class") && classFileName.indexOf(36) < 0 && classFileName.indexOf("Test") > 0;
    }

    protected String classNameFromFile(String classFileName) {
        String s = classFileName.substring(0, classFileName.length() - SUFFIX_LENGTH);
        String s2 = s.replace(File.separatorChar, '.');
        if (s2.startsWith(".")) {
            return s2.substring(1);
        }
        return s2;
    }
}

