/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TestCaseClassLoader
extends ClassLoader {
    private Vector fPathItems;
    private String[] defaultExclusions = new String[]{"junit.framework.", "junit.extensions.", "junit.runner."};
    static final String EXCLUDED_FILE = "excluded.properties";
    private Vector fExcluded;

    public TestCaseClassLoader() {
        this(System.getProperty("java.class.path"));
    }

    public TestCaseClassLoader(String classPath) {
        this.scanPath(classPath);
        this.readExcludedPackages();
    }

    private void scanPath(String classPath) {
        String separator = System.getProperty("path.separator");
        this.fPathItems = new Vector(10);
        StringTokenizer st = new StringTokenizer(classPath, separator);
        while (st.hasMoreTokens()) {
            this.fPathItems.addElement(st.nextToken());
        }
    }

    public URL getResource(String name) {
        return ClassLoader.getSystemResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public boolean isExcluded(String name) {
        for (int i2 = 0; i2 < this.fExcluded.size(); ++i2) {
            if (!name.startsWith((String)this.fExcluded.elementAt(i2))) continue;
            return true;
        }
        return false;
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c2 = this.findLoadedClass(name);
        if (c2 != null) {
            return c2;
        }
        if (this.isExcluded(name)) {
            try {
                c2 = this.findSystemClass(name);
                return c2;
            }
            catch (ClassNotFoundException e2) {
                // empty catch block
            }
        }
        if (c2 == null) {
            byte[] data = this.lookupClassData(name);
            if (data == null) {
                throw new ClassNotFoundException();
            }
            c2 = this.defineClass(name, data, 0, data.length);
        }
        if (resolve) {
            this.resolveClass(c2);
        }
        return c2;
    }

    private byte[] lookupClassData(String className) throws ClassNotFoundException {
        byte[] data = null;
        for (int i2 = 0; i2 < this.fPathItems.size(); ++i2) {
            String path = (String)this.fPathItems.elementAt(i2);
            String fileName = className.replace('.', '/') + ".class";
            data = this.isJar(path) ? this.loadJarData(path, fileName) : this.loadFileData(path, fileName);
            if (data == null) continue;
            return data;
        }
        throw new ClassNotFoundException(className);
    }

    boolean isJar(String pathEntry) {
        return pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip");
    }

    private byte[] loadFileData(String path, String fileName) {
        File file = new File(path, fileName);
        if (file.exists()) {
            return this.getClassData(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] getClassData(File f2) {
        int n2;
        FileInputStream stream = null;
        stream = new FileInputStream(f2);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
        byte[] b2 = new byte[1000];
        while ((n2 = stream.read(b2)) != -1) {
            out.write(b2, 0, n2);
        }
        stream.close();
        out.close();
        byte[] byArray = out.toByteArray();
        Object var8_8 = null;
        if (stream == null) return byArray;
        try {
            stream.close();
            return byArray;
        }
        catch (IOException e1) {
            // empty catch block
        }
        return byArray;
        catch (IOException iOException) {
            try {
                Object var8_9 = null;
                if (stream == null) return null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                stream.close();
                return null;
            }
            catch (IOException e1) {}
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] loadJarData(String path, String fileName) {
        int n2;
        ZipFile zipFile = null;
        InputStream stream = null;
        File archive = new File(path);
        if (!archive.exists()) {
            return null;
        }
        try {
            zipFile = new ZipFile(archive);
        }
        catch (IOException io) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        int size = (int)entry.getSize();
        stream = zipFile.getInputStream(entry);
        byte[] data = new byte[size];
        for (int pos = 0; pos < size; pos += n2) {
            n2 = stream.read(data, pos, data.length - pos);
        }
        zipFile.close();
        byte[] byArray = data;
        Object var12_14 = null;
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        return byArray;
        catch (IOException e3) {
            try {
                Object var12_15 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e2) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readExcludedPackages() {
        Properties p;
        block14: {
            this.fExcluded = new Vector(10);
            for (int i2 = 0; i2 < this.defaultExclusions.length; ++i2) {
                this.fExcluded.addElement(this.defaultExclusions[i2]);
            }
            InputStream is = this.getClass().getResourceAsStream(EXCLUDED_FILE);
            if (is == null) {
                return;
            }
            p = new Properties();
            p.load(is);
            try {
                is.close();
            }
            catch (IOException e2) {}
            break block14;
            catch (IOException e3) {
                try {
                    is.close();
                }
                catch (IOException e4) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (IOException e5) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        Enumeration<?> e6 = p.propertyNames();
        while (e6.hasMoreElements()) {
            String key = (String)e6.nextElement();
            if (!key.startsWith("excluded.")) continue;
            String path = p.getProperty(key);
            if ((path = path.trim()).endsWith("*")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() <= 0) continue;
            this.fExcluded.addElement(path);
        }
    }
}

