/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib;

import li.cil.repack.org.luaj.vm2.Globals;
import li.cil.repack.org.luaj.vm2.Lua;
import li.cil.repack.org.luaj.vm2.LuaBoolean;
import li.cil.repack.org.luaj.vm2.LuaClosure;
import li.cil.repack.org.luaj.vm2.LuaError;
import li.cil.repack.org.luaj.vm2.LuaFunction;
import li.cil.repack.org.luaj.vm2.LuaNil;
import li.cil.repack.org.luaj.vm2.LuaNumber;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.LuaTable;
import li.cil.repack.org.luaj.vm2.LuaThread;
import li.cil.repack.org.luaj.vm2.LuaUserdata;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Print;
import li.cil.repack.org.luaj.vm2.Prototype;
import li.cil.repack.org.luaj.vm2.Varargs;
import li.cil.repack.org.luaj.vm2.lib.LibFunction;
import li.cil.repack.org.luaj.vm2.lib.TwoArgFunction;
import li.cil.repack.org.luaj.vm2.lib.VarArgFunction;
import li.cil.repack.org.luaj.vm2.lib.ZeroArgFunction;

public class DebugLib
extends TwoArgFunction {
    public static boolean CALLS;
    public static boolean TRACE;
    static final LuaString LUA;
    private static final LuaString QMARK;
    private static final LuaString CALL;
    private static final LuaString LINE;
    private static final LuaString COUNT;
    private static final LuaString RETURN;
    static final LuaString FUNC;
    static final LuaString ISTAILCALL;
    static final LuaString ISVARARG;
    static final LuaString NUPS;
    static final LuaString NPARAMS;
    static final LuaString NAME;
    static final LuaString NAMEWHAT;
    static final LuaString WHAT;
    static final LuaString SOURCE;
    static final LuaString SHORT_SRC;
    static final LuaString LINEDEFINED;
    static final LuaString LASTLINEDEFINED;
    static final LuaString CURRENTLINE;
    static final LuaString ACTIVELINES;
    Globals globals;

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        this.globals = env.checkglobals();
        this.globals.debuglib = this;
        LuaTable debug2 = new LuaTable();
        debug2.set("debug", (LuaValue)new debug());
        debug2.set("gethook", (LuaValue)new gethook());
        debug2.set("getinfo", (LuaValue)new getinfo());
        debug2.set("getlocal", (LuaValue)new getlocal());
        debug2.set("getmetatable", (LuaValue)new getmetatable());
        debug2.set("getregistry", (LuaValue)new getregistry());
        debug2.set("getupvalue", (LuaValue)new getupvalue());
        debug2.set("getuservalue", (LuaValue)new getuservalue());
        debug2.set("sethook", (LuaValue)new sethook());
        debug2.set("setlocal", (LuaValue)new setlocal());
        debug2.set("setmetatable", (LuaValue)new setmetatable());
        debug2.set("setupvalue", (LuaValue)new setupvalue());
        debug2.set("setuservalue", (LuaValue)new setuservalue());
        debug2.set("traceback", (LuaValue)new traceback());
        debug2.set("upvalueid", (LuaValue)new upvalueid());
        debug2.set("upvaluejoin", (LuaValue)new upvaluejoin());
        env.set("debug", (LuaValue)debug2);
        if (!env.get("package").isnil()) {
            env.get("package").get("loaded").set("debug", (LuaValue)debug2);
        }
        return debug2;
    }

    public void onCall(LuaFunction f2) {
        LuaThread.State s = this.globals.running.state;
        if (s.inhook) {
            return;
        }
        this.callstack().onCall(f2);
        if (s.hookcall) {
            this.callHook(s, CALL, NIL);
        }
    }

    public void onCall(LuaClosure c2, Varargs varargs2, LuaValue[] stack) {
        LuaThread.State s = this.globals.running.state;
        if (s.inhook) {
            return;
        }
        this.callstack().onCall(c2, varargs2, stack);
        if (s.hookcall) {
            this.callHook(s, CALL, NIL);
        }
    }

    public void onInstruction(int pc, Varargs v, int top) {
        int newline;
        LuaThread.State s = this.globals.running.state;
        if (s.inhook) {
            return;
        }
        this.callstack().onInstruction(pc, v, top);
        if (s.hookfunc == null) {
            return;
        }
        if (s.hookcount > 0 && ++s.bytecodes % s.hookcount == 0) {
            this.callHook(s, COUNT, NIL);
        }
        if (s.hookline && (newline = this.callstack().currentline()) != s.lastline) {
            s.lastline = newline;
            this.callHook(s, LINE, LuaValue.valueOf(newline));
        }
    }

    public void onReturn() {
        LuaThread.State s = this.globals.running.state;
        if (s.inhook) {
            return;
        }
        this.callstack().onReturn();
        if (s.hookrtrn) {
            this.callHook(s, RETURN, NIL);
        }
    }

    public String traceback(int level) {
        return this.callstack().traceback(level);
    }

    public CallFrame getCallFrame(int level) {
        return this.callstack().getCallFrame(level);
    }

    void callHook(LuaThread.State s, LuaValue type2, LuaValue arg) {
        if (s.inhook || s.hookfunc == null) {
            return;
        }
        s.inhook = true;
        try {
            s.hookfunc.call(type2, arg);
        }
        catch (LuaError e2) {
            throw e2;
        }
        catch (RuntimeException e3) {
            throw new LuaError(e3);
        }
        finally {
            s.inhook = false;
        }
    }

    CallStack callstack() {
        return this.callstack(this.globals.running);
    }

    CallStack callstack(LuaThread t) {
        if (t.callstack == null) {
            t.callstack = new CallStack();
        }
        return (CallStack)t.callstack;
    }

    static LuaString findupvalue(LuaClosure c2, int up) {
        if (c2.upValues != null && up > 0 && up <= c2.upValues.length) {
            if (c2.p.upvalues != null && up <= c2.p.upvalues.length) {
                return c2.p.upvalues[up - 1].name;
            }
            return LuaString.valueOf("." + up);
        }
        return null;
    }

    static void lua_assert(boolean x) {
        if (!x) {
            throw new RuntimeException("lua_assert failed");
        }
    }

    static NameWhat getfuncname(CallFrame frame) {
        LuaString tm;
        if (!frame.f.isclosure()) {
            return new NameWhat(frame.f.classnamestub(), "Java");
        }
        Prototype p = frame.f.checkclosure().p;
        int pc = frame.pc;
        int i2 = p.code[pc];
        switch (Lua.GET_OPCODE(i2)) {
            case 29: 
            case 30: {
                return DebugLib.getobjname(p, pc, Lua.GETARG_A(i2));
            }
            case 34: {
                return new NameWhat("(for iterator)", "(for iterator");
            }
            case 6: 
            case 7: 
            case 12: {
                tm = LuaValue.INDEX;
                break;
            }
            case 8: 
            case 10: {
                tm = LuaValue.NEWINDEX;
                break;
            }
            case 24: {
                tm = LuaValue.EQ;
                break;
            }
            case 13: {
                tm = LuaValue.ADD;
                break;
            }
            case 14: {
                tm = LuaValue.SUB;
                break;
            }
            case 15: {
                tm = LuaValue.MUL;
                break;
            }
            case 16: {
                tm = LuaValue.DIV;
                break;
            }
            case 17: {
                tm = LuaValue.MOD;
                break;
            }
            case 18: {
                tm = LuaValue.POW;
                break;
            }
            case 19: {
                tm = LuaValue.UNM;
                break;
            }
            case 21: {
                tm = LuaValue.LEN;
                break;
            }
            case 25: {
                tm = LuaValue.LT;
                break;
            }
            case 26: {
                tm = LuaValue.LE;
                break;
            }
            case 22: {
                tm = LuaValue.CONCAT;
                break;
            }
            default: {
                return null;
            }
        }
        return new NameWhat(tm.tojstring(), "metamethod");
    }

    public static NameWhat getobjname(Prototype p, int lastpc, int reg) {
        int pc = lastpc;
        LuaString name = p.getlocalname(reg + 1, pc);
        if (name != null) {
            return new NameWhat(name.tojstring(), "local");
        }
        pc = DebugLib.findsetreg(p, lastpc, reg);
        if (pc != -1) {
            int i2 = p.code[pc];
            switch (Lua.GET_OPCODE(i2)) {
                case 0: {
                    int a2 = Lua.GETARG_A(i2);
                    int b2 = Lua.GETARG_B(i2);
                    if (b2 >= a2) break;
                    return DebugLib.getobjname(p, pc, b2);
                }
                case 6: 
                case 7: {
                    int k2 = Lua.GETARG_C(i2);
                    int t = Lua.GETARG_B(i2);
                    LuaString vn = Lua.GET_OPCODE(i2) == 7 ? p.getlocalname(t + 1, pc) : (t < p.upvalues.length ? p.upvalues[t].name : QMARK);
                    String jname = DebugLib.kname(p, pc, k2);
                    return new NameWhat(jname, vn != null && vn.eq_b(ENV) ? "global" : "field");
                }
                case 5: {
                    int u = Lua.GETARG_B(i2);
                    name = u < p.upvalues.length ? p.upvalues[u].name : QMARK;
                    return name == null ? null : new NameWhat(name.tojstring(), "upvalue");
                }
                case 1: 
                case 2: {
                    int b3;
                    int n2 = b3 = Lua.GET_OPCODE(i2) == 1 ? Lua.GETARG_Bx(i2) : Lua.GETARG_Ax(p.code[pc + 1]);
                    if (!p.k[b3].isstring()) break;
                    name = p.k[b3].strvalue();
                    return new NameWhat(name.tojstring(), "constant");
                }
                case 12: {
                    int k3 = Lua.GETARG_C(i2);
                    String jname = DebugLib.kname(p, pc, k3);
                    return new NameWhat(jname, "method");
                }
            }
        }
        return null;
    }

    static String kname(Prototype p, int pc, int c2) {
        if (Lua.ISK(c2)) {
            LuaValue k2 = p.k[Lua.INDEXK(c2)];
            if (k2.isstring()) {
                return k2.tojstring();
            }
        } else {
            NameWhat what = DebugLib.getobjname(p, pc, c2);
            if (what != null && "constant".equals(what.namewhat)) {
                return what.name;
            }
        }
        return "?";
    }

    static int findsetreg(Prototype p, int lastpc, int reg) {
        int setreg = -1;
        block8: for (int pc = 0; pc < lastpc; ++pc) {
            int i2 = p.code[pc];
            int op = Lua.GET_OPCODE(i2);
            int a2 = Lua.GETARG_A(i2);
            switch (op) {
                case 4: {
                    int b2 = Lua.GETARG_B(i2);
                    if (a2 > reg || reg > a2 + b2) continue block8;
                    setreg = pc;
                    continue block8;
                }
                case 34: {
                    if (reg < a2 + 2) continue block8;
                    setreg = pc;
                    continue block8;
                }
                case 29: 
                case 30: {
                    if (reg < a2) continue block8;
                    setreg = pc;
                    continue block8;
                }
                case 23: {
                    int b2 = Lua.GETARG_sBx(i2);
                    int dest = pc + 1 + b2;
                    if (pc >= dest || dest > lastpc) continue block8;
                    pc += b2;
                    continue block8;
                }
                case 27: {
                    if (reg != a2) continue block8;
                    setreg = pc;
                    continue block8;
                }
                case 36: {
                    if ((i2 >> 14 & 0x1FF) != 0) continue block8;
                    ++pc;
                    continue block8;
                }
                default: {
                    if (!Lua.testAMode(op) || reg != a2) continue block8;
                    setreg = pc;
                }
            }
        }
        return setreg;
    }

    static {
        try {
            CALLS = null != System.getProperty("CALLS");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            TRACE = null != System.getProperty("TRACE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LUA = DebugLib.valueOf("Lua");
        QMARK = DebugLib.valueOf("?");
        CALL = DebugLib.valueOf("call");
        LINE = DebugLib.valueOf("line");
        COUNT = DebugLib.valueOf("count");
        RETURN = DebugLib.valueOf("return");
        FUNC = DebugLib.valueOf("func");
        ISTAILCALL = DebugLib.valueOf("istailcall");
        ISVARARG = DebugLib.valueOf("isvararg");
        NUPS = DebugLib.valueOf("nups");
        NPARAMS = DebugLib.valueOf("nparams");
        NAME = DebugLib.valueOf("name");
        NAMEWHAT = DebugLib.valueOf("namewhat");
        WHAT = DebugLib.valueOf("what");
        SOURCE = DebugLib.valueOf("source");
        SHORT_SRC = DebugLib.valueOf("short_src");
        LINEDEFINED = DebugLib.valueOf("linedefined");
        LASTLINEDEFINED = DebugLib.valueOf("lastlinedefined");
        CURRENTLINE = DebugLib.valueOf("currentline");
        ACTIVELINES = DebugLib.valueOf("activelines");
    }

    static final class debug
    extends ZeroArgFunction {
        debug() {
        }

        @Override
        public LuaValue call() {
            return NONE;
        }
    }

    final class gethook
    extends VarArgFunction {
        gethook() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaThread t = args.narg() > 0 ? args.checkthread(1) : DebugLib.this.globals.running;
            LuaThread.State s = t.state;
            return gethook.varargsOf(s.hookfunc != null ? s.hookfunc : NIL, gethook.valueOf((s.hookcall ? "c" : "") + (s.hookline ? "l" : "") + (s.hookrtrn ? "r" : "")), gethook.valueOf(s.hookcount));
        }
    }

    final class getinfo
    extends VarArgFunction {
        getinfo() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            CallFrame frame;
            int a2 = 1;
            LuaThread thread = args.isthread(a2) ? args.checkthread(a2++) : DebugLib.this.globals.running;
            LuaValue func = args.arg(a2++);
            String what = args.optjstring(a2++, "flnStu");
            CallStack callstack = DebugLib.this.callstack(thread);
            if (func.isnumber()) {
                frame = callstack.getCallFrame(func.toint());
                if (frame == null) {
                    return NONE;
                }
                func = frame.f;
            } else if (func.isfunction()) {
                frame = callstack.findCallFrame(func);
            } else {
                return getinfo.argerror(a2 - 2, "function or level");
            }
            DebugInfo ar = callstack.auxgetinfo(what, (LuaFunction)func, frame);
            LuaTable info = new LuaTable();
            if (what.indexOf(83) >= 0) {
                info.set(WHAT, (LuaValue)LUA);
                info.set(SOURCE, (LuaValue)getinfo.valueOf(ar.source));
                info.set(SHORT_SRC, (LuaValue)getinfo.valueOf(ar.short_src));
                info.set(LINEDEFINED, (LuaValue)getinfo.valueOf(ar.linedefined));
                info.set(LASTLINEDEFINED, (LuaValue)getinfo.valueOf(ar.lastlinedefined));
            }
            if (what.indexOf(108) >= 0) {
                info.set(CURRENTLINE, (LuaValue)getinfo.valueOf(ar.currentline));
            }
            if (what.indexOf(117) >= 0) {
                info.set(NUPS, (LuaValue)getinfo.valueOf(ar.nups));
                info.set(NPARAMS, (LuaValue)getinfo.valueOf(ar.nparams));
                info.set(ISVARARG, (LuaValue)(ar.isvararg ? ONE : ZERO));
            }
            if (what.indexOf(110) >= 0) {
                info.set(NAME, (LuaValue)LuaValue.valueOf(ar.name != null ? ar.name : "?"));
                info.set(NAMEWHAT, (LuaValue)LuaValue.valueOf(ar.namewhat));
            }
            if (what.indexOf(116) >= 0) {
                info.set(ISTAILCALL, (LuaValue)ZERO);
            }
            if (what.indexOf(76) >= 0) {
                CallFrame cf;
                LuaTable lines = new LuaTable();
                info.set(ACTIVELINES, (LuaValue)lines);
                int l2 = 1;
                while ((cf = callstack.getCallFrame(l2)) != null) {
                    if (cf.f == func) {
                        lines.insert(-1, getinfo.valueOf(cf.currentline()));
                    }
                    ++l2;
                }
            }
            if (what.indexOf(102) >= 0 && func != null) {
                info.set(FUNC, func);
            }
            return info;
        }
    }

    final class getlocal
    extends VarArgFunction {
        getlocal() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            int a2 = 1;
            LuaThread thread = args.isthread(a2) ? args.checkthread(a2++) : DebugLib.this.globals.running;
            LuaValue func = args.arg(a2++);
            int local = args.checkint(a2);
            if (func.isfunction()) {
                return func.checkclosure().p.getlocalname(local, 0);
            }
            CallFrame frame = DebugLib.this.callstack(thread).getCallFrame(func.checkint());
            if (frame == null) {
                return getlocal.argerror(a2, "level out of range");
            }
            return frame.getLocal(local);
        }
    }

    static final class getmetatable
    extends LibFunction {
        getmetatable() {
        }

        @Override
        public LuaValue call(LuaValue v) {
            LuaValue mt = v.getmetatable();
            return mt != null ? mt : NIL;
        }
    }

    final class getregistry
    extends ZeroArgFunction {
        getregistry() {
        }

        @Override
        public LuaValue call() {
            return DebugLib.this.globals;
        }
    }

    static final class getupvalue
    extends VarArgFunction {
        getupvalue() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaClosure c2;
            LuaString name;
            LuaFunction func = args.checkfunction(1);
            int up = args.checkint(2);
            if (func instanceof LuaClosure && (name = DebugLib.findupvalue(c2 = (LuaClosure)func, up)) != null) {
                return getupvalue.varargsOf(name, (Varargs)c2.upValues[up - 1].getValue());
            }
            return NIL;
        }
    }

    static final class getuservalue
    extends LibFunction {
        getuservalue() {
        }

        @Override
        public LuaValue call(LuaValue u) {
            return u.isuserdata() ? u : NIL;
        }
    }

    final class sethook
    extends VarArgFunction {
        sethook() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            int a2 = 1;
            LuaThread t = args.isthread(a2) ? args.checkthread(a2++) : DebugLib.this.globals.running;
            LuaFunction func = args.optfunction(a2++, null);
            String str = args.optjstring(a2++, "");
            int count = args.optint(a2++, 0);
            boolean call = false;
            boolean line = false;
            boolean rtrn = false;
            block5: for (int i2 = 0; i2 < str.length(); ++i2) {
                switch (str.charAt(i2)) {
                    case 'c': {
                        call = true;
                        continue block5;
                    }
                    case 'l': {
                        line = true;
                        continue block5;
                    }
                    case 'r': {
                        rtrn = true;
                    }
                }
            }
            LuaThread.State s = t.state;
            s.hookfunc = func;
            s.hookcall = call;
            s.hookline = line;
            s.hookcount = count;
            s.hookrtrn = rtrn;
            return NONE;
        }
    }

    final class setlocal
    extends VarArgFunction {
        setlocal() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            int a2 = 1;
            LuaThread thread = args.isthread(a2) ? args.checkthread(a2++) : DebugLib.this.globals.running;
            int level = args.checkint(a2++);
            int local = args.checkint(a2++);
            LuaValue value = args.arg(a2++);
            CallFrame f2 = DebugLib.this.callstack(thread).getCallFrame(level);
            return f2 != null ? f2.setLocal(local, value) : NONE;
        }
    }

    static final class setmetatable
    extends TwoArgFunction {
        setmetatable() {
        }

        @Override
        public LuaValue call(LuaValue value, LuaValue table) {
            LuaTable mt = table.opttable(null);
            switch (value.type()) {
                case 0: {
                    LuaNil.s_metatable = mt;
                    break;
                }
                case 3: {
                    LuaNumber.s_metatable = mt;
                    break;
                }
                case 1: {
                    LuaBoolean.s_metatable = mt;
                    break;
                }
                case 4: {
                    LuaString.s_metatable = mt;
                    break;
                }
                case 6: {
                    LuaFunction.s_metatable = mt;
                    break;
                }
                case 8: {
                    LuaThread.s_metatable = mt;
                    break;
                }
                default: {
                    value.setmetatable(mt);
                }
            }
            return value;
        }
    }

    static final class setupvalue
    extends VarArgFunction {
        setupvalue() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaClosure c2;
            LuaString name;
            LuaValue value = args.checkvalue(3);
            int up = args.checkint(2);
            LuaFunction func = args.checkfunction(1);
            if (func instanceof LuaClosure && (name = DebugLib.findupvalue(c2 = (LuaClosure)func, up)) != null) {
                c2.upValues[up - 1].setValue(value);
                return name;
            }
            return NIL;
        }
    }

    static final class setuservalue
    extends VarArgFunction {
        setuservalue() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            Object o2 = args.checkuserdata(1);
            LuaValue v = args.checkvalue(2);
            LuaUserdata u = (LuaUserdata)args.arg1();
            u.m_instance = v.checkuserdata();
            u.m_metatable = v.getmetatable();
            return NONE;
        }
    }

    final class traceback
    extends VarArgFunction {
        traceback() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            int a2 = 1;
            LuaThread thread = args.isthread(a2) ? args.checkthread(a2++) : DebugLib.this.globals.running;
            String message = args.optjstring(a2++, null);
            int level = args.optint(a2++, 1);
            String tb = DebugLib.this.callstack(thread).traceback(level);
            return traceback.valueOf(message != null ? message + "\n" + tb : tb);
        }
    }

    static final class upvalueid
    extends VarArgFunction {
        upvalueid() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            int up = args.checkint(2);
            LuaFunction func = args.checkfunction(1);
            if (func instanceof LuaClosure) {
                LuaClosure c2 = (LuaClosure)func;
                if (c2.upValues != null && up > 0 && up <= c2.upValues.length) {
                    return upvalueid.valueOf(c2.upValues[up - 1].hashCode());
                }
            }
            return NIL;
        }
    }

    static final class upvaluejoin
    extends VarArgFunction {
        upvaluejoin() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            int n1 = args.checkint(2);
            LuaClosure f1 = args.checkclosure(1);
            int n2 = args.checkint(4);
            LuaClosure f2 = args.checkclosure(3);
            if (n1 < 1 || n1 > f1.upValues.length) {
                this.argerror("index out of range");
            }
            if (n2 < 1 || n2 > f2.upValues.length) {
                this.argerror("index out of range");
            }
            f1.upValues[n1 - 1] = f2.upValues[n2 - 1];
            return NONE;
        }
    }

    public static class CallStack {
        static final CallFrame[] EMPTY = new CallFrame[0];
        CallFrame[] frame = EMPTY;
        int calls = 0;

        CallStack() {
        }

        synchronized int currentline() {
            return this.calls > 0 ? this.frame[this.calls - 1].currentline() : -1;
        }

        private synchronized CallFrame pushcall() {
            if (this.calls >= this.frame.length) {
                int i2;
                int n2 = Math.max(4, this.frame.length * 3 / 2);
                CallFrame[] f2 = new CallFrame[n2];
                System.arraycopy(this.frame, 0, f2, 0, this.frame.length);
                for (i2 = this.frame.length; i2 < n2; ++i2) {
                    f2[i2] = new CallFrame();
                }
                this.frame = f2;
                for (i2 = 1; i2 < n2; ++i2) {
                    f2[i2].previous = f2[i2 - 1];
                }
            }
            return this.frame[this.calls++];
        }

        final synchronized void onCall(LuaFunction function) {
            this.pushcall().set(function);
        }

        final synchronized void onCall(LuaClosure function, Varargs varargs2, LuaValue[] stack) {
            this.pushcall().set(function, varargs2, stack);
        }

        final synchronized void onReturn() {
            if (this.calls > 0) {
                this.frame[--this.calls].reset();
            }
        }

        final synchronized void onInstruction(int pc, Varargs v, int top) {
            if (this.calls > 0) {
                this.frame[this.calls - 1].instr(pc, v, top);
            }
        }

        synchronized String traceback(int level) {
            CallFrame c2;
            StringBuffer sb = new StringBuffer();
            sb.append("stack traceback:");
            while ((c2 = this.getCallFrame(level++)) != null) {
                sb.append("\n\t");
                sb.append(c2.shortsource());
                sb.append(':');
                if (c2.currentline() > 0) {
                    sb.append(c2.currentline() + ":");
                }
                sb.append(" in ");
                DebugInfo ar = this.auxgetinfo("n", c2.f, c2);
                if (c2.linedefined() == 0) {
                    sb.append("main chunk");
                    continue;
                }
                if (ar.name != null) {
                    sb.append("function '");
                    sb.append(ar.name);
                    sb.append('\'');
                    continue;
                }
                sb.append("function <");
                sb.append(c2.shortsource());
                sb.append(':');
                sb.append(c2.linedefined());
                sb.append('>');
            }
            sb.append("\n\t[Java]: in ?");
            return sb.toString();
        }

        synchronized CallFrame getCallFrame(int level) {
            if (level < 1 || level > this.calls) {
                return null;
            }
            return this.frame[this.calls - level];
        }

        synchronized CallFrame findCallFrame(LuaValue func) {
            for (int i2 = 1; i2 <= this.calls; ++i2) {
                if (this.frame[this.calls - i2].f != func) continue;
                return this.frame[i2];
            }
            return null;
        }

        synchronized DebugInfo auxgetinfo(String what, LuaFunction f2, CallFrame ci) {
            DebugInfo ar = new DebugInfo();
            int n2 = what.length();
            block8: for (int i2 = 0; i2 < n2; ++i2) {
                switch (what.charAt(i2)) {
                    case 'S': {
                        ar.funcinfo(f2);
                        continue block8;
                    }
                    case 'l': {
                        ar.currentline = ci != null && ci.f.isclosure() ? ci.currentline() : -1;
                        continue block8;
                    }
                    case 'u': {
                        if (f2 != null && f2.isclosure()) {
                            Prototype p = f2.checkclosure().p;
                            ar.nups = (short)p.upvalues.length;
                            ar.nparams = (short)p.numparams;
                            ar.isvararg = p.is_vararg != 0;
                            continue block8;
                        }
                        ar.nups = 0;
                        ar.isvararg = true;
                        ar.nparams = 0;
                        continue block8;
                    }
                    case 't': {
                        ar.istailcall = false;
                        continue block8;
                    }
                    case 'n': {
                        NameWhat nw;
                        if (ci != null && ci.previous != null && ci.previous.f.isclosure() && (nw = DebugLib.getfuncname(ci.previous)) != null) {
                            ar.name = nw.name;
                            ar.namewhat = nw.namewhat;
                        }
                        if (ar.namewhat != null) continue block8;
                        ar.namewhat = "";
                        ar.name = null;
                        continue block8;
                    }
                    case 'L': 
                    case 'f': {
                        continue block8;
                    }
                }
            }
            return ar;
        }
    }

    public static class CallFrame {
        static final LuaValue[] EMPTY = new LuaValue[0];
        LuaFunction f;
        int pc;
        int top;
        Varargs v;
        LuaValue[] stack = EMPTY;
        CallFrame previous;

        void set(LuaClosure function, Varargs varargs2, LuaValue[] stack) {
            this.f = function;
            this.v = varargs2;
            this.stack = stack;
        }

        public String shortsource() {
            return this.f.isclosure() ? this.f.checkclosure().p.shortsource() : "[Java]";
        }

        void set(LuaFunction function) {
            this.f = function;
        }

        void reset() {
            this.f = null;
            this.v = null;
            this.stack = EMPTY;
        }

        void instr(int pc, Varargs v, int top) {
            this.pc = pc;
            this.v = v;
            this.top = top;
            if (TRACE) {
                Print.printState(this.f.checkclosure(), pc, this.stack, top, v);
            }
        }

        Varargs getLocal(int i2) {
            LuaString name = this.getlocalname(i2);
            if (i2 >= 1 && i2 <= this.stack.length && this.stack[i2 - 1] != null) {
                return LuaValue.varargsOf(name == null ? LuaValue.NIL : name, (Varargs)this.stack[i2 - 1]);
            }
            return LuaValue.NIL;
        }

        Varargs setLocal(int i2, LuaValue value) {
            LuaString name = this.getlocalname(i2);
            if (i2 >= 1 && i2 <= this.stack.length && this.stack[i2 - 1] != null) {
                this.stack[i2 - 1] = value;
                return name == null ? LuaValue.NIL : name;
            }
            return LuaValue.NIL;
        }

        public int currentline() {
            if (!this.f.isclosure()) {
                return -1;
            }
            int[] li = this.f.checkclosure().p.lineinfo;
            return li == null || this.pc < 0 || this.pc >= li.length ? -1 : li[this.pc];
        }

        String sourceline() {
            if (!this.f.isclosure()) {
                return this.f.tojstring();
            }
            return this.f.checkclosure().p.shortsource() + ":" + this.currentline();
        }

        int linedefined() {
            return this.f.isclosure() ? this.f.checkclosure().p.linedefined : -1;
        }

        LuaString getlocalname(int index) {
            if (!this.f.isclosure()) {
                return null;
            }
            return this.f.checkclosure().p.getlocalname(index, this.pc);
        }
    }

    static class NameWhat {
        final String name;
        final String namewhat;

        NameWhat(String name, String namewhat) {
            this.name = name;
            this.namewhat = namewhat;
        }
    }

    static class DebugInfo {
        String name;
        String namewhat;
        String what;
        String source;
        int currentline;
        int linedefined;
        int lastlinedefined;
        short nups;
        short nparams;
        boolean isvararg;
        boolean istailcall;
        String short_src;
        CallFrame cf;

        DebugInfo() {
        }

        public void funcinfo(LuaFunction f2) {
            if (f2.isclosure()) {
                Prototype p = f2.checkclosure().p;
                this.source = p.source != null ? p.source.tojstring() : "=?";
                this.linedefined = p.linedefined;
                this.lastlinedefined = p.lastlinedefined;
                this.what = this.linedefined == 0 ? "main" : "Lua";
                this.short_src = p.shortsource();
            } else {
                this.source = "=[Java]";
                this.linedefined = -1;
                this.lastlinedefined = -1;
                this.what = "Java";
                this.short_src = f2.name();
            }
        }
    }
}

