/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib.jse;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import li.cil.repack.org.luaj.vm2.LuaError;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Varargs;
import li.cil.repack.org.luaj.vm2.lib.VarArgFunction;
import li.cil.repack.org.luaj.vm2.lib.jse.CoerceJavaToLua;
import li.cil.repack.org.luaj.vm2.lib.jse.CoerceLuaToJava;
import li.cil.repack.org.luaj.vm2.lib.jse.JavaMember;

class JavaConstructor
extends JavaMember {
    static final Map constructors = Collections.synchronizedMap(new HashMap());
    final Constructor constructor;

    static JavaConstructor forConstructor(Constructor c2) {
        JavaConstructor j2 = (JavaConstructor)constructors.get(c2);
        if (j2 == null) {
            j2 = new JavaConstructor(c2);
            constructors.put(c2, j2);
        }
        return j2;
    }

    public static LuaValue forConstructors(JavaConstructor[] array) {
        return new Overload(array);
    }

    private JavaConstructor(Constructor c2) {
        super(c2.getParameterTypes(), c2.getModifiers());
        this.constructor = c2;
    }

    @Override
    public Varargs invoke(Varargs args) {
        Object[] a2 = this.convertArgs(args);
        try {
            return CoerceJavaToLua.coerce(this.constructor.newInstance(a2));
        }
        catch (InvocationTargetException e2) {
            throw new LuaError(e2.getTargetException());
        }
        catch (Exception e3) {
            return LuaValue.error("coercion error " + e3);
        }
    }

    static class Overload
    extends VarArgFunction {
        final JavaConstructor[] constructors;

        public Overload(JavaConstructor[] c2) {
            this.constructors = c2;
        }

        @Override
        public Varargs invoke(Varargs args) {
            JavaConstructor best = null;
            int score = CoerceLuaToJava.SCORE_UNCOERCIBLE;
            for (JavaConstructor constructor : this.constructors) {
                int s = constructor.score(args);
                if (s >= score) continue;
                score = s;
                best = constructor;
                if (score == 0) break;
            }
            if (best == null) {
                LuaValue.error("no coercible public method");
            }
            return best.invoke(args);
        }
    }
}

