/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib.jse;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import li.cil.repack.org.luaj.vm2.LuaError;
import li.cil.repack.org.luaj.vm2.LuaFunction;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.Varargs;
import li.cil.repack.org.luaj.vm2.lib.jse.CoerceJavaToLua;
import li.cil.repack.org.luaj.vm2.lib.jse.CoerceLuaToJava;
import li.cil.repack.org.luaj.vm2.lib.jse.JavaMember;

class JavaMethod
extends JavaMember {
    static final Map methods = Collections.synchronizedMap(new HashMap());
    final Method method;

    static JavaMethod forMethod(Method m2) {
        JavaMethod j2 = (JavaMethod)methods.get(m2);
        if (j2 == null) {
            j2 = new JavaMethod(m2);
            methods.put(m2, j2);
        }
        return j2;
    }

    static LuaFunction forMethods(JavaMethod[] m2) {
        return new Overload(m2);
    }

    private JavaMethod(Method m2) {
        super(m2.getParameterTypes(), m2.getModifiers());
        this.method = m2;
        try {
            if (!m2.isAccessible()) {
                m2.setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public LuaValue call() {
        return JavaMethod.error("method cannot be called without instance");
    }

    @Override
    public LuaValue call(LuaValue arg) {
        return this.invokeMethod(arg.checkuserdata(), LuaValue.NONE);
    }

    @Override
    public LuaValue call(LuaValue arg1, LuaValue arg2) {
        return this.invokeMethod(arg1.checkuserdata(), arg2);
    }

    @Override
    public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
        return this.invokeMethod(arg1.checkuserdata(), LuaValue.varargsOf(arg2, (Varargs)arg3));
    }

    @Override
    public Varargs invoke(Varargs args) {
        return this.invokeMethod(args.checkuserdata(1), args.subargs(2));
    }

    LuaValue invokeMethod(Object instance, Varargs args) {
        Object[] a2 = this.convertArgs(args);
        try {
            return CoerceJavaToLua.coerce(this.method.invoke(instance, a2));
        }
        catch (InvocationTargetException e2) {
            throw new LuaError(e2.getTargetException());
        }
        catch (Exception e3) {
            return LuaValue.error("coercion error " + e3);
        }
    }

    static class Overload
    extends LuaFunction {
        final JavaMethod[] methods;

        Overload(JavaMethod[] methods) {
            this.methods = methods;
        }

        @Override
        public LuaValue call() {
            return Overload.error("method cannot be called without instance");
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return this.invokeBestMethod(arg.checkuserdata(), LuaValue.NONE);
        }

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            return this.invokeBestMethod(arg1.checkuserdata(), arg2);
        }

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
            return this.invokeBestMethod(arg1.checkuserdata(), LuaValue.varargsOf(arg2, (Varargs)arg3));
        }

        @Override
        public Varargs invoke(Varargs args) {
            return this.invokeBestMethod(args.checkuserdata(1), args.subargs(2));
        }

        private LuaValue invokeBestMethod(Object instance, Varargs args) {
            JavaMethod best = null;
            int score = CoerceLuaToJava.SCORE_UNCOERCIBLE;
            for (JavaMethod method : this.methods) {
                int s = method.score(args);
                if (s >= score) continue;
                score = s;
                best = method;
                if (score == 0) break;
            }
            if (best == null) {
                LuaValue.error("no coercible public method");
            }
            return best.invokeMethod(instance, args);
        }
    }
}

