/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib.jse;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import li.cil.repack.org.luaj.vm2.LuaError;
import li.cil.repack.org.luaj.vm2.LuaString;
import li.cil.repack.org.luaj.vm2.lib.IoLib;

public class JseIoLib
extends IoLib {
    @Override
    protected IoLib.File wrapStdin() throws IOException {
        return new StdinFile();
    }

    @Override
    protected IoLib.File wrapStdout() throws IOException {
        return new StdoutFile(1);
    }

    @Override
    protected IoLib.File wrapStderr() throws IOException {
        return new StdoutFile(2);
    }

    @Override
    protected IoLib.File openFile(String filename, boolean readMode, boolean appendMode, boolean updateMode, boolean binaryMode) throws IOException {
        RandomAccessFile f2 = new RandomAccessFile(filename, readMode ? "r" : "rw");
        if (appendMode) {
            f2.seek(f2.length());
        } else if (!readMode) {
            f2.setLength(0L);
        }
        return new FileImpl(f2);
    }

    @Override
    protected IoLib.File openProgram(String prog, String mode) throws IOException {
        Process p = Runtime.getRuntime().exec(prog);
        return "w".equals(mode) ? new FileImpl(p.getOutputStream()) : new FileImpl(p.getInputStream());
    }

    @Override
    protected IoLib.File tmpFile() throws IOException {
        File f2 = File.createTempFile(".luaj", "bin");
        f2.deleteOnExit();
        return new FileImpl(new RandomAccessFile(f2, "rw"));
    }

    private static void notimplemented() {
        throw new LuaError("not implemented");
    }

    private final class StdinFile
    extends IoLib.File {
        private StdinFile() {
        }

        @Override
        public String tojstring() {
            return "file (" + this.hashCode() + ")";
        }

        @Override
        public void write(LuaString string) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public boolean isstdfile() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean isclosed() {
            return false;
        }

        @Override
        public int seek(String option, int bytecount) throws IOException {
            return 0;
        }

        @Override
        public void setvbuf(String mode, int size) {
        }

        @Override
        public int remaining() throws IOException {
            return -1;
        }

        @Override
        public int peek() throws IOException, EOFException {
            ((JseIoLib)JseIoLib.this).globals.STDIN.mark(1);
            int c2 = ((JseIoLib)JseIoLib.this).globals.STDIN.read();
            ((JseIoLib)JseIoLib.this).globals.STDIN.reset();
            return c2;
        }

        @Override
        public int read() throws IOException, EOFException {
            return ((JseIoLib)JseIoLib.this).globals.STDIN.read();
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            return ((JseIoLib)JseIoLib.this).globals.STDIN.read(bytes, offset, length);
        }
    }

    private final class StdoutFile
    extends IoLib.File {
        private final int file_type;

        private StdoutFile(int file_type) {
            this.file_type = file_type;
        }

        @Override
        public String tojstring() {
            return "file (" + this.hashCode() + ")";
        }

        private PrintStream getPrintStream() {
            return this.file_type == 2 ? ((JseIoLib)JseIoLib.this).globals.STDERR : ((JseIoLib)JseIoLib.this).globals.STDOUT;
        }

        @Override
        public void write(LuaString string) throws IOException {
            this.getPrintStream().write(string.m_bytes, string.m_offset, string.m_length);
        }

        @Override
        public void flush() throws IOException {
            this.getPrintStream().flush();
        }

        @Override
        public boolean isstdfile() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean isclosed() {
            return false;
        }

        @Override
        public int seek(String option, int bytecount) throws IOException {
            return 0;
        }

        @Override
        public void setvbuf(String mode, int size) {
        }

        @Override
        public int remaining() throws IOException {
            return 0;
        }

        @Override
        public int peek() throws IOException, EOFException {
            return 0;
        }

        @Override
        public int read() throws IOException, EOFException {
            return 0;
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            return 0;
        }
    }

    private final class FileImpl
    extends IoLib.File {
        private final RandomAccessFile file;
        private final InputStream is;
        private final OutputStream os;
        private boolean closed = false;
        private boolean nobuffer = false;

        private FileImpl(RandomAccessFile file, InputStream is, OutputStream os) {
            this.file = file;
            this.is = is != null ? (is.markSupported() ? is : new BufferedInputStream(is)) : null;
            this.os = os;
        }

        private FileImpl(RandomAccessFile f2) {
            this(f2, null, null);
        }

        private FileImpl(InputStream i2) {
            this(null, i2, null);
        }

        private FileImpl(OutputStream o2) {
            this(null, null, o2);
        }

        @Override
        public String tojstring() {
            return "file (" + (this.closed ? "closed" : String.valueOf(this.hashCode())) + ")";
        }

        @Override
        public boolean isstdfile() {
            return this.file == null;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.file != null) {
                this.file.close();
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.os != null) {
                this.os.flush();
            }
        }

        @Override
        public void write(LuaString s) throws IOException {
            if (this.os != null) {
                this.os.write(s.m_bytes, s.m_offset, s.m_length);
            } else if (this.file != null) {
                this.file.write(s.m_bytes, s.m_offset, s.m_length);
            } else {
                JseIoLib.notimplemented();
            }
            if (this.nobuffer) {
                this.flush();
            }
        }

        @Override
        public boolean isclosed() {
            return this.closed;
        }

        @Override
        public int seek(String option, int pos) throws IOException {
            if (this.file != null) {
                if ("set".equals(option)) {
                    this.file.seek(pos);
                } else if ("end".equals(option)) {
                    this.file.seek(this.file.length() + (long)pos);
                } else {
                    this.file.seek(this.file.getFilePointer() + (long)pos);
                }
                return (int)this.file.getFilePointer();
            }
            JseIoLib.notimplemented();
            return 0;
        }

        @Override
        public void setvbuf(String mode, int size) {
            this.nobuffer = "no".equals(mode);
        }

        @Override
        public int remaining() throws IOException {
            return this.file != null ? (int)(this.file.length() - this.file.getFilePointer()) : -1;
        }

        @Override
        public int peek() throws IOException {
            if (this.is != null) {
                this.is.mark(1);
                int c2 = this.is.read();
                this.is.reset();
                return c2;
            }
            if (this.file != null) {
                long fp = this.file.getFilePointer();
                int c3 = this.file.read();
                this.file.seek(fp);
                return c3;
            }
            JseIoLib.notimplemented();
            return 0;
        }

        @Override
        public int read() throws IOException {
            if (this.is != null) {
                return this.is.read();
            }
            if (this.file != null) {
                return this.file.read();
            }
            JseIoLib.notimplemented();
            return 0;
        }

        @Override
        public int read(byte[] bytes, int offset, int length) throws IOException {
            if (this.file != null) {
                return this.file.read(bytes, offset, length);
            }
            if (this.is != null) {
                return this.is.read(bytes, offset, length);
            }
            JseIoLib.notimplemented();
            return length;
        }
    }
}

