/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2.lib.jse;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import li.cil.repack.org.luaj.vm2.Varargs;
import li.cil.repack.org.luaj.vm2.lib.OsLib;
import li.cil.repack.org.luaj.vm2.lib.jse.JseProcess;

public class JseOsLib
extends OsLib {
    public static final int EXEC_IOEXCEPTION = 1;
    public static final int EXEC_INTERRUPTED = -2;
    public static final int EXEC_ERROR = -3;

    @Override
    protected String getenv(String varname) {
        String s = System.getenv(varname);
        return s != null ? s : System.getProperty(varname);
    }

    @Override
    protected Varargs execute(String command) {
        int exitValue;
        try {
            exitValue = new JseProcess(command, null, (OutputStream)this.globals.STDOUT, (OutputStream)this.globals.STDERR).waitFor();
        }
        catch (IOException ioe) {
            exitValue = 1;
        }
        catch (InterruptedException e2) {
            exitValue = -2;
        }
        catch (Throwable t) {
            exitValue = -3;
        }
        if (exitValue == 0) {
            return JseOsLib.varargsOf(TRUE, JseOsLib.valueOf("exit"), ZERO);
        }
        return JseOsLib.varargsOf(NIL, JseOsLib.valueOf("signal"), JseOsLib.valueOf(exitValue));
    }

    @Override
    protected void remove(String filename) throws IOException {
        File f2 = new File(filename);
        if (!f2.exists()) {
            throw new IOException("No such file or directory");
        }
        if (!f2.delete()) {
            throw new IOException("Failed to delete");
        }
    }

    @Override
    protected void rename(String oldname, String newname) throws IOException {
        File f2 = new File(oldname);
        if (!f2.exists()) {
            throw new IOException("No such file or directory");
        }
        if (!f2.renameTo(new File(newname))) {
            throw new IOException("Failed to rename");
        }
    }

    @Override
    protected String tmpname() {
        try {
            File f2 = File.createTempFile(".luaj", "tmp");
            return f2.getAbsolutePath();
        }
        catch (IOException ioe) {
            return super.tmpname();
        }
    }
}

