/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop;

import buildinfo.BuildInfo$;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import ocelot.desktop.ColorScheme$;
import ocelot.desktop.Settings$;
import ocelot.desktop.geometry.Size2D;
import ocelot.desktop.inventory.Items$;
import ocelot.desktop.ui.UiHandler$;
import ocelot.desktop.ui.swing.SplashScreen;
import ocelot.desktop.ui.widget.CloseConfirmationDialog;
import ocelot.desktop.ui.widget.InputDialog;
import ocelot.desktop.ui.widget.InputDialog$;
import ocelot.desktop.ui.widget.RootWidget;
import ocelot.desktop.ui.widget.Widget;
import ocelot.desktop.ui.widget.modal.notification.NotificationDialog;
import ocelot.desktop.ui.widget.modal.notification.NotificationType$;
import ocelot.desktop.util.CommandLine;
import ocelot.desktop.util.CommandLine$;
import ocelot.desktop.util.FPSCalculator;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.LoggingConfiguration;
import ocelot.desktop.util.Messages$;
import ocelot.desktop.util.OcelotPaths$;
import ocelot.desktop.util.Profiler$;
import ocelot.desktop.util.ResourceManager$;
import ocelot.desktop.util.TaskQueue;
import ocelot.desktop.util.Ticker;
import ocelot.desktop.util.Transaction;
import ocelot.desktop.util.Transaction$;
import ocelot.desktop.util.WebcamCapture$;
import ocelot.desktop.util.package$;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.Display;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Queue;
import scala.concurrent.duration.Duration;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcV$sp;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import totoro.ocelot.brain.Ocelot$;
import totoro.ocelot.brain.nbt.CompressedStreamTools;
import totoro.ocelot.brain.nbt.ExtendedNBT$;
import totoro.ocelot.brain.nbt.NBTTagCompound;
import totoro.ocelot.brain.nbt.NBTTagString;
import totoro.ocelot.brain.user.User;
import totoro.ocelot.brain.workspace.Workspace;

public final class OcelotDesktop$
implements LoggingConfiguration,
Logging {
    public static final OcelotDesktop$ MODULE$ = new OcelotDesktop$();
    private static final SplashScreen splashScreen;
    private static RootWidget root;
    private static final ArrayBuffer<User> players;
    private static final FPSCalculator tpsCounter;
    private static final Ticker ticker;
    private static boolean _emulationPaused;
    private static final int TickerIntervalHistorySize;
    private static final Queue<Duration> tickerIntervalHistory;
    private static final Lock tickLock;
    private static long lastAutosave;
    private static Option<Path> _savePath;
    private static final Path tmpPath;
    private static Workspace workspace;
    private static final TaskQueue updateThreadTasks;
    private static Logger logger;

    static {
        LoggingConfiguration.$init$(MODULE$);
        Logging.$init$(MODULE$);
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        System.setProperty("LWJGL_WM_CLASS", "Ocelot Desktop");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            MODULE$.logger().error("Unable to perform setLookAndFeel()", (Throwable)ex);
        }
        splashScreen = new SplashScreen();
        players = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new User[]{new User("myself")}));
        tpsCounter = new FPSCalculator();
        ticker = new Ticker();
        _emulationPaused = false;
        TickerIntervalHistorySize = 5;
        tickerIntervalHistory = new Queue(MODULE$.TickerIntervalHistorySize());
        tickLock = new ReentrantLock();
        lastAutosave = -1L;
        _savePath = None$.MODULE$;
        tmpPath = Files.createTempDirectory("ocelot-save", new FileAttribute[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!Settings$.MODULE$.get().autosave() || MODULE$.savePath().isEmpty()) {
                FileUtils.deleteDirectory(MODULE$.tmpPath().toFile());
                return;
            }
        }));
        updateThreadTasks = new TaskQueue();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private SplashScreen splashScreen() {
        return splashScreen;
    }

    public RootWidget root() {
        return root;
    }

    public void root_$eq(RootWidget x$1) {
        root = x$1;
    }

    public ArrayBuffer<User> players() {
        return players;
    }

    public FPSCalculator tpsCounter() {
        return tpsCounter;
    }

    public Ticker ticker() {
        return ticker;
    }

    private boolean _emulationPaused() {
        return _emulationPaused;
    }

    private void _emulationPaused_$eq(boolean x$1) {
        _emulationPaused = x$1;
    }

    public boolean emulationPaused() {
        return this._emulationPaused();
    }

    public void emulationPaused_$eq(boolean paused) {
        this._emulationPaused_$eq(paused);
        if (!paused) {
            this.tpsCounter().skipSecond();
            return;
        }
    }

    private int TickerIntervalHistorySize() {
        return TickerIntervalHistorySize;
    }

    public Queue<Duration> tickerIntervalHistory() {
        return tickerIntervalHistory;
    }

    public void pushToTickerIntervalHistory(Duration interval) {
        Serializable serializable = this.tickerIntervalHistory().size() >= this.TickerIntervalHistorySize() ? this.tickerIntervalHistory().dequeue() : BoxedUnit.UNIT;
        this.tickerIntervalHistory().enqueue(interval);
    }

    private Lock tickLock() {
        return tickLock;
    }

    public void withTickLockAcquired(Function0<BoxedUnit> f2) {
        package$.MODULE$.withLockAcquired(this.tickLock(), f2);
    }

    private void mainInner(HashMap<CommandLine.Argument, Option<String>> args) {
        Path path;
        this.logger().info("Starting up Ocelot Desktop");
        this.logger().info(new StringBuilder(12).append("Version: ").append(BuildInfo$.MODULE$.version()).append(" (").append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(BuildInfo$.MODULE$.commit()), 7)).append(")").toString());
        this.splashScreen().setStatus("Loading configuration...", 0.1f);
        Option customConfigPath = args.get(CommandLine$.MODULE$.ConfigPath()).flatten($less$colon$less$.MODULE$.refl());
        if (customConfigPath.isDefined()) {
            path = Paths.get((String)customConfigPath.get(), new String[0]);
        } else {
            Object object;
            Path newConfigPath = OcelotPaths$.MODULE$.desktopConfig();
            try {
                if (!Files.exists(newConfigPath, new LinkOption[0])) {
                    Path oldConfigPath;
                    Path path2 = oldConfigPath = SystemUtils.IS_OS_WINDOWS ? Paths.get(OcelotPaths$.MODULE$.windowsAppDataDirectoryName(), "Ocelot", "ocelot.conf") : Paths.get(OcelotPaths$.MODULE$.linuxHomeDirectoryName(), ".config", "ocelot", "ocelot.conf");
                    object = Files.exists(oldConfigPath, new LinkOption[0]) ? Files.move(oldConfigPath, newConfigPath, new CopyOption[0]) : BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
            }
            catch (Throwable throwable) {
                object = BoxedUnit.UNIT;
            }
            path = newConfigPath;
        }
        Path desktopConfigPath = path;
        Settings$.MODULE$.load(desktopConfigPath);
        Messages$.MODULE$.load(Source$.MODULE$.fromURL(this.getClass().getResource("/ocelot/desktop/messages.txt"), Codec$.MODULE$.fallbackSystemCodec()));
        ColorScheme$.MODULE$.load(Source$.MODULE$.fromURL(this.getClass().getResource("/ocelot/desktop/colorscheme.txt"), Codec$.MODULE$.fallbackSystemCodec()));
        this.splashScreen().setStatus("Initializing brain...", 0.2f);
        Ocelot$.MODULE$.configPath_$eq(Settings$.MODULE$.get().brainCustomConfigPath().map((Function1<String, Path> & Serializable)x$2 -> Paths.get(x$2, new String[0])));
        Ocelot$.MODULE$.librariesPath_$eq(new Some<Path>(OcelotPaths$.MODULE$.libraries()));
        Ocelot$.MODULE$.isPlayerOnlinePredicate_$eq(new Some<Function1<String, Object> & Serializable>((Function1<String, Object> & Serializable)player -> BoxesRunTime.boxToBoolean(OcelotDesktop$.$anonfun$mainInner$2(player))));
        Ocelot$.MODULE$.initialize(this.logger());
        Items$.MODULE$.init();
        this.splashScreen().setStatus("Initializing GUI...", 0.3f);
        this.createWorkspace();
        UiHandler$.MODULE$.loadLibraries();
        this.splashScreen().setStatus("Loading resources...", 0.6f);
        UiHandler$.MODULE$.init();
        boolean loadRecentWorkspace = Settings$.MODULE$.get().recentWorkspace().isDefined() && Settings$.MODULE$.get().openLastWorkspace();
        this.root_$eq(new RootWidget(!loadRecentWorkspace));
        this.root().size_$eq(new Size2D((float)Display.getWidth() / Settings$.MODULE$.get().scaleFactor(), (float)Display.getHeight() / Settings$.MODULE$.get().scaleFactor()));
        UiHandler$.MODULE$.setRoot(this.root());
        this.splashScreen().setStatus("Loading workspace...", 0.9f);
        Option cmdLineWorkspaceArgument = args.get(CommandLine$.MODULE$.WorkspacePath()).flatten($less$colon$less$.MODULE$.refl());
        if (loadRecentWorkspace || cmdLineWorkspaceArgument.isDefined()) {
            Try result2 = cmdLineWorkspaceArgument.orElse((Function0<Option> & Serializable)() -> Settings$.MODULE$.get().recentWorkspace()).map((Function1<String, File> & Serializable)x$4 -> new File((String)x$4)).toRight((Function0<IllegalArgumentException> & Serializable)() -> new IllegalArgumentException("Received None as a directory path")).toTry($less$colon$less$.MODULE$.refl()).map((Function1<File, Try> & Serializable)dir -> MODULE$.load((File)dir));
            Try try_ = result2;
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                String errorMessage = cmdLineWorkspaceArgument.isDefined() ? "Could not open the specified workspace..." : "Could not open the recent workspace...";
                this.logger().error(errorMessage, exception);
                NotificationDialog qual$1 = new NotificationDialog(new StringBuilder(31).append(errorMessage).append("\n(").append(exception).append(")\nI will create a default one").toString(), NotificationType$.MODULE$.Info());
                String x$1 = qual$1.addCloseButton$default$1();
                qual$1.addCloseButton(x$1).show();
                this.root().workspaceView().createDefaultWorkspace();
                Settings$.MODULE$.get().recentWorkspace_$eq(None$.MODULE$);
            } else if (try_ instanceof Success) {
            } else {
                throw new MatchError(try_);
            }
        }
        Thread updateThread = new Thread(() -> {
            try {
                Thread currentThread = Thread.currentThread();
                while (!currentThread.isInterrupted()) {
                    if (!MODULE$.emulationPaused()) {
                        Profiler$.MODULE$.measure("tick", () -> MODULE$.withTickLockAcquired(() -> {
                            MODULE$.workspace().update();
                            MODULE$.updateThreadTasks().run();
                            MODULE$.tpsCounter().tick();
                        }));
                    }
                    MODULE$.ticker().waitNext(!MODULE$.emulationPaused());
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }, "update-thread");
        updateThread.start();
        this.splashScreen().dispose();
        this.logger().info("Ocelot Desktop is up and ready!");
        UiHandler$.MODULE$.start();
        this.logger().info("Cleaning up");
        updateThread.interrupt();
        try {
            updateThread.join();
        }
        catch (InterruptedException interruptedException) {}
        WebcamCapture$.MODULE$.cleanup();
        Settings$.MODULE$.save(desktopConfigPath);
        UiHandler$.MODULE$.terminate();
        ResourceManager$.MODULE$.checkEmpty();
        Ocelot$.MODULE$.shutdown();
        this.logger().info("Thanks for using Ocelot Desktop");
        System.exit(0);
    }

    public void main(String[] rawArgs) {
        HashMap<CommandLine.Argument, Option<String>> args = CommandLine$.MODULE$.parse(rawArgs);
        if (args.contains(CommandLine$.MODULE$.Help())) {
            Predef$.MODULE$.println(CommandLine$.MODULE$.doc());
            return;
        }
        try {
            this.mainInner(args);
        }
        catch (Exception e2) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e2.printStackTrace(pw);
            this.logger().error(String.valueOf(sw.toString()));
            System.exit(1);
        }
    }

    private void saveWorld(NBTTagCompound nbt) {
        this.withTickLockAcquired(() -> {
            NBTTagCompound backendNBT = new NBTTagCompound();
            NBTTagCompound frontendNBT = new NBTTagCompound();
            MODULE$.workspace().save(backendNBT);
            MODULE$.root().workspaceView().save(frontendNBT);
            ExtendedNBT$.MODULE$.extendNBTTagCompound(frontendNBT).setNewTagList("players", (IterableOnce)MODULE$.players().map((Function1<User, NBTTagString> & Serializable)player -> new NBTTagString(player.nickname())));
            nbt.setTag("back", backendNBT);
            nbt.setTag("front", frontendNBT);
        });
    }

    private void loadWorld(NBTTagCompound nbt) {
        this.withTickLockAcquired(() -> {
            NBTTagCompound backendNBT = nbt.getCompoundTag("back");
            NBTTagCompound frontendNBT = nbt.getCompoundTag("front");
            MODULE$.workspace().load(backendNBT);
            MODULE$.root().workspaceView().load(frontendNBT);
            if (frontendNBT.hasKey("players")) {
                MODULE$.players().clear();
                MODULE$.players().addAll((IterableOnce)ExtendedNBT$.MODULE$.extendNBTTagList(frontendNBT.getTagList("players", 8)).map((Function1<NBTTagString, User> & Serializable)player -> new User(player.getString())));
                return;
            }
        });
    }

    private long lastAutosave() {
        return lastAutosave;
    }

    private void lastAutosave_$eq(long x$1) {
        lastAutosave = x$1;
    }

    public void resetAutosave() {
        if (Settings$.MODULE$.get().autosave()) {
            this.lastAutosave_$eq(System.currentTimeMillis());
            this.logger().debug("Autosave interval was reset.");
            return;
        }
    }

    public void updateAutosave() {
        if (Settings$.MODULE$.get().autosave()) {
            if (this.lastAutosave() == -1L || System.currentTimeMillis() - this.lastAutosave() > (long)(Settings$.MODULE$.get().autosavePeriod() * 1000)) {
                Path path = (Path)this.savePath().getOrElse((Function0<Path> & Serializable)() -> MODULE$.tmpPath());
                this.logger().debug(new StringBuilder(15).append("Autosave to ").append(path).append("...").toString());
                this.saveTo(path);
                this.lastAutosave_$eq(System.currentTimeMillis());
                return;
            }
            return;
        }
    }

    private Option<Path> _savePath() {
        return _savePath;
    }

    private void _savePath_$eq(Option<Path> x$1) {
        _savePath = x$1;
    }

    private Option<Path> savePath() {
        return this._savePath();
    }

    private void savePath_$eq(Option<Path> path) {
        this._savePath_$eq(path);
        UiHandler$.MODULE$.windowTitleSuffix_$eq(path.map((Function1<Path, String> & Serializable)x$5 -> ((Object)x$5).toString()));
    }

    private Path tmpPath() {
        return tmpPath;
    }

    public void newWorkspace() {
        this.showCloseConfirmationDialog("Save workspace before opening a new one?", () -> {
            MODULE$.root().workspaceView().newWorkspace();
            MODULE$.savePath_$eq(None$.MODULE$);
            Settings$.MODULE$.get().recentWorkspace_$eq(None$.MODULE$);
            MODULE$.resetAutosave();
        });
    }

    private void saveTo(Path outputPath) {
        Object object;
        Path oldPath;
        Path path2 = oldPath = this.workspace().path();
        Path path3 = outputPath;
        if (path2 == null ? path3 != null : !((Object)path2).equals(path3)) {
            Tuple2 tuple2 = (Tuple2)Using$.MODULE$.resources(Files.list(oldPath), (Function0<Stream> & Serializable)() -> Files.list(outputPath), (Function2<Stream, Stream, Tuple2> & Serializable)(oldDirStream, newDirStream) -> {
                Path[] oldFiles = (Path[])CollectionConverters$.MODULE$.IteratorHasAsScala(oldDirStream.iterator()).asScala().toArray(ClassTag$.MODULE$.apply(Path.class));
                Path[] newFiles = (Path[])CollectionConverters$.MODULE$.IteratorHasAsScala(newDirStream.iterator()).asScala().toArray(ClassTag$.MODULE$.apply(Path.class));
                return new Tuple2<Path[], Path[]>(oldFiles, newFiles);
            }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Path[] oldFiles = (Path[])tuple2._1();
            Path[] newFiles = (Path[])tuple2._2();
            Tuple2<Path[], Path[]> tuple22 = new Tuple2<Path[], Path[]>(oldFiles, newFiles);
            Path[] oldFiles2 = tuple22._1();
            Path[] newFiles2 = tuple22._2();
            Path[] toRemove = (Path[])ArrayOps$.MODULE$.intersect$extension(Predef$.MODULE$.refArrayOps(newFiles2), Predef$.MODULE$.wrapRefArray((Object[])oldFiles2));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(toRemove), (Function1<Path, Object> & Serializable)path -> {
                OcelotDesktop$.$anonfun$saveTo$3(path);
                return BoxedUnit.UNIT;
            });
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(oldFiles2), (Function1<Path, Object> & Serializable)path -> {
                OcelotDesktop$.$anonfun$saveTo$4(oldPath, outputPath, path);
                return BoxedUnit.UNIT;
            });
            this.workspace().path_$eq(outputPath);
        }
        Path path4 = outputPath.resolve("workspace.nbt");
        try {
            object = Files.move(path4, path4.resolveSibling("workspace.nbt.bak"), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileNotFoundException ? true : throwable2 instanceof NoSuchFileException) {
                object = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        Using$.MODULE$.resource(new DataOutputStream(new FileOutputStream(path4.toFile())), (Function1<DataOutputStream, Object> & Serializable)writer -> {
            OcelotDesktop$.$anonfun$saveTo$5(writer);
            return BoxedUnit.UNIT;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
        this.logger().info(new StringBuilder(20).append("Saved workspace to: ").append(outputPath).toString());
    }

    public void save(Function0<BoxedUnit> continuation) {
        Option<Path> option = this.savePath();
        if (option instanceof Some) {
            Some some = (Some)option;
            Path savePath = (Path)some.value();
            Try<Object> try_ = Try$.MODULE$.apply(() -> {
                MODULE$.saveTo(savePath);
                continuation.apply$mcV$sp();
            });
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                this.savePath_$eq(None$.MODULE$);
                this.showFailureMessage(failure);
            } else if (try_ instanceof Success) {
            } else {
                throw new MatchError(try_);
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.showSaveDialog(continuation);
            return;
        }
        throw new MatchError(option);
    }

    public void saveAs() {
        this.showSaveDialog(() -> {});
    }

    public void showOpenDialog() {
        this.showFileChooserDialog(0, 1, (Function1<Option<File>, Try<BoxedUnit>>)(Function1<Option, Try> & Serializable)x0$1 -> {
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                File dir = (File)some.value();
                return MODULE$.load(dir);
            }
            if (None$.MODULE$.equals(option)) {
                return new Success<BoxedUnit>(BoxedUnit.UNIT);
            }
            throw new MatchError(option);
        });
    }

    public Try<BoxedUnit> load(File dir) {
        Path path = Paths.get(dir.getCanonicalPath(), "workspace.nbt");
        if (Files.exists(path, new LinkOption[0])) {
            return Using$.MODULE$.apply((Function0<DataInputStream> & Serializable)() -> new DataInputStream(Files.newInputStream(path, new OpenOption[0])), (Function1<DataInputStream, Object> & Serializable)reader -> {
                OcelotDesktop$.$anonfun$load$2(dir, path, reader);
                return BoxedUnit.UNIT;
            }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
        }
        return new Failure<BoxedUnit>(new FileNotFoundException("Specified directory does not contain 'workspace.nbt'"));
    }

    public void showFileChooserDialog(int dialogType, int selectionMode, Function1<Option<File>, Try<BoxedUnit>> f2) {
        new Thread(() -> {
            File lastFile = (File)MODULE$.savePath().map((Function1<Path, File> & Serializable)x$7 -> x$7.toFile()).orNull($less$colon$less$.MODULE$.refl());
            JFileChooser chooser = new JFileChooser(lastFile){

                public JDialog createDialog(Component parent) {
                    JDialog dialog = super.createDialog(parent);
                    dialog.setModal(true);
                    dialog.setAlwaysOnTop(true);
                    return dialog;
                }
            };
            chooser.setFileSelectionMode(selectionMode);
            chooser.setDialogType(dialogType);
            Option selectedFile = Option$.MODULE$.when(chooser.showDialog(null, null) == 0, (Function0<File> & Serializable)() -> chooser.getSelectedFile());
            UiHandler$.MODULE$.UiThreadTasks().add(() -> {
                Try result2 = (Try)f2.apply(selectedFile);
                Try try_ = result2;
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    MODULE$.showFailureMessage(failure);
                    return;
                }
                if (try_ instanceof Success) {
                    return;
                }
                throw new MatchError(try_);
            });
        }).start();
    }

    private void showFailureMessage(Failure<BoxedUnit> failure) {
        Failure<BoxedUnit> failure2 = failure;
        if (failure2 == null) {
            throw new MatchError(failure2);
        }
        Throwable exception = failure2.exception();
        Throwable exception2 = exception;
        this.logger().error("File operation failed", exception2);
        NotificationDialog qual$1 = new NotificationDialog(new StringBuilder(66).append("Something went wrong!\n(").append(exception2).append(")\nCheck the log file for a full stacktrace.").toString(), NotificationType$.MODULE$.Error());
        String x$1 = qual$1.addCloseButton$default$1();
        qual$1.addCloseButton(x$1).show();
    }

    public void showAddPlayerDialog() {
        new InputDialog("Add new player", (Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable)text -> {
            OcelotDesktop$.MODULE$.selectPlayer(text);
            return BoxedUnit.UNIT;
        }, InputDialog$.MODULE$.$lessinit$greater$default$3(), InputDialog$.MODULE$.$lessinit$greater$default$4()).show();
    }

    public User player() {
        if (this.players().nonEmpty()) {
            return this.players().head();
        }
        return new User("myself");
    }

    public void selectPlayer(String name) {
        int n2 = this.players().indexWhere((Function1<User, Object> & Serializable)x$8 -> BoxesRunTime.boxToBoolean(OcelotDesktop$.$anonfun$selectPlayer$1(name, x$8)));
        switch (n2) {
            case -1: {
                this.players().prepend((Object)new User(name));
                return;
            }
        }
        User player = this.players().apply(n2);
        this.players().remove(n2);
        this.players().prepend((Object)player);
    }

    public void removePlayer(String name) {
        int n2 = this.players().indexWhere((Function1<User, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(OcelotDesktop$.$anonfun$removePlayer$1(name, x$9)));
        switch (n2) {
            case -1: {
                return;
            }
        }
        this.players().remove(n2);
    }

    public void exit() {
        this.showCloseConfirmationDialog(() -> UiHandler$.MODULE$.exit());
    }

    public Workspace workspace() {
        return workspace;
    }

    public void workspace_$eq(Workspace x$1) {
        workspace = x$1;
    }

    public TaskQueue updateThreadTasks() {
        return updateThreadTasks;
    }

    private void createWorkspace() {
        this.workspace_$eq(new Workspace(this.tmpPath()));
    }

    private void prepareSavePath(Path path, Function0<BoxedUnit> continuation) {
        boolean bl;
        try {
            bl = BoxesRunTime.unboxToBoolean(Using$.MODULE$.resource(Files.list(path), (Function1<Stream, Object> & Serializable)x$11 -> BoxesRunTime.boxToBoolean(OcelotDesktop$.$anonfun$prepareSavePath$1(x$11)), Using$Releasable$AutoCloseableIsReleasable$.MODULE$));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileNotFoundException ? true : throwable2 instanceof NoSuchFileException) {
                this.logger().info(new StringBuilder(51).append("Save path ").append(path).append(" does not exist: creating a new directory").toString());
                Files.createDirectory(path, new FileAttribute[0]);
                bl = false;
            }
            throw throwable;
        }
        boolean nonEmpty = bl;
        if (nonEmpty) {
            new NotificationDialog(continuation){
                {
                    this.addButton("Cancel", () -> this.close());
                    this.addButton("Yes", () -> {
                        this.close();
                        continuation$2.apply$mcV$sp();
                    });
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$2(ocelot.desktop.OcelotDesktop$$anon$2 ), $anonfun$new$3(ocelot.desktop.OcelotDesktop$$anon$2 scala.Function0 )}, serializedLambda);
                }
            }.show();
            return;
        }
        continuation.apply$mcV$sp();
    }

    private void showSaveDialog(Function0<BoxedUnit> continuation) {
        this.showFileChooserDialog(1, 1, (Function1<Option<File>, Try<BoxedUnit>>)(Function1<Option, Try> & Serializable)dir -> Try$.MODULE$.apply(() -> {
            if (dir.nonEmpty()) {
                MODULE$.prepareSavePath(((File)dir.get()).toPath(), () -> Transaction$.MODULE$.run((Function1<Transaction, Object> & Serializable)tx -> {
                    OcelotDesktop$.$anonfun$showSaveDialog$4(dir, continuation, tx);
                    return BoxedUnit.UNIT;
                }));
                return;
            }
        }));
    }

    private void showCloseConfirmationDialog(Option<String> prompt, Function0<BoxedUnit> continuation) {
        Object object = new Object();
        try {
            if (UiHandler$.MODULE$.root().modalDialogPool().children().exists((Function1<Widget, Object> & Serializable)x$14 -> BoxesRunTime.boxToBoolean(OcelotDesktop$.$anonfun$showCloseConfirmationDialog$1(x$14)))) {
                return;
            }
            this.savePath().withFilter((Function1<Path, Object> & Serializable)savePath -> BoxesRunTime.boxToBoolean(OcelotDesktop$.$anonfun$showCloseConfirmationDialog$2(savePath))).foreach((Function1<Path, Nothing$> & Serializable)savePath -> {
                MODULE$.saveTo((Path)savePath);
                continuation.apply$mcV$sp();
                throw new NonLocalReturnControl$mcV$sp(object, BoxedUnit.UNIT);
            });
            Option<String> prompt_ = prompt;
            new CloseConfirmationDialog(prompt_, continuation){
                private final Option prompt_$1;
                private final Function0 continuation$4;

                private /* synthetic */ String super$prompt() {
                    return super.prompt();
                }

                public String prompt() {
                    return (String)this.prompt_$1.getOrElse((Function0<String> & Serializable)() -> this.super$prompt());
                }

                public void onSaveSelected() {
                    OcelotDesktop$.MODULE$.save(() -> {
                        this.close();
                        $this.continuation$4.apply$mcV$sp();
                    });
                }

                public void onNoSaveSelected() {
                    this.close();
                    this.continuation$4.apply$mcV$sp();
                }
                {
                    this.prompt_$1 = prompt_$1;
                    this.continuation$4 = continuation$4;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onSaveSelected$1(ocelot.desktop.OcelotDesktop$$anon$3 ), $anonfun$prompt$1(ocelot.desktop.OcelotDesktop$$anon$3 )}, serializedLambda);
                }
            }.show();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void showCloseConfirmationDialog(String prompt, Function0<BoxedUnit> continuation) {
        this.showCloseConfirmationDialog(new Some<String>(prompt), continuation);
    }

    private void showCloseConfirmationDialog(Function0<BoxedUnit> continuation) {
        this.showCloseConfirmationDialog(None$.MODULE$, continuation);
    }

    public static final /* synthetic */ boolean $anonfun$mainInner$3(String player$1, User x$3) {
        String string = x$3.nickname();
        String string2 = player$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$mainInner$2(String player) {
        return MODULE$.players().exists((Function1<User, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(OcelotDesktop$.$anonfun$mainInner$3(player, x$3)));
    }

    public static final /* synthetic */ void $anonfun$saveTo$3(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            FileUtils.deleteDirectory(path.toFile());
            return;
        }
        Files.delete(path);
    }

    public static final /* synthetic */ void $anonfun$saveTo$4(Path oldPath$1, Path outputPath$1, Path path) {
        File oldFile = oldPath$1.resolve(path.getFileName()).toFile();
        File newFile = outputPath$1.resolve(path.getFileName()).toFile();
        if (Files.isDirectory(path, new LinkOption[0])) {
            FileUtils.copyDirectory(oldFile, newFile);
            return;
        }
        FileUtils.copyFile(oldFile, newFile);
    }

    public static final /* synthetic */ void $anonfun$saveTo$5(DataOutputStream writer) {
        NBTTagCompound nbt = new NBTTagCompound();
        MODULE$.saveWorld(nbt);
        CompressedStreamTools.writeCompressed(nbt, writer);
    }

    public static final /* synthetic */ void $anonfun$load$3(File dir$1, NBTTagCompound nbt$3, Path path$1, Transaction tx) {
        Option<Path> oldSavePath = MODULE$.savePath();
        MODULE$.savePath_$eq(new Some<Path>(dir$1.toPath()));
        tx.onFailure(() -> MODULE$.savePath_$eq(oldSavePath));
        Settings$.MODULE$.get().recentWorkspace_$eq(new Some<String>(dir$1.getCanonicalPath()));
        MODULE$.workspace().path_$eq(dir$1.toPath());
        MODULE$.loadWorld(nbt$3);
        MODULE$.resetAutosave();
        MODULE$.logger().info(new StringBuilder(36).append("Workspace successfully loaded from: ").append(path$1).toString());
    }

    public static final /* synthetic */ void $anonfun$load$2(File dir$1, Path path$1, DataInputStream reader) {
        NBTTagCompound nbt = CompressedStreamTools.readCompressed(reader);
        Transaction$.MODULE$.run((Function1<Transaction, Object> & Serializable)tx -> {
            OcelotDesktop$.$anonfun$load$3(dir$1, nbt, path$1, tx);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$selectPlayer$1(String name$1, User x$8) {
        String string = x$8.nickname();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$removePlayer$1(String name$2, User x$9) {
        String string = x$9.nickname();
        String string2 = name$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$prepareSavePath$1(Stream x$11) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(x$11.iterator()).asScala().nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$showSaveDialog$4(Option dir$2, Function0 continuation$3, Transaction tx) {
        Option<Path> oldSavePath = MODULE$.savePath();
        MODULE$.savePath_$eq(dir$2.map((Function1<File, Path> & Serializable)x$12 -> x$12.toPath()));
        tx.onFailure(() -> MODULE$.savePath_$eq(oldSavePath));
        MODULE$.save(continuation$3);
        Settings$.MODULE$.get().recentWorkspace_$eq(dir$2.map((Function1<File, String> & Serializable)x$13 -> x$13.getCanonicalPath()));
        MODULE$.resetAutosave();
    }

    public static final /* synthetic */ boolean $anonfun$showCloseConfirmationDialog$1(Widget x$14) {
        return x$14 instanceof CloseConfirmationDialog;
    }

    public static final /* synthetic */ boolean $anonfun$showCloseConfirmationDialog$2(Path savePath) {
        return Settings$.MODULE$.get().saveOnExit();
    }

    private OcelotDesktop$() {
    }
}

