/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.graphics;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.nio.ByteBuffer;
import ocelot.desktop.color.Color;
import ocelot.desktop.color.Color$;
import ocelot.desktop.color.RGBAColorNorm;
import ocelot.desktop.color.RGBAColorNorm$;
import ocelot.desktop.geometry.Rect2D;
import ocelot.desktop.geometry.Size2D;
import ocelot.desktop.geometry.Transform2D;
import ocelot.desktop.geometry.Transform2D$;
import ocelot.desktop.geometry.Vector2D;
import ocelot.desktop.graphics.Font;
import ocelot.desktop.graphics.Font$;
import ocelot.desktop.graphics.GraphicsState;
import ocelot.desktop.graphics.GraphicsState$;
import ocelot.desktop.graphics.IconSource;
import ocelot.desktop.graphics.IconSource$;
import ocelot.desktop.graphics.ScreenViewport;
import ocelot.desktop.graphics.ShaderProgram;
import ocelot.desktop.graphics.Texture;
import ocelot.desktop.graphics.Texture$MinFilteringMode$;
import ocelot.desktop.graphics.Viewport3D;
import ocelot.desktop.graphics.mesh.Mesh2D$;
import ocelot.desktop.graphics.mesh.MeshInstance2D;
import ocelot.desktop.graphics.mesh.MeshInstance2D$;
import ocelot.desktop.graphics.mesh.MeshVertex2D;
import ocelot.desktop.graphics.render.InstanceRenderer;
import ocelot.desktop.ui.UiHandler$;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.Resource;
import ocelot.desktop.util.Spritesheet$;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Stack;
import scala.collection.mutable.Stack$;
import scala.math.Numeric$FloatIsFractional$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.IntRef;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.Breaks$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\u0011Md\u0001B6m\u0001MD!\"a\u0002\u0001\u0005\u0003\u0007I\u0011BA\u0005\u0011)\t\t\u0002\u0001BA\u0002\u0013%\u00111\u0003\u0005\u000b\u0003?\u0001!\u0011!Q!\n\u0005-\u0001BCA\u0011\u0001\t\u0005\r\u0011\"\u0003\u0002\n!Q\u00111\u0005\u0001\u0003\u0002\u0004%I!!\n\t\u0015\u0005%\u0002A!A!B\u0013\tY\u0001\u0003\u0006\u0002,\u0001\u0011\t\u0019!C\u0005\u0003[A!\"!\u000e\u0001\u0005\u0003\u0007I\u0011BA\u001c\u0011)\tY\u0004\u0001B\u0001B\u0003&\u0011q\u0006\u0005\b\u0003{\u0001A\u0011AA \u0011%\tY\u0005\u0001a\u0001\n\u0013\ti\u0003C\u0005\u0002N\u0001\u0001\r\u0011\"\u0003\u0002P!A\u00111\u000b\u0001!B\u0013\ty\u0003C\u0005\u0002V\u0001\u0001\r\u0011\"\u0003\u0002X!I\u0011Q\r\u0001A\u0002\u0013%\u0011q\r\u0005\t\u0003W\u0002\u0001\u0015)\u0003\u0002Z!I\u0011Q\u000e\u0001C\u0002\u0013%\u0011q\u000e\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002r!I\u0011\u0011\u0010\u0001C\u0002\u0013%\u00111\u0010\u0005\t\u00037\u0003\u0001\u0015!\u0003\u0002~!I\u0011Q\u0014\u0001A\u0002\u0013%\u0011q\u0014\u0005\n\u0003O\u0003\u0001\u0019!C\u0005\u0003SC\u0001\"!,\u0001A\u0003&\u0011\u0011\u0015\u0005\n\u0003_\u0003\u0001\u0019!C\u0005\u0003?C\u0011\"!-\u0001\u0001\u0004%I!a-\t\u0011\u0005]\u0006\u0001)Q\u0005\u0003CC\u0011\"!/\u0001\u0005\u0004%I!a/\t\u0011\u0005M\u0007\u0001)A\u0005\u0003{C\u0011\"!6\u0001\u0001\u0004%I!a6\t\u0013\u0005}\u0007\u00011A\u0005\n\u0005\u0005\b\u0002CAs\u0001\u0001\u0006K!!7\t\u0013\u0005\u001d\bA1A\u0005\n\u0005]\u0003\u0002CAu\u0001\u0001\u0006I!!\u0017\t\u0013\u0005-\bA1A\u0005\n\u00055\b\u0002CA{\u0001\u0001\u0006I!a<\t\u0013\u0005]\bA1A\u0005\n\u0005%\u0001\u0002CA}\u0001\u0001\u0006I!a\u0003\t\u0013\u0005m\b\u00011A\u0005\n\u0005%\u0001\"CA\u007f\u0001\u0001\u0007I\u0011BA\u0000\u0011!\u0011\u0019\u0001\u0001Q!\n\u0005-\u0001\"\u0003B\u0003\u0001\t\u0007I\u0011\u0002B\u0004\u0011!\u0011y\u0001\u0001Q\u0001\n\t%\u0001B\u0003B\t\u0001\t\u0007I\u0011\u00017\u0002p!A!1\u0003\u0001!\u0002\u0013\t\t\bC\u0004\u0003\u0016\u0001!\tAa\u0006\t\u000f\t\u001d\u0002\u0001\"\u0011\u0003*!9!1\u0006\u0001\u0005\u0002\u0005}\u0005b\u0002B\u0017\u0001\u0011\u0005!\u0011\u0006\u0005\b\u0005_\u0001A\u0011\u0001B\u0015\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0005SAqAa\r\u0001\t\u0003\u0011I\u0003C\u0004\u00036\u0001!\tA!\u000b\t\u000f\t]\u0002\u0001\"\u0001\u0003:!9!q\b\u0001\u0005\u0002\t\u0005\u0003\"\u0003B*\u0001E\u0005I\u0011\u0001B+\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0005[B\u0011Ba(\u0001#\u0003%\tA!)\t\u0013\t\u0015\u0006!%A\u0005\u0002\tU\u0003b\u0002BT\u0001\u0011\u0005!\u0011\u0006\u0005\b\u0005S\u0003A\u0011\u0001B\u0015\u0011\u001d\u0011Y\u000b\u0001C\u0001\u0005[CqAa/\u0001\t\u0003\u0011I\u0003C\u0004\u0003*\u0002!\tA!0\t\u000f\t\u001d\u0007\u0001\"\u0001\u0003J\"9!q\u001b\u0001\u0005\u0002\te\u0007b\u0002Bs\u0001\u0011\u0005!\u0011\u001a\u0005\b\u0005O\u0004A\u0011\u0001Bu\u0011\u001d\u0011i\u000f\u0001C\u0001\u0003[AqAa<\u0001\t\u0003\u0011\t\u0010C\u0004\u0003x\u0002!\t!!\f\t\u000f\te\b\u0001\"\u0001\u0003|\"9!q \u0001\u0005\u0002\r\u0005\u0001bBB\n\u0001\u0011\u00051Q\u0003\u0005\b\u00073\u0001A\u0011AB\u000e\u0011\u001d\u0019\t\u0003\u0001C\u0001\u0007GAqa!\t\u0001\t\u0003\u0019I\u0003C\u0004\u00040\u0001!\ta!\r\t\u000f\r]\u0002\u0001\"\u0001\u0004:!91q\b\u0001\u0005\u0002\r\u0005\u0003\"CB'\u0001E\u0005I\u0011AB(\u0011\u001d\u0019\u0019\u0006\u0001C\u0001\u0007+BqAa@\u0001\t\u0003\u0019y\u0006C\u0004\u0003\u0000\u0002!\ta!\u001c\t\u000f\t}\b\u0001\"\u0001\u0004v!9!q \u0001\u0005\u0002\r5\u0005b\u0002B\u0000\u0001\u0011\u00051Q\u0013\u0005\b\u0005\u007f\u0004A\u0011ABP\u0011\u001d\u0011y\u0010\u0001C\u0001\u0007OCqAa@\u0001\t\u0003\u0019\u0019\fC\u0004\u0003\u0000\u0002!\ta!0\t\u000f\t}\b\u0001\"\u0001\u0004L\"I1\u0011\u001d\u0001\u0012\u0002\u0013\u000511\u001d\u0005\b\u0007O\u0004A\u0011ABu\u0011\u001d\u00199\u000f\u0001C\u0001\u0007cD\u0011b!@\u0001#\u0003%\taa@\t\u000f\u0011\r\u0001\u0001\"\u0003\u0003*!9AQ\u0001\u0001\u0005\n\u0011\u001d\u0001\"\u0003C\f\u0001E\u0005I\u0011BBr\u0011%!I\u0002AI\u0001\n\u0013!Y\u0002C\u0004\u0005 \u0001!\t\u0001\"\t\t\u000f\u0011}\u0001\u0001\"\u0001\u0005:!9Aq\t\u0001\u0005\u0002\u0011%\u0003b\u0002C0\u0001\u0011\u0005A\u0011\r\u0005\n\tS\u0002\u0011\u0013!C\u0001\tWB\u0011\u0002b\u001c\u0001#\u0003%\taa9\t\u000f\u0011E\u0004\u0001\"\u0001\u0003*\tAqI]1qQ&\u001c7O\u0003\u0002n]\u0006AqM]1qQ&\u001c7O\u0003\u0002pa\u00069A-Z:li>\u0004(\"A9\u0002\r=\u001cW\r\\8u\u0007\u0001\u0019R\u0001\u0001;{\u0003\u0003\u0001\"!\u001e=\u000e\u0003YT\u0011a^\u0001\u0006g\u000e\fG.Y\u0005\u0003sZ\u0014a!\u00118z%\u00164\u0007CA>\u007f\u001b\u0005a(BA?o\u0003\u0011)H/\u001b7\n\u0005}d(a\u0002'pO\u001eLgn\u001a\t\u0004w\u0006\r\u0011bAA\u0003y\nA!+Z:pkJ\u001cW-A\u0003xS\u0012$\b.\u0006\u0002\u0002\fA\u0019Q/!\u0004\n\u0007\u0005=aOA\u0002J]R\f\u0011b^5ei\"|F%Z9\u0015\t\u0005U\u00111\u0004\t\u0004k\u0006]\u0011bAA\rm\n!QK\\5u\u0011%\tiBAA\u0001\u0002\u0004\tY!A\u0002yIE\naa^5ei\"\u0004\u0013A\u00025fS\u001eDG/\u0001\u0006iK&<\u0007\u000e^0%KF$B!!\u0006\u0002(!I\u0011QD\u0003\u0002\u0002\u0003\u0007\u00111B\u0001\bQ\u0016Lw\r\u001b;!\u00035\u00198-\u00197j]\u001e4\u0015m\u0019;peV\u0011\u0011q\u0006\t\u0004k\u0006E\u0012bAA\u001am\n)a\t\\8bi\u0006\t2oY1mS:<g)Y2u_J|F%Z9\u0015\t\u0005U\u0011\u0011\b\u0005\n\u0003;A\u0011\u0011!a\u0001\u0003_\tab]2bY&twMR1di>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\t\u0003\u0003\n)%a\u0012\u0002JA\u0019\u00111\t\u0001\u000e\u00031Dq!a\u0002\u000b\u0001\u0004\tY\u0001C\u0004\u0002\")\u0001\r!a\u0003\t\u000f\u0005-\"\u00021\u0001\u00020\u0005!A/[7f\u0003!!\u0018.\\3`I\u0015\fH\u0003BA\u000b\u0003#B\u0011\"!\b\r\u0003\u0003\u0005\r!a\f\u0002\u000bQLW.\u001a\u0011\u0002\u0015A\u0014xN[3di&|g.\u0006\u0002\u0002ZA!\u00111LA1\u001b\t\tiFC\u0002\u0002`9\f\u0001bZ3p[\u0016$(/_\u0005\u0005\u0003G\niFA\u0006Ue\u0006t7OZ8s[J\"\u0015A\u00049s_*,7\r^5p]~#S-\u001d\u000b\u0005\u0003+\tI\u0007C\u0005\u0002\u001e=\t\t\u00111\u0001\u0002Z\u0005Y\u0001O]8kK\u000e$\u0018n\u001c8!\u00035\u0019\b.\u00193feB\u0013xn\u001a:b[V\u0011\u0011\u0011\u000f\t\u0005\u0003\u0007\n\u0019(C\u0002\u0002v1\u0014Qb\u00155bI\u0016\u0014\bK]8he\u0006l\u0017AD:iC\u0012,'\u000f\u0015:pOJ\fW\u000eI\u0001\te\u0016tG-\u001a:feV\u0011\u0011Q\u0010\t\t\u0003\u007f\n))!#\u0002\u00166\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007c\u0017A\u0002:f]\u0012,'/\u0003\u0003\u0002\b\u0006\u0005%\u0001E%ogR\fgnY3SK:$WM]3s!\u0011\tY)!%\u000e\u0005\u00055%bAAHY\u0006!Q.Z:i\u0013\u0011\t\u0019*!$\u0003\u00195+7\u000f\u001b,feR,\u0007P\r#\u0011\t\u0005-\u0015qS\u0005\u0005\u00033\u000biI\u0001\bNKND\u0017J\\:uC:\u001cWM\r#\u0002\u0013I,g\u000eZ3sKJ\u0004\u0013!B0g_:$XCAAQ!\u0011\t\u0019%a)\n\u0007\u0005\u0015FN\u0001\u0003G_:$\u0018!C0g_:$x\fJ3r)\u0011\t)\"a+\t\u0013\u0005ua#!AA\u0002\u0005\u0005\u0016AB0g_:$\b%A\u0004pY\u00124uN\u001c;\u0002\u0017=dGMR8oi~#S-\u001d\u000b\u0005\u0003+\t)\fC\u0005\u0002\u001ee\t\t\u00111\u0001\u0002\"\u0006Aq\u000e\u001c3G_:$\b%A\u0003ti\u0006\u001c7.\u0006\u0002\u0002>B1\u0011qXAe\u0003\u001bl!!!1\u000b\t\u0005\r\u0017QY\u0001\b[V$\u0018M\u00197f\u0015\r\t9M^\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAf\u0003\u0003\u0014Qa\u0015;bG.\u0004B!a\u0011\u0002P&\u0019\u0011\u0011\u001b7\u0003\u001b\u001d\u0013\u0018\r\u001d5jGN\u001cF/\u0019;f\u0003\u0019\u0019H/Y2lA\u0005Q1\u000f\u001d:ji\u0016\u0014Vm\u0019;\u0016\u0005\u0005e\u0007\u0003BA.\u00037LA!!8\u0002^\t1!+Z2ue\u0011\u000bab\u001d9sSR,'+Z2u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005\r\b\"CA\u000f=\u0005\u0005\t\u0019AAm\u0003-\u0019\bO]5uKJ+7\r\u001e\u0011\u0002!\u0015l\u0007\u000f^=TaJLG/\u001a+sC:\u001c\u0018!E3naRL8\u000b\u001d:ji\u0016$&/\u00198tA\u0005\u0001rN\u001a4tGJ,WM\u001c+fqR,(/Z\u000b\u0003\u0003_\u0004B!a\u0011\u0002r&\u0019\u00111\u001f7\u0003\u000fQ+\u0007\u0010^;sK\u0006\trN\u001a4tGJ,WM\u001c+fqR,(/\u001a\u0011\u0002)=4gm]2sK\u0016tgI]1nK\n,hMZ3s\u0003UygMZ:de\u0016,gN\u0012:b[\u0016\u0014WO\u001a4fe\u0002\n!cY;se\u0016tGO\u0012:b[\u0016\u0014WO\u001a4fe\u000612-\u001e:sK:$hI]1nK\n,hMZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\t\u0005\u0001\"CA\u000fO\u0005\u0005\t\u0019AA\u0006\u0003M\u0019WO\u001d:f]R4%/Y7fEV4g-\u001a:!\u00039\u0019WO\u001d:f]R\u001c6-[:t_J,\"A!\u0003\u0011\u000bU\u0014Y!!7\n\u0007\t5aO\u0001\u0004PaRLwN\\\u0001\u0010GV\u0014(/\u001a8u'\u000eL7o]8sA\u0005\u00192o\u0019:fK:\u001c\u0006.\u00193feB\u0013xn\u001a:b[\u0006!2o\u0019:fK:\u001c\u0006.\u00193feB\u0013xn\u001a:b[\u0002\naA]3tSj,G\u0003\u0003B\r\u0005?\u0011\tCa\t\u0011\u0007U\u0014Y\"C\u0002\u0003\u001eY\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0002\b5\u0002\r!a\u0003\t\u000f\u0005\u0005R\u00061\u0001\u0002\f!9!QE\u0017A\u0002\u0005=\u0012aB:dC2LgnZ\u0001\rMJ,WMU3t_V\u00148-\u001a\u000b\u0003\u0003+\tAAZ8oi\u0006i1/\u001a;O_Jl\u0017\r\u001c$p]R\fAb]3u'6\fG\u000e\u001c$p]R\fAa]1wK\u00069!/Z:u_J,\u0017a\u00042fO&twI]8va\u0006c\u0007\u000f[1\u0002\u001b\u0015tGm\u0012:pkB\fE\u000e\u001d5b)\u0011\t)Ba\u000f\t\u000f\tuR\u00071\u0001\u00020\u0005)\u0011\r\u001c9iC\u0006q!\r\\5u-&,w\u000f]8siN\"E\u0003CA\u000b\u0005\u0007\u0012iE!\u0015\t\u000f\t\u0015c\u00071\u0001\u0003H\u0005Aa/[3xa>\u0014H\u000f\u0005\u0003\u0002D\t%\u0013b\u0001B&Y\nQa+[3xa>\u0014Ho\r#\t\u000f\t=c\u00071\u0001\u0002Z\u00061!m\\;oIND\u0011B!\u00107!\u0003\u0005\r!a\f\u00021\td\u0017\u000e\u001e,jK^\u0004xN\u001d;4\t\u0012\"WMZ1vYR$3'\u0006\u0002\u0003X)\"\u0011q\u0006B-W\t\u0011Y\u0006\u0005\u0003\u0003^\t\u001dTB\u0001B0\u0015\u0011\u0011\tGa\u0019\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B3m\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%$q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00052mSR\u001c6M]3f]ZKWm\u001e9peR$\"\"!\u0006\u0003p\t]$\u0011\u0010BO\u0011\u001d\u0011)\u0005\u000fa\u0001\u0005c\u0002B!a\u0011\u0003t%\u0019!Q\u000f7\u0003\u001dM\u001b'/Z3o-&,w\u000f]8si\"9!q\n\u001dA\u0002\u0005e\u0007\"\u0003B>qA\u0005\t\u0019\u0001B?\u000351\u0017\u000e\u001c;fe&tw-T8eKB!!q\u0010BL\u001d\u0011\u0011\tIa%\u000f\t\t\r%\u0011\u0013\b\u0005\u0005\u000b\u0013yI\u0004\u0003\u0003\b\n5UB\u0001BE\u0015\r\u0011YI]\u0001\u0007yI|w\u000e\u001e \n\u0003EL!a\u001c9\n\u00055t\u0017b\u0001BKY\u00069A+\u001a=ukJ,\u0017\u0002\u0002BM\u00057\u0013\u0001#T5o\r&dG/\u001a:j]\u001elu\u000eZ3\u000b\u0007\tUE\u000eC\u0005\u0003>a\u0002\n\u00111\u0001\u00020\u0005a\"\r\\5u'\u000e\u0014X-\u001a8WS\u0016<\bo\u001c:uI\u0011,g-Y;mi\u0012\u001aTC\u0001BRU\u0011\u0011iH!\u0017\u00029\td\u0017\u000e^*de\u0016,gNV5foB|'\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005)!-Z4j]\u0006)1\r\\3be\u0006Q1/\u001a;TG&\u001c8o\u001c:\u0015\u0015\u0005U!q\u0016BZ\u0005o\u0013I\fC\u0004\u00032v\u0002\r!a\f\u0002\u0003aDqA!.>\u0001\u0004\ty#A\u0001z\u0011\u001d\t9!\u0010a\u0001\u0003_Aq!!\t>\u0001\u0004\ty#\u0001\u0007dY\u0016\f'oU2jgN|'\u000f\u0006\u0006\u0002\u0016\t}&\u0011\u0019Bb\u0005\u000bDqA!-@\u0001\u0004\tY\u0001C\u0004\u00036~\u0002\r!a\u0003\t\u000f\u0005\u001dq\b1\u0001\u0002\f!9\u0011\u0011E A\u0002\u0005-\u0011A\u00034pe\u0016<'o\\;oIV\u0011!1\u001a\t\u0005\u0005\u001b\u0014\u0019.\u0004\u0002\u0003P*\u0019!\u0011\u001b8\u0002\u000b\r|Gn\u001c:\n\t\tU'q\u001a\u0002\u000e%\u001e\u0013\u0015iQ8m_JtuN]7\u0002\u001d\u0019|'/Z4s_VtGm\u0018\u0013fcR!\u0011Q\u0003Bn\u0011\u001d\u0011i.\u0011a\u0001\u0005?\f1aY8m!\u0011\u0011iM!9\n\t\t\r(q\u001a\u0002\u0006\u0007>dwN]\u0001\u000bE\u0006\u001c7n\u001a:pk:$\u0017A\u00042bG.<'o\\;oI~#S-\u001d\u000b\u0005\u0003+\u0011Y\u000fC\u0004\u0003^\u000e\u0003\rAa8\u0002%\u0019|g\u000e^*ju\u0016lU\u000f\u001c;ja2LWM]\u0001\u0017M>tGoU5{K6+H\u000e^5qY&,'o\u0018\u0013fcR!\u0011Q\u0003Bz\u0011\u001d\u0011)0\u0012a\u0001\u0003_\tQA^1mk\u0016\fq\"\u00197qQ\u0006lU\u000f\u001c;ja2LWM]\u0001\u0014C2\u0004\b.Y'vYRL\u0007\u000f\\5fe~#S-\u001d\u000b\u0005\u0003+\u0011i\u0010C\u0004\u0003v\u001e\u0003\r!a\f\u0002\rM\u0004(/\u001b;f+\t\u0019\u0019\u0001\u0005\u0003\u0004\u0006\r5a\u0002BB\u0004\u0007\u0013\u00012Aa\"w\u0013\r\u0019YA^\u0001\u0007!J,G-\u001a4\n\t\r=1\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\r-a/\u0001\u0006taJLG/Z0%KF$B!!\u0006\u0004\u0018!9!Q_%A\u0002\r\r\u0011!\u0003;sC:\u001chm\u001c:n)\u0011\t)b!\b\t\u000f\r}!\n1\u0001\u0002Z\u0005\tA/A\u0003tG\u0006dW\r\u0006\u0003\u0002\u0016\r\u0015\u0002bBB\u0014\u0017\u0002\u0007\u0011qF\u0001\u0002mR1\u0011QCB\u0016\u0007[AqA!-M\u0001\u0004\ty\u0003C\u0004\u000362\u0003\r!a\f\u0002\u0013Q\u0014\u0018M\\:mCR,GCBA\u000b\u0007g\u0019)\u0004C\u0004\u000326\u0003\r!a\f\t\u000f\tUV\n1\u0001\u00020\u00051!o\u001c;bi\u0016$B!!\u0006\u0004<!91Q\b(A\u0002\u0005=\u0012!B1oO2,\u0017\u0001\u0002;fqR$\"\"!\u0006\u0004D\r\u00153qIB%\u0011\u001d\u0011\tl\u0014a\u0001\u0003_AqA!.P\u0001\u0004\ty\u0003C\u0004\u0004@=\u0003\raa\u0001\t\u0013\r-s\n%AA\u0002\u0005-\u0011AB:ie&t7.\u0001\buKb$H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\rE#\u0006BA\u0006\u00053\nAa\u00195beRA\u0011QCB,\u00073\u001aY\u0006C\u0004\u00032F\u0003\r!a\f\t\u000f\tU\u0016\u000b1\u0001\u00020!91QL)A\u0002\u0005-\u0011!A2\u0015\r\u0005U1\u0011MB6\u0011\u001d\u0019\u0019G\u0015a\u0001\u0007K\nA![2p]B!\u00111IB4\u0013\r\u0019I\u0007\u001c\u0002\u000b\u0013\u000e|gnU8ve\u000e,\u0007b\u0002B(%\u0002\u0007\u0011\u0011\u001c\u000b\t\u0003+\u0019yg!\u001d\u0004t!911M*A\u0002\r\u0015\u0004b\u0002B('\u0002\u0007\u0011\u0011\u001c\u0005\b\u0005#\u001c\u0006\u0019\u0001Bp)!\t)ba\u001e\u0004z\r\r\u0005bBB2)\u0002\u00071Q\r\u0005\b\u0007w\"\u0006\u0019AB?\u0003\r\u0001xn\u001d\t\u0005\u00037\u001ay(\u0003\u0003\u0004\u0002\u0006u#\u0001\u0003,fGR|'O\r#\t\u000f\r\u0015E\u000b1\u0001\u0004\b\u0006!1/\u001b>f!\u0011\tYf!#\n\t\r-\u0015Q\f\u0002\u0007'&TXM\r#\u0015\u0011\u0005U1qRBI\u0007'Cqaa\u0019V\u0001\u0004\u0019)\u0007C\u0004\u0004|U\u0003\ra! \t\u000f\tEW\u000b1\u0001\u0003`RQ\u0011QCBL\u00073\u001bYj!(\t\u000f\r\rd\u000b1\u0001\u0004f!911\u0010,A\u0002\ru\u0004bBBC-\u0002\u00071q\u0011\u0005\b\u0005#4\u0006\u0019\u0001Bp)!\t)b!)\u0004$\u000e\u0015\u0006bBB2/\u0002\u00071Q\r\u0005\b\u0005c;\u0006\u0019AA\u0018\u0011\u001d\u0011)l\u0016a\u0001\u0003_!B\"!\u0006\u0004*\u000e-6QVBX\u0007cCqaa\u0019Y\u0001\u0004\u0019)\u0007C\u0004\u00032b\u0003\r!a\f\t\u000f\tU\u0006\f1\u0001\u00020!9\u0011q\u0001-A\u0002\u0005=\u0002bBA\u00111\u0002\u0007\u0011q\u0006\u000b\u000b\u0003+\u0019)la.\u0004:\u000em\u0006bBB23\u0002\u00071Q\r\u0005\b\u0005cK\u0006\u0019AA\u0018\u0011\u001d\u0011),\u0017a\u0001\u0003_AqA!5Z\u0001\u0004\u0011y\u000e\u0006\b\u0002\u0016\r}6\u0011YBb\u0007\u000b\u001c9m!3\t\u000f\r\r$\f1\u0001\u0004f!9!\u0011\u0017.A\u0002\u0005=\u0002b\u0002B[5\u0002\u0007\u0011q\u0006\u0005\b\u0003\u000fQ\u0006\u0019AA\u0018\u0011\u001d\t\tC\u0017a\u0001\u0003_AqA!5[\u0001\u0004\u0011y\u000e\u0006\n\u0002\u0016\r57\u0011[Bj\u0007+\u001c9n!7\u0004\\\u000eu\u0007bBBh7\u0002\u000711A\u0001\u0005]\u0006lW\rC\u0004\u00032n\u0003\r!a\f\t\u000f\tU6\f1\u0001\u00020!9\u0011qA.A\u0002\u0005=\u0002bBA\u00117\u0002\u0007\u0011q\u0006\u0005\b\u0005#\\\u0006\u0019\u0001Bp\u0011\u001d\t)n\u0017a\u0001\u0005\u0013A\u0011ba8\\!\u0003\u0005\rA!\u0007\u0002\u000b\u0019L\u00070\u0016,\u0002!M\u0004(/\u001b;fI\u0011,g-Y;mi\u0012BTCABsU\u0011\u0011IB!\u0017\u0002\tI,7\r\u001e\u000b\u0007\u0003+\u0019Yoa<\t\u000f\r5X\f1\u0001\u0002Z\u0006\t!\u000fC\u0004\u0003Rv\u0003\rAa8\u0015\u0019\u0005U11_B{\u0007o\u001cIpa?\t\u000f\tEf\f1\u0001\u00020!9!Q\u00170A\u0002\u0005=\u0002bBA\u0004=\u0002\u0007\u0011q\u0006\u0005\b\u0003Cq\u0006\u0019AA\u0018\u0011%\u0011\tN\u0018I\u0001\u0002\u0004\u0011y.\u0001\bsK\u000e$H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0011\u0005!\u0006\u0002Bp\u00053\n\u0011b\u00195fG.4uN\u001c;\u0002\u000b}\u0013Xm\u0019;\u0015\u001d\u0005UA\u0011\u0002C\u0006\t\u001b!y\u0001\"\u0005\u0005\u0014!9!\u0011W1A\u0002\u0005=\u0002b\u0002B[C\u0002\u0007\u0011q\u0006\u0005\b\u0003\u000f\t\u0007\u0019AA\u0018\u0011\u001d\t\t#\u0019a\u0001\u0003_A\u0011ba8b!\u0003\u0005\rA!\u0007\t\u0013\u0011U\u0011\r%AA\u0002\t%\u0011AE:qe&$XMU3di>\u0003H/[8oC2\fqb\u0018:fGR$C-\u001a4bk2$H%N\u0001\u0010?J,7\r\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u0011AQ\u0004\u0016\u0005\u0005\u0013\u0011I&\u0001\u0003mS:,GCDA\u000b\tG!9\u0003b\u000b\u00050\u0011MBq\u0007\u0005\b\tK!\u0007\u0019AA\u0018\u0003\tA\u0018\u0007C\u0004\u0005*\u0011\u0004\r!a\f\u0002\u0005e\f\u0004b\u0002C\u0017I\u0002\u0007\u0011qF\u0001\u0003qJBq\u0001\"\re\u0001\u0004\ty#\u0001\u0002ze!9AQ\u00073A\u0002\u0005=\u0012!\u0003;iS\u000e\\g.Z:t\u0011\u001d\u0011\t\u000e\u001aa\u0001\u0005?$\"\"!\u0006\u0005<\u0011}B1\tC#\u0011\u001d!i$\u001aa\u0001\u0007{\nQa\u001d;beRDq\u0001\"\u0011f\u0001\u0004\u0019i(A\u0002f]\u0012Dq\u0001\"\u000ef\u0001\u0004\ty\u0003C\u0004\u0003R\u0016\u0004\rAa8\u0002\u0015M\u001c'/Z3og\"|G\u000f\u0006\u0002\u0005LA!AQ\nC.\u001b\t!yE\u0003\u0003\u0005R\u0011M\u0013!B5nC\u001e,'\u0002\u0002C+\t/\n1!Y<u\u0015\t!I&\u0001\u0003kCZ\f\u0017\u0002\u0002C/\t\u001f\u0012QBQ;gM\u0016\u0014X\rZ%nC\u001e,\u0017!\u00024mkNDGCBA\u000b\tG\"9\u0007C\u0005\u0005f\u001d\u0004\n\u00111\u0001\u0002p\u0006YQ.Y5o)\u0016DH/\u001e:f\u0011%\u0011Ik\u001aI\u0001\u0002\u0004\u0011I\"A\bgYV\u001c\b\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t!iG\u000b\u0003\u0002p\ne\u0013a\u00044mkNDG\u0005Z3gCVdG\u000f\n\u001a\u0002\rU\u0004H-\u0019;f\u0001")
public class Graphics
implements Logging,
Resource {
    private int width;
    private int height;
    private float scalingFactor;
    private float time;
    private Transform2D projection;
    private final ShaderProgram shaderProgram;
    private final InstanceRenderer<MeshVertex2D, MeshInstance2D> renderer;
    private Font _font;
    private Font oldFont;
    private final Stack<GraphicsState> stack;
    private Rect2D spriteRect;
    private final Transform2D emptySpriteTrans;
    private final Texture offscreenTexture;
    private final int offscreenFramebuffer;
    private int currentFramebuffer;
    private final Option<Rect2D> currentScissor;
    private final ShaderProgram screenShaderProgram;
    private Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int width() {
        return this.width;
    }

    private void width_$eq(int x$1) {
        this.width = x$1;
    }

    private int height() {
        return this.height;
    }

    private void height_$eq(int x$1) {
        this.height = x$1;
    }

    private float scalingFactor() {
        return this.scalingFactor;
    }

    private void scalingFactor_$eq(float x$1) {
        this.scalingFactor = x$1;
    }

    private float time() {
        return this.time;
    }

    private void time_$eq(float x$1) {
        this.time = x$1;
    }

    private Transform2D projection() {
        return this.projection;
    }

    private void projection_$eq(Transform2D x$1) {
        this.projection = x$1;
    }

    private ShaderProgram shaderProgram() {
        return this.shaderProgram;
    }

    private InstanceRenderer<MeshVertex2D, MeshInstance2D> renderer() {
        return this.renderer;
    }

    private Font _font() {
        return this._font;
    }

    private void _font_$eq(Font x$1) {
        this._font = x$1;
    }

    private Font oldFont() {
        return this.oldFont;
    }

    private void oldFont_$eq(Font x$1) {
        this.oldFont = x$1;
    }

    private Stack<GraphicsState> stack() {
        return this.stack;
    }

    private Rect2D spriteRect() {
        return this.spriteRect;
    }

    private void spriteRect_$eq(Rect2D x$1) {
        this.spriteRect = x$1;
    }

    private Transform2D emptySpriteTrans() {
        return this.emptySpriteTrans;
    }

    private Texture offscreenTexture() {
        return this.offscreenTexture;
    }

    private int offscreenFramebuffer() {
        return this.offscreenFramebuffer;
    }

    private int currentFramebuffer() {
        return this.currentFramebuffer;
    }

    private void currentFramebuffer_$eq(int x$1) {
        this.currentFramebuffer = x$1;
    }

    private Option<Rect2D> currentScissor() {
        return this.currentScissor;
    }

    public ShaderProgram screenShaderProgram() {
        return this.screenShaderProgram;
    }

    public boolean resize(int width, int height, float scaling) {
        boolean viewportChanged;
        block1: {
            viewportChanged = false;
            if (scaling != this.scalingFactor()) {
                this.scalingFactor_$eq(scaling);
                ((GraphicsState)this.stack().last()).transform_$eq(Transform2D$.MODULE$.scale(this.scalingFactor()));
                viewportChanged = true;
            }
            if (this.width() == width && this.height() == height) break block1;
            this.width_$eq(width);
            this.height_$eq(height);
            this.offscreenTexture().bind(this.offscreenTexture().bind$default$1());
            GL11.glTexImage2D(3553, 0, 35907, width, height, 0, 6408, 5121, null);
            viewportChanged = true;
        }
        return viewportChanged;
    }

    @Override
    public void freeResource() {
        Resource.freeResource$(this);
        GL30.glDeleteFramebuffers(this.offscreenFramebuffer());
        this.offscreenTexture().freeResource();
        Spritesheet$.MODULE$.freeResource();
        this.renderer().freeResource();
        this.shaderProgram().freeResource();
        this.screenShaderProgram().freeResource();
    }

    public Font font() {
        return this._font();
    }

    public void setNormalFont() {
        Font font = this._font();
        Font font2 = Font$.MODULE$.NormalFont();
        if (!(font != null ? !font.equals(font2) : font2 != null)) {
            return;
        }
        this.flush(this.flush$default$1(), this.flush$default$2());
        this._font_$eq(Font$.MODULE$.NormalFont());
    }

    public void setSmallFont() {
        Font font = this._font();
        Font font2 = Font$.MODULE$.SmallFont();
        if (!(font != null ? !font.equals(font2) : font2 != null)) {
            return;
        }
        this.flush(this.flush$default$1(), this.flush$default$2());
        this._font_$eq(Font$.MODULE$.SmallFont());
    }

    public void save() {
        GraphicsState qual$1 = (GraphicsState)this.stack().head();
        RGBAColorNorm x$1 = qual$1.copy$default$1();
        RGBAColorNorm x$2 = qual$1.copy$default$2();
        float x$3 = qual$1.copy$default$3();
        float x$4 = qual$1.copy$default$4();
        String x$5 = qual$1.copy$default$5();
        Option<Tuple4<Object, Object, Object, Object>> x$6 = qual$1.copy$default$6();
        Transform2D x$7 = qual$1.copy$default$7();
        this.stack().push(qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7));
    }

    public void restore() {
        if (this.stack().length() == 1) {
            throw new RuntimeException("attempt to pop root graphics state");
        }
        GraphicsState old = (GraphicsState)this.stack().last();
        Option<Tuple4<Object, Object, Object, Object>> option = old.scissor();
        Option<Tuple4<Object, Object, Object, Object>> option2 = ((GraphicsState)this.stack().head()).scissor();
        if (option == null ? option2 != null : !option.equals(option2)) {
            this.flush(this.flush$default$1(), this.flush$default$2());
        }
        this.stack().pop();
    }

    public void beginGroupAlpha() {
        this.flush(this.flush$default$1(), this.flush$default$2());
        GL30.glBindFramebuffer(36160, this.offscreenFramebuffer());
        GL11.glDisable(3089);
        GL11.glViewport(0, 0, this.width(), this.height());
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GL11.glClear(16384);
        this.currentFramebuffer_$eq(this.offscreenFramebuffer());
    }

    public void endGroupAlpha(float alpha) {
        this.flush(this.flush$default$1(), this.flush$default$2());
        this.currentFramebuffer_$eq(0);
        this.foreground_$eq(new RGBAColorNorm(1.0f, 1.0f, 1.0f, alpha));
        this.spriteRect_$eq(new Rect2D(0.0f, 1.0f, 1.0f, -1.0f));
        this._rect(0.0f, 0.0f, (float)this.width() / this.scalingFactor(), (float)this.height() / this.scalingFactor(), false, this._rect$default$6());
        this.flush(this.offscreenTexture(), this.flush$default$2());
    }

    public void blitViewport3D(Viewport3D viewport, Rect2D bounds, float alpha) {
        this.flush(this.flush$default$1(), this.flush$default$2());
        this.foreground_$eq(new RGBAColorNorm(1.0f, 1.0f, 1.0f, alpha));
        this.spriteRect_$eq(new Rect2D(0.0f, 1.0f, 1.0f, -1.0f));
        this._rect(bounds.x(), bounds.y(), bounds.w(), bounds.h(), false, this._rect$default$6());
        this.flush(viewport.textureColor(), this.flush$default$2());
    }

    public float blitViewport3D$default$3() {
        return 1.0f;
    }

    public void blitScreenViewport(ScreenViewport viewport, Rect2D bounds, Texture.MinFilteringMode filteringMode, float alpha) {
        this.flush(this.flush$default$1(), this.flush$default$2());
        this.foreground_$eq(new RGBAColorNorm(1.0f, 1.0f, 1.0f, alpha));
        this.spriteRect_$eq(new Rect2D(0.0f, 1.0f, 1.0f, -1.0f));
        this._rect(bounds.x(), bounds.y(), bounds.w(), bounds.h(), false, this._rect$default$6());
        viewport.texture().setMinFilter(filteringMode);
        this.flush(viewport.texture(), this.flush$default$2());
    }

    public Texture.MinFilteringMode blitScreenViewport$default$3() {
        return Texture$MinFilteringMode$.MODULE$.Nearest();
    }

    public float blitScreenViewport$default$4() {
        return 1.0f;
    }

    public void begin() {
        this.shaderProgram().set("uProj", Transform2D$.MODULE$.viewport(this.width(), this.height()));
    }

    public void clear() {
        boolean x$1 = true;
        Texture x$2 = this.flush$default$1();
        this.flush(x$2, true);
    }

    public void setScissor(float x, float y, float width, float height) {
        this.flush(this.flush$default$1(), this.flush$default$2());
        ((GraphicsState)this.stack().head()).scissor_$eq(new Some<Tuple4<Object, Object, Object, Object>>(new Tuple4<Float, Float, Float, Float>(BoxesRunTime.boxToFloat(x), BoxesRunTime.boxToFloat(y), BoxesRunTime.boxToFloat(width), BoxesRunTime.boxToFloat(height))));
    }

    public void clearScissor() {
        this.flush(this.flush$default$1(), this.flush$default$2());
        ((GraphicsState)this.stack().head()).scissor_$eq(None$.MODULE$);
    }

    public void clear(int x, int y, int width, int height) {
        this.save();
        this.setScissor(x, y, width, height);
        this.clear();
        this.restore();
    }

    public RGBAColorNorm foreground() {
        return ((GraphicsState)this.stack().head()).foreground();
    }

    public void foreground_$eq(Color col) {
        ((GraphicsState)this.stack().head()).foreground_$eq(col.toRGBANorm());
    }

    public RGBAColorNorm background() {
        return ((GraphicsState)this.stack().head()).background();
    }

    public void background_$eq(Color col) {
        ((GraphicsState)this.stack().head()).background_$eq(col.toRGBANorm());
    }

    public float fontSizeMultiplier() {
        return ((GraphicsState)this.stack().head()).fontSizeMultiplier();
    }

    public void fontSizeMultiplier_$eq(float value) {
        ((GraphicsState)this.stack().head()).fontSizeMultiplier_$eq(value);
    }

    public float alphaMultiplier() {
        return ((GraphicsState)this.stack().head()).alphaMultiplier();
    }

    public void alphaMultiplier_$eq(float value) {
        ((GraphicsState)this.stack().head()).alphaMultiplier_$eq(value);
    }

    public String sprite() {
        return ((GraphicsState)this.stack().head()).sprite();
    }

    public void sprite_$eq(String value) {
        ((GraphicsState)this.stack().head()).sprite_$eq(value);
        this.spriteRect_$eq(Spritesheet$.MODULE$.sprites().apply(value));
    }

    public void transform(Transform2D t) {
        ((GraphicsState)this.stack().head()).transform_$eq(((GraphicsState)this.stack().head()).transform().$greater$greater(t));
    }

    public void scale(float v) {
        this.transform(Transform2D$.MODULE$.scale(v));
    }

    public void scale(float x, float y) {
        this.transform(Transform2D$.MODULE$.scale(x, y));
    }

    public void translate(float x, float y) {
        this.transform(Transform2D$.MODULE$.translate(x, y));
    }

    public void rotate(float angle) {
        this.transform(Transform2D$.MODULE$.rotate(angle));
    }

    public void text(float x, float y, String text, int shrink) {
        FloatRef ox = FloatRef.create(x);
        text.codePoints().forEach(c2 -> {
            this.char(ox$1.elem, y, c2);
            ox$1.elem += (float)(this._font().charWidth(c2) - shrink);
        });
    }

    public int text$default$4() {
        return 0;
    }

    public void char(float x, float y, int c2) {
        float fontSize = this.fontSizeMultiplier() * (float)this._font().fontSize();
        Rect2D rect = (Rect2D)this._font().map().getOrElse(c2, (Function0<Rect2D> & Serializable)() -> this._font().map().apply(63));
        Transform2D uvTransform = Transform2D$.MODULE$.translate(rect.x(), rect.y()).$greater$greater(Transform2D$.MODULE$.scale(rect.w() - 0.25f / (float)this._font().AtlasWidth(), rect.h() - 0.25f / (float)this._font().AtlasHeight()));
        Transform2D transform = ((GraphicsState)this.stack().head()).transform().$greater$greater(Transform2D$.MODULE$.translate(RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper(x)), RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper(y)))).$greater$greater(Transform2D$.MODULE$.scale(this._font().charWidth(c2), fontSize));
        RGBAColorNorm foreground = ((GraphicsState)this.stack().head()).foreground().toRGBANorm().mapA(x$1 -> x$1 * this.alphaMultiplier());
        RGBAColorNorm background = ((GraphicsState)this.stack().head()).background().toRGBANorm().mapA(x$2 -> x$2 * this.alphaMultiplier());
        if (background.a() > 0.0f || foreground.a() > 0.0f) {
            this.renderer().schedule(new MeshInstance2D(background, foreground, transform, this.emptySpriteTrans(), uvTransform));
            return;
        }
    }

    public void sprite(IconSource icon, Rect2D bounds) {
        this.sprite(icon, bounds.x(), bounds.y(), bounds.w(), bounds.h(), Color$.MODULE$.White());
    }

    public void sprite(IconSource icon, Rect2D bounds, Color color) {
        this.sprite(icon, bounds.x(), bounds.y(), bounds.w(), bounds.h(), color);
    }

    public void sprite(IconSource icon, Vector2D pos, Size2D size) {
        this.sprite(icon, pos.x(), pos.y(), size.width(), size.height(), Color$.MODULE$.White());
    }

    public void sprite(IconSource icon, Vector2D pos, Color color) {
        this.sprite(icon, pos.x(), pos.y(), color);
    }

    public void sprite(IconSource icon, Vector2D pos, Size2D size, Color color) {
        this.sprite(icon, pos.x(), pos.y(), size.width(), size.height(), color);
    }

    public void sprite(IconSource icon, float x, float y) {
        this.sprite(icon, x, y, (Color)Color$.MODULE$.White());
    }

    public void sprite(IconSource icon, float x, float y, float width, float height) {
        this.sprite(icon, x, y, width, height, Color$.MODULE$.White());
    }

    public void sprite(IconSource icon, float x, float y, Color color) {
        Size2D size = Spritesheet$.MODULE$.spriteSize(icon.path());
        this.sprite(icon, x, y, size.width(), size.height(), color);
    }

    public void sprite(IconSource icon, float x, float y, float width, float height, Color color) {
        this.sprite_$eq(icon.path());
        this.foreground_$eq(color);
        Option<Rect2D> spriteRect = icon.animation().map((Function1<IconSource.Animation, Rect2D> & Serializable)animation -> {
            Size2D size2D;
            float duration = BoxesRunTime.unboxToFloat(Predef$.MODULE$.wrapFloatArray((float[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(animation.frames()), (Function1<Tuple2, Object> & Serializable)x$3 -> BoxesRunTime.boxToFloat(Graphics.$anonfun$sprite$2(x$3)), ClassTag$.MODULE$.Float())).sum(Numeric$FloatIsFractional$.MODULE$));
            FloatRef timeOffset = FloatRef.create(0.0f);
            IntRef curFrame = IntRef.create(0);
            Breaks$.MODULE$.breakable(() -> ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps(animation.frames()), (Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(Graphics.$anonfun$sprite$4(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$4 -> {
                Graphics.$anonfun$sprite$5(this, timeOffset, curFrame, duration, x$4);
                return BoxedUnit.UNIT;
            }));
            Option<Size2D> option = animation.frameSize();
            if (option instanceof Some) {
                Some some = (Some)option;
                Size2D size = (Size2D)some.value();
                size2D = new Size2D(this.spriteRect().w(), this.spriteRect().w() * size.height() / size.width());
            } else if (None$.MODULE$.equals(option)) {
                size2D = new Size2D(this.spriteRect().w(), this.spriteRect().w());
            } else {
                throw new MatchError(option);
            }
            Size2D size = size2D;
            Rect2D qual$1 = this.spriteRect();
            float x$1 = this.spriteRect().y() + (float)curFrame.elem * size.height();
            float x$2 = size.height();
            float x$32 = qual$1.copy$default$1();
            float x$4 = qual$1.copy$default$3();
            return qual$1.copy(x$32, x$1, x$4, x$2);
        });
        this._rect(x, y, width, height, true, spriteRect);
    }

    public void sprite(String name, float x, float y, float width, float height, Color color, Option<Rect2D> spriteRect, boolean fixUV) {
        this.sprite_$eq(name);
        this.foreground_$eq(color);
        this._rect(x, y, width, height, fixUV, spriteRect);
    }

    public boolean sprite$default$8() {
        return true;
    }

    public void rect(Rect2D r, Color color) {
        this.rect(r.x(), r.y(), r.w(), r.h(), color);
    }

    public void rect(float x, float y, float width, float height, Color color) {
        this.sprite(IconSource$.MODULE$.Empty(), x, y, width, height, color);
    }

    public Color rect$default$5() {
        return new RGBAColorNorm(1.0f, 1.0f, 1.0f, RGBAColorNorm$.MODULE$.apply$default$4());
    }

    private void checkFont() {
        Font font = this._font();
        Font font2 = this.oldFont();
        if (font == null ? font2 != null : !font.equals(font2)) {
            Font newFont = this._font();
            this._font_$eq(this.oldFont());
            this.flush(this.flush$default$1(), this.flush$default$2());
            this._font_$eq(newFont);
            this.oldFont_$eq(this._font());
            return;
        }
    }

    private void _rect(float x, float y, float width, float height, boolean fixUV, Option<Rect2D> spriteRectOptional) {
        Rect2D spriteRect = (Rect2D)spriteRectOptional.getOrElse((Function0<Rect2D> & Serializable)() -> this.spriteRect());
        Transform2D uvTransform = Transform2D$.MODULE$.translate(spriteRect.x(), spriteRect.y()).$greater$greater(fixUV ? Transform2D$.MODULE$.scale(spriteRect.w() - 2.4414062E-4f, spriteRect.h() - 2.4414062E-4f) : Transform2D$.MODULE$.scale(spriteRect.w(), spriteRect.h()));
        Transform2D transform = ((GraphicsState)this.stack().head()).transform().$greater$greater(Transform2D$.MODULE$.translate(x, y)).$greater$greater(Transform2D$.MODULE$.scale(width, height));
        RGBAColorNorm color = ((GraphicsState)this.stack().head()).foreground().toRGBANorm().mapA(x$5 -> x$5 * this.alphaMultiplier());
        if (color.a() > 0.0f) {
            this.renderer().schedule(new MeshInstance2D(color, Color$.MODULE$.Transparent(), transform, uvTransform, Transform2D$.MODULE$.scale(0.0f)));
            return;
        }
    }

    private boolean _rect$default$5() {
        return true;
    }

    private Option<Rect2D> _rect$default$6() {
        return None$.MODULE$;
    }

    public void line(float x1, float y1, float x2, float y2, float thickness, Color color) {
        this.save();
        float dy = x2 - x1;
        float dx = y2 - y1;
        float length = (float)package$.MODULE$.sqrt(dx * dx + dy * dy);
        float inclination = (float)package$.MODULE$.atan2(dy, dx);
        this.translate(x1, y1);
        this.rotate(-inclination + (float)1.5707963267948966);
        this.rect(0.0f, -thickness * 0.5f, length, thickness, color);
        this.restore();
    }

    public void line(Vector2D start, Vector2D end, float thickness, Color color) {
        this.line(start.x(), start.y(), end.x(), end.y(), thickness, color);
    }

    public BufferedImage screenshot() {
        ByteBuffer buffer = BufferUtils.createByteBuffer(this.width() * this.height() * 4);
        GL30.glBindFramebuffer(36160, 0);
        GL11.glReadPixels(0, 0, this.width(), this.height(), 6408, 5121, buffer);
        BufferedImage image = new BufferedImage(this.width(), this.height(), 1);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.height()).foreach$mVc$sp(y -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.width()).foreach$mVc$sp(x -> {
            int i2 = (x + (this.height() - y - 1) * this.width()) * 4;
            int r = buffer.get(i2) & 0xFF;
            int g2 = buffer.get(i2 + 1) & 0xFF;
            int b2 = buffer.get(i2 + 2) & 0xFF;
            int rgb = r << 16 | g2 << 8 | b2;
            image.setRGB(x, y, rgb);
        }));
        return image;
    }

    public void flush(Texture mainTexture, boolean clear) {
        Some some;
        Tuple4 tuple4;
        if (this.renderer().isEmpty() && !clear) {
            return;
        }
        GL30.glBindFramebuffer(36160, this.currentFramebuffer());
        GL11.glEnable(36281);
        GL11.glViewport(0, 0, this.width(), this.height());
        GL11.glDisable(2929);
        GL11.glDisable(2884);
        GL11.glEnable(3042);
        GL11.glBlendFunc(1, 771);
        Option<Tuple4<Object, Object, Object, Object>> option = ((GraphicsState)this.stack().head()).scissor();
        if (option instanceof Some && (tuple4 = (Tuple4)(some = (Some)option).value()) != null) {
            float x = BoxesRunTime.unboxToFloat(tuple4._1());
            float y = BoxesRunTime.unboxToFloat(tuple4._2());
            float w = BoxesRunTime.unboxToFloat(tuple4._3());
            float h2 = BoxesRunTime.unboxToFloat(tuple4._4());
            GL11.glEnable(3089);
            GL11.glScissor(Math.round(x * this.scalingFactor()), Math.round((float)this.height() - h2 * this.scalingFactor() - y * this.scalingFactor()), Math.round(w * this.scalingFactor()), Math.round(h2 * this.scalingFactor()));
        } else {
            GL11.glDisable(3089);
        }
        mainTexture.bind(mainTexture.bind$default$1());
        this._font().texture().bind(1);
        this.renderer().flush();
        if (clear) {
            GL11.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
            GL11.glClear(16384);
            return;
        }
    }

    public Texture flush$default$1() {
        return Spritesheet$.MODULE$.texture();
    }

    public boolean flush$default$2() {
        return false;
    }

    public void update() {
        this.time_$eq(this.time() + UiHandler$.MODULE$.dt() * 20.0f);
    }

    public static final /* synthetic */ float $anonfun$sprite$2(Tuple2 x$3) {
        return BoxesRunTime.unboxToFloat(x$3._2());
    }

    public static final /* synthetic */ boolean $anonfun$sprite$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$sprite$5(Graphics $this, FloatRef timeOffset$1, IntRef curFrame$1, float duration$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            int idx = tuple2._1$mcI$sp();
            float dur = BoxesRunTime.unboxToFloat(tuple2._2());
            timeOffset$1.elem += dur;
            curFrame$1.elem = idx;
            if (timeOffset$1.elem >= $this.time() % duration$1) {
                throw Breaks$.MODULE$.break();
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public Graphics(int width, int height, float scalingFactor) {
        this.width = width;
        this.height = height;
        this.scalingFactor = scalingFactor;
        Logging.$init$(this);
        Resource.$init$(this);
        this.time = 0.0f;
        this.projection = Transform2D$.MODULE$.viewport(this.width(), this.height());
        this.shaderProgram = new ShaderProgram("general");
        this.renderer = new InstanceRenderer(Mesh2D$.MODULE$.quad(), MeshInstance2D$.MODULE$, this.shaderProgram());
        this._font = Font$.MODULE$.NormalFont();
        this.oldFont = this._font();
        this.stack = (Stack)Stack$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new GraphicsState[]{new GraphicsState(GraphicsState$.MODULE$.apply$default$1(), GraphicsState$.MODULE$.apply$default$2(), GraphicsState$.MODULE$.apply$default$3(), GraphicsState$.MODULE$.apply$default$4(), GraphicsState$.MODULE$.apply$default$5(), GraphicsState$.MODULE$.apply$default$6(), GraphicsState$.MODULE$.apply$default$7())}));
        this.spriteRect = Spritesheet$.MODULE$.sprites().apply("Empty");
        this.emptySpriteTrans = Transform2D$.MODULE$.translate(this.spriteRect().x(), this.spriteRect().y()).$greater$greater(Transform2D$.MODULE$.scale(this.spriteRect().w(), this.spriteRect().h()));
        this.offscreenTexture = new Texture(this.width(), this.height(), 35907, 5121, 6408);
        this.offscreenFramebuffer = ARBFramebufferObject.glGenFramebuffers();
        GL30.glBindFramebuffer(36160, this.offscreenFramebuffer());
        GL30.glFramebufferTexture2D(36160, 36064, 3553, this.offscreenTexture().texture(), 0);
        this.currentFramebuffer = 0;
        this.currentScissor = None$.MODULE$;
        this.shaderProgram().set("uTexture", 0);
        this.shaderProgram().set("uTextTexture", 1);
        this.scale(this.scalingFactor());
        this.screenShaderProgram = new ShaderProgram("general");
        this.screenShaderProgram().set("uTexture", 0);
        this.screenShaderProgram().set("uTextTexture", 1);
        Statics.releaseFence();
    }
}

