/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.graphics;

import java.nio.FloatBuffer;
import ocelot.desktop.geometry.ProjectionMatrix3D;
import ocelot.desktop.geometry.Transform2D;
import ocelot.desktop.geometry.Transform3D;
import ocelot.desktop.geometry.Vector3D;
import ocelot.desktop.graphics.Texture;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.Resource;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001\u0002\u000b\u0016\u0001qA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\u0006q\u0001!\t!\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019\u0011\u0005\u0001)A\u0005\u007f!91\t\u0001b\u0001\n\u0013q\u0004B\u0002#\u0001A\u0003%q\bC\u0004F\u0001\t\u0007I\u0011\u0001 \t\r\u0019\u0003\u0001\u0015!\u0003@\u0011\u00159\u0005\u0001\"\u0011I\u0011\u0015a\u0005\u0001\"\u0001I\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015i\u0005\u0001\"\u0001V\u0011\u0015i\u0005\u0001\"\u0001`\u0011\u0015i\u0005\u0001\"\u0001g\u0011\u0015i\u0005\u0001\"\u0001m\u0011\u0015i\u0005\u0001\"\u0001t\u0011\u00159\b\u0001\"\u0001y\u0011\u0015Q\b\u0001\"\u0003|\u0011\u0015i\b\u0001\"\u0003\u007f\u00055\u0019\u0006.\u00193feB\u0013xn\u001a:b[*\u0011acF\u0001\tOJ\f\u0007\u000f[5dg*\u0011\u0001$G\u0001\bI\u0016\u001c8\u000e^8q\u0015\u0005Q\u0012AB8dK2|Go\u0001\u0001\u0014\t\u0001i2%\u000b\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019:\u0012\u0001B;uS2L!\u0001K\u0013\u0003\u000f1{wmZ5oOB\u0011AEK\u0005\u0003W\u0015\u0012\u0001BU3t_V\u00148-Z\u0001\u0005]\u0006lW\r\u0005\u0002/k9\u0011qf\r\t\u0003a}i\u0011!\r\u0006\u0003em\ta\u0001\u0010:p_Rt\u0014B\u0001\u001b \u0003\u0019\u0001&/\u001a3fM&\u0011ag\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Qz\u0012A\u0002\u001fj]&$h\b\u0006\u0002;yA\u00111\bA\u0007\u0002+!)AF\u0001a\u0001[\u0005qaM]1h[\u0016tGo\u00155bI\u0016\u0014X#A \u0011\u0005y\u0001\u0015BA! \u0005\rIe\u000e^\u0001\u0010MJ\fw-\\3oiNC\u0017\rZ3sA\u0005aa/\u001a:uKb\u001c\u0006.\u00193fe\u0006ia/\u001a:uKb\u001c\u0006.\u00193fe\u0002\nQb\u001d5bI\u0016\u0014\bK]8he\u0006l\u0017AD:iC\u0012,'\u000f\u0015:pOJ\fW\u000eI\u0001\rMJ,WMU3t_V\u00148-\u001a\u000b\u0002\u0013B\u0011aDS\u0005\u0003\u0017~\u0011A!\u00168ji\u0006!!-\u001b8e\u0003\r\u0019X\r\u001e\u000b\u0004\u0013>\u0003\u0006\"\u0002\u0017\f\u0001\u0004i\u0003\"B)\f\u0001\u0004\u0011\u0016a\u0002;fqR,(/\u001a\t\u0003wMK!\u0001V\u000b\u0003\u000fQ+\u0007\u0010^;sKR\u0019\u0011JV,\t\u000b1b\u0001\u0019A\u0017\t\u000bac\u0001\u0019A-\u0002\rY,7\r^8s!\tQV,D\u0001\\\u0015\tav#\u0001\u0005hK>lW\r\u001e:z\u0013\tq6L\u0001\u0005WK\u000e$xN]\u001aE)\rI\u0005-\u0019\u0005\u0006Y5\u0001\r!\f\u0005\u0006E6\u0001\raY\u0001\niJ\fgn\u001d4pe6\u0004\"A\u00173\n\u0005\u0015\\&a\u0003+sC:\u001chm\u001c:ne\u0011#2!S4i\u0011\u0015ac\u00021\u0001.\u0011\u0015\u0011g\u00021\u0001j!\tQ&.\u0003\u0002l7\nYAK]1og\u001a|'/\\\u001aE)\rIUN\u001c\u0005\u0006Y=\u0001\r!\f\u0005\u0006_>\u0001\r\u0001]\u0001\u000baJ|'.Z2uS>t\u0007C\u0001.r\u0013\t\u00118L\u0001\nQe>TWm\u0019;j_:l\u0015\r\u001e:jqN\"EcA%uk\")A\u0006\u0005a\u0001[!)a\u000f\u0005a\u0001\u007f\u0005\ta/\u0001\u000bhKR\fE\u000f\u001e:jEV$X\rT8dCRLwN\u001c\u000b\u0003\u007feDQ\u0001L\tA\u00025\n1bZ3u\u0019>\u001c\u0017\r^5p]R\u0011q\b \u0005\u0006YI\u0001\r!L\u0001\rGJ,\u0017\r^3TQ\u0006$WM\u001d\u000b\u0007\u007f}\fy!a\u0005\t\u000f\u0005\u00051\u00031\u0001\u0002\u0004\u000511o\\;sG\u0016\u0004B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013y\u0012AA5p\u0013\u0011\ti!a\u0002\u0003\rM{WO]2f\u0011\u0019\t\tb\u0005a\u0001\u007f\u0005\u0011A/\u001f\u0005\u0007\u0003+\u0019\u0002\u0019A\u0017\u0002\u0003M\u0004")
public class ShaderProgram
implements Logging,
Resource {
    private final int fragmentShader;
    private final int vertexShader;
    private final int shaderProgram;
    private Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int fragmentShader() {
        return this.fragmentShader;
    }

    private int vertexShader() {
        return this.vertexShader;
    }

    public int shaderProgram() {
        return this.shaderProgram;
    }

    @Override
    public void freeResource() {
        Resource.freeResource$(this);
        GL20.glDeleteProgram(this.shaderProgram());
        GL20.glDeleteShader(this.vertexShader());
        GL20.glDeleteShader(this.fragmentShader());
    }

    public void bind() {
        GL20.glUseProgram(this.shaderProgram());
    }

    public void set(String name, Texture texture) {
        this.bind();
        GL20.glUniform1i(this.getLocation(name), texture.texture());
    }

    public void set(String name, Vector3D vector2) {
        this.bind();
        GL20.glUniform3f(this.getLocation(name), vector2.x(), vector2.y(), vector2.z());
    }

    public void set(String name, Transform2D transform) {
        this.bind();
        float[] array = (float[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.floatArrayOps(transform.array()), new float[]{0.0f, 0.0f, 1.0f}, ClassTag$.MODULE$.Float());
        FloatBuffer buffer = BufferUtils.createFloatBuffer(array.length);
        buffer.put(array);
        buffer.flip();
        GL20.glUniformMatrix3(this.getLocation(name), true, buffer);
    }

    public void set(String name, Transform3D transform) {
        this.bind();
        float[] array = (float[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.floatArrayOps(transform.array()), new float[]{0.0f, 0.0f, 0.0f, 1.0f}, ClassTag$.MODULE$.Float());
        FloatBuffer buffer = BufferUtils.createFloatBuffer(array.length);
        buffer.put(array);
        buffer.flip();
        GL20.glUniformMatrix4(this.getLocation(name), true, buffer);
    }

    public void set(String name, ProjectionMatrix3D projection) {
        this.bind();
        FloatBuffer buffer = BufferUtils.createFloatBuffer(projection.array().length);
        buffer.put(projection.array());
        buffer.flip();
        GL20.glUniformMatrix4(this.getLocation(name), true, buffer);
    }

    public void set(String name, int v) {
        this.bind();
        GL20.glUniform1i(this.getLocation(name), v);
    }

    public int getAttributeLocation(String name) {
        this.bind();
        return GL20.glGetAttribLocation(this.shaderProgram(), name);
    }

    private int getLocation(String name) {
        return GL20.glGetUniformLocation(this.shaderProgram(), name);
    }

    private int createShader(Source source, int ty, String s) {
        int shader = GL20.glCreateShader(ty);
        GL20.glShaderSource(shader, source.mkString());
        GL20.glCompileShader(shader);
        int success = GL20.glGetShaderi(shader, 35713);
        if (success == 0) {
            int len2 = GL20.glGetShaderi(shader, 35716);
            String info = GL20.glGetShaderInfoLog(shader, len2);
            this.logger().error(new StringBuilder(28).append("Failed to compile shader (").append(s).append(")\n").append(info).toString());
            throw new RuntimeException("Shader compilation failed");
        }
        source.close();
        return shader;
    }

    public ShaderProgram(String name) {
        Logging.$init$(this);
        Resource.$init$(this);
        this.logger().info(new StringBuilder(25).append("Loading shader program (").append(name).append(")").toString());
        this.fragmentShader = this.createShader(Source$.MODULE$.fromResource(new StringBuilder(27).append("ocelot/desktop/shader/").append(name).append(".frag").toString(), this.getClass().getClassLoader(), Codec$.MODULE$.fallbackSystemCodec()), 35632, "fragment");
        this.vertexShader = this.createShader(Source$.MODULE$.fromResource(new StringBuilder(27).append("ocelot/desktop/shader/").append(name).append(".vert").toString(), this.getClass().getClassLoader(), Codec$.MODULE$.fallbackSystemCodec()), 35633, "vertex");
        this.shaderProgram = GL20.glCreateProgram();
        GL20.glAttachShader(this.shaderProgram(), this.vertexShader());
        GL20.glAttachShader(this.shaderProgram(), this.fragmentShader());
        GL20.glLinkProgram(this.shaderProgram());
        int success = GL20.glGetProgrami(this.shaderProgram(), 35714);
        if (success == 0) {
            int len2 = GL20.glGetProgrami(this.shaderProgram(), 35716);
            String info = GL20.glGetProgramInfoLog(this.shaderProgram(), len2);
            this.logger().error(new StringBuilder(33).append("Failed to link shader program (").append(name).append(")\n").append(info).toString());
            throw new RuntimeException("Shader linkage failed");
        }
        Statics.releaseFence();
    }
}

