/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.graphics;

import java.io.Serializable;
import ocelot.desktop.geometry.Vector3D;
import ocelot.desktop.graphics.ShaderProgram;
import ocelot.desktop.graphics.Texture;
import ocelot.desktop.graphics.mesh.Mesh3D;
import ocelot.desktop.graphics.mesh.MeshInstance3D;
import ocelot.desktop.graphics.mesh.MeshInstance3D$;
import ocelot.desktop.graphics.mesh.MeshVertex3D;
import ocelot.desktop.graphics.render.InstanceRenderer;
import ocelot.desktop.graphics.scene.Scene3D;
import ocelot.desktop.graphics.scene.SceneMesh3D;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.Resource;
import ocelot.desktop.util.Spritesheet$;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\u0010!\u0001\u001dB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\tw\u0001\u0011\t\u0011)A\u0005q!)A\b\u0001C\u0001{!A!\t\u0001b\u0001\n\u0003\u00013\t\u0003\u0004H\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003D\u0011\u0019I\u0005\u0001)A\u0005\t\"9!\n\u0001b\u0001\n\u0013Y\u0005B\u0002'\u0001A\u0003%\u0001(\u0002\u0003N\u0001\u0011q\u0005bB/\u0001\u0005\u0004%IA\u0018\u0005\u0007E\u0002\u0001\u000b\u0011B0\t\u000f\r\u0004!\u0019!C\u0005I\"1!\u000f\u0001Q\u0001\n\u0015Dqa\u001d\u0001C\u0002\u0013%A\u000f\u0003\u0004y\u0001\u0001\u0006I!\u001e\u0005\bs\u0002\u0011\r\u0011\"\u0003{\u0011\u001d\tI\u0001\u0001Q\u0001\nmDq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003k\u0001A\u0011BA\u001c\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!!\u0011\u0001\t\u0013\t\u0019\u0005C\u0004\u0002F\u0001!I!a\u0011\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!9\u0011Q\n\u0001\u0005\n\u0005=\u0003bBA+\u0001\u0011\u0005\u00131\t\u0002\u000b-&,w\u000f]8siN\"%BA\u0011#\u0003!9'/\u00199iS\u000e\u001c(BA\u0012%\u0003\u001d!Wm]6u_BT\u0011!J\u0001\u0007_\u000e,Gn\u001c;\u0004\u0001M!\u0001\u0001\u000b\u00185!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fMB\u0011qFM\u0007\u0002a)\u0011\u0011GI\u0001\u0005kRLG.\u0003\u00024a\tA!+Z:pkJ\u001cW\r\u0005\u00020k%\u0011a\u0007\r\u0002\b\u0019><w-\u001b8h\u0003\u00159\u0018\u000e\u001a;i!\tI\u0013(\u0003\u0002;U\t\u0019\u0011J\u001c;\u0002\r!,\u0017n\u001a5u\u0003\u0019a\u0014N\\5u}Q\u0019a\bQ!\u0011\u0005}\u0002Q\"\u0001\u0011\t\u000b]\u001a\u0001\u0019\u0001\u001d\t\u000bm\u001a\u0001\u0019\u0001\u001d\u0002\u0019Q,\u0007\u0010^;sK\u000e{Gn\u001c:\u0016\u0003\u0011\u0003\"aP#\n\u0005\u0019\u0003#a\u0002+fqR,(/Z\u0001\u000ei\u0016DH/\u001e:f\u0007>dwN\u001d\u0011\u0002\u0019Q,\u0007\u0010^;sK\u0012+\u0007\u000f\u001e5\u0002\u001bQ,\u0007\u0010^;sK\u0012+\u0007\u000f\u001e5!\u0003-1'/Y7fEV4g-\u001a:\u0016\u0003a\nAB\u001a:b[\u0016\u0014WO\u001a4fe\u0002\u0012\u0011\"\u00138ti\u0006t7-\u001a:\u0011\t=\u0013FKW\u0007\u0002!*\u0011\u0011\u000bI\u0001\u0007e\u0016tG-\u001a:\n\u0005M\u0003&\u0001E%ogR\fgnY3SK:$WM]3s!\t)\u0006,D\u0001W\u0015\t9\u0006%\u0001\u0003nKND\u0017BA-W\u00051iUm\u001d5WKJ$X\r_\u001aE!\t)6,\u0003\u0002]-\nqQ*Z:i\u0013:\u001cH/\u00198dKN\"\u0015!D:iC\u0012,'\u000f\u0015:pOJ\fW.F\u0001`!\ty\u0004-\u0003\u0002bA\ti1\u000b[1eKJ\u0004&o\\4sC6\fab\u001d5bI\u0016\u0014\bK]8he\u0006l\u0007%\u0001\u0006j]N$\u0018M\\2feN,\u0012!\u001a\t\u0005M.l\u0007/D\u0001h\u0015\tA\u0017.A\u0004nkR\f'\r\\3\u000b\u0005)T\u0013AC2pY2,7\r^5p]&\u0011An\u001a\u0002\b\u0011\u0006\u001c\b.T1q!\t)f.\u0003\u0002p-\n1Q*Z:ig\u0011\u0003\"!\u001d\u0006\u000e\u0003\u0001\t1\"\u001b8ti\u0006t7-\u001a:tA\u0005QQo]3e\u001b\u0016\u001c\b.Z:\u0016\u0003U\u00042A\u001a<n\u0013\t9xMA\u0004ICND7+\u001a;\u0002\u0017U\u001cX\rZ'fg\",7\u000fI\u0001\u0011iJ\fgn\u001d9be\u0016tGOT8eKN,\u0012a\u001f\t\u0004Mrt\u0018BA?h\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0011\u0002\u000bM\u001cWM\\3\n\t\u0005\u001d\u0011\u0011\u0001\u0002\f'\u000e,g.Z'fg\"\u001cD)A\tue\u0006t7\u000f]1sK:$hj\u001c3fg\u0002\nA\u0001\u001a:boR!\u0011qBA\u000b!\rI\u0013\u0011C\u0005\u0004\u0003'Q#\u0001B+oSRDq!a\u0001\u0014\u0001\u0004\t9\u0002E\u0002\u0000\u00033IA!a\u0007\u0002\u0002\t91kY3oKN\"\u0015aC:fiV\u00048)Y7fe\u0006$B!a\u0004\u0002\"!9\u00111\u0001\u000bA\u0002\u0005]\u0011AC:fiV\u0004H*[4iiR!\u0011qBA\u0014\u0011\u001d\t\u0019!\u0006a\u0001\u0003/\tQbY8mY\u0016\u001cGo\u00149bcV,G\u0003BA\b\u0003[Aq!a\u0001\u0017\u0001\u0004\t9\"\u0001\nd_2dWm\u0019;Ue\u0006t7\u000f]1sK:$H\u0003BA\b\u0003gAq!a\u0001\u0018\u0001\u0004\t9\"\u0001\u0006t_J$x\n]1rk\u0016$B!a\u0004\u0002:!9\u00111\u0001\rA\u0002\u0005]\u0011aD:peR$&/\u00198ta\u0006\u0014XM\u001c;\u0015\t\u0005=\u0011q\b\u0005\b\u0003\u0007I\u0002\u0019AA\f\u0003)!'/Y<Pa\u0006\fX/\u001a\u000b\u0003\u0003\u001f\tq\u0002\u001a:boR\u0013\u0018M\\:qCJ,g\u000e^\u0001\rO\u0016$\u0018J\\:uC:\u001cWM\u001d\u000b\u0004a\u0006-\u0003\"B,\u001d\u0001\u0004i\u0017A\u00048pI\u0016$v.\u00138ti\u0006t7-\u001a\u000b\u00045\u0006E\u0003BBA*;\u0001\u0007a0\u0001\u0003o_\u0012,\u0017\u0001\u00044sK\u0016\u0014Vm]8ve\u000e,\u0007")
public class Viewport3D
implements Resource,
Logging {
    private final int width;
    private final int height;
    private final Texture textureColor;
    private final Texture textureDepth;
    private final int framebuffer;
    private final ShaderProgram shaderProgram;
    private final HashMap<Mesh3D, InstanceRenderer<MeshVertex3D, MeshInstance3D>> instancers;
    private final HashSet<Mesh3D> usedMeshes;
    private final ArrayBuffer<SceneMesh3D> transparentNodes;
    private Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Texture textureColor() {
        return this.textureColor;
    }

    private Texture textureDepth() {
        return this.textureDepth;
    }

    private int framebuffer() {
        return this.framebuffer;
    }

    private ShaderProgram shaderProgram() {
        return this.shaderProgram;
    }

    private HashMap<Mesh3D, InstanceRenderer<MeshVertex3D, MeshInstance3D>> instancers() {
        return this.instancers;
    }

    private HashSet<Mesh3D> usedMeshes() {
        return this.usedMeshes;
    }

    private ArrayBuffer<SceneMesh3D> transparentNodes() {
        return this.transparentNodes;
    }

    public void draw(Scene3D scene) {
        this.usedMeshes().clear();
        this.setupCamera(scene);
        this.setupLight(scene);
        this.collectOpaque(scene);
        this.collectTransparent(scene);
        this.sortOpaque(scene);
        this.sortTransparent(scene);
        GL30.glBindFramebuffer(36160, this.framebuffer());
        GL11.glEnable(36281);
        GL11.glViewport(0, 0, this.width, this.height);
        GL11.glDisable(3089);
        GL11.glEnable(2884);
        GL11.glEnable(2929);
        GL11.glDepthFunc(515);
        GL11.glEnable(3042);
        GL11.glBlendFunc(1, 771);
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        GL11.glClearDepth(1.0);
        GL11.glClear(16640);
        Texture qual$1 = Spritesheet$.MODULE$.texture();
        int x$1 = qual$1.bind$default$1();
        qual$1.bind(x$1);
        this.drawOpaque();
        GL11.glDisable(2884);
        GL11.glColorMask(false, false, false, false);
        this.drawTransparent();
        GL11.glColorMask(true, true, true, true);
        GL11.glDepthMask(false);
        this.drawTransparent();
        GL11.glDepthMask(true);
        this.instancers().filterInPlace((Function2<Mesh3D, InstanceRenderer, Object> & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean(Viewport3D.$anonfun$draw$1(this, x0$1, x1$1)));
    }

    private void setupCamera(Scene3D scene) {
        this.shaderProgram().set("uView", scene.camera().transform().inverse());
        this.shaderProgram().set("uProj", scene.camera().projectionMatrix((float)this.width / (float)this.height));
    }

    private void setupLight(Scene3D scene) {
        this.shaderProgram().set("uLightDir", scene.lightSource().basis().up());
        this.shaderProgram().set("uLightColor", scene.lightSource().color().toRGBANorm().toLinear().rgbVector().$times(scene.lightSource().energy()));
        this.shaderProgram().set("uAmbientLightColor", scene.ambientLightColor().toRGBANorm().toLinear().rgbVector().$times(scene.ambientLightEnergy()));
    }

    private void collectOpaque(Scene3D scene) {
        scene.meshes().iterator().filter((Function1<SceneMesh3D, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isOpaque())).foreach((Function1<SceneMesh3D, Object> & Serializable)node -> {
            Viewport3D.$anonfun$collectOpaque$2(this, node);
            return BoxedUnit.UNIT;
        });
    }

    private void collectTransparent(Scene3D scene) {
        this.transparentNodes().clear();
        scene.meshes().iterator().filter((Function1<SceneMesh3D, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(Viewport3D.$anonfun$collectTransparent$1(x$2))).foreach((Function1<SceneMesh3D, ArrayBuffer> & Serializable)node -> {
            this.usedMeshes().$plus$eq(node.mesh());
            return (ArrayBuffer)this.transparentNodes().append((SceneMesh3D)node);
        });
    }

    private void sortOpaque(Scene3D scene) {
        ((IterableOps.WithFilter)this.instancers().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(Viewport3D.$anonfun$sortOpaque$1(check$ifrefutable$1)))).foreach((Function1<Tuple2, Object> & Serializable)x$3 -> {
            Viewport3D.$anonfun$sortOpaque$2(scene, x$3);
            return BoxedUnit.UNIT;
        });
    }

    private void sortTransparent(Scene3D scene) {
        this.transparentNodes().sortWith((Function2<SceneMesh3D, SceneMesh3D, Object> & Serializable)(a2, b2) -> BoxesRunTime.boxToBoolean(Viewport3D.$anonfun$sortTransparent$1(scene, a2, b2)));
    }

    private void drawOpaque() {
        this.instancers().values().foreach((Function1<InstanceRenderer, Object> & Serializable)x$4 -> {
            x$4.flush();
            return BoxedUnit.UNIT;
        });
    }

    private void drawTransparent() {
        int i2 = 0;
        while (i2 < this.transparentNodes().length()) {
            SceneMesh3D node = this.transparentNodes().apply(i2);
            ++i2;
            InstanceRenderer<MeshVertex3D, MeshInstance3D> instancer = this.getInstancer(node.mesh());
            instancer.schedule(this.nodeToInstance(node));
            while (i2 < this.transparentNodes().length()) {
                Mesh3D mesh3D = this.transparentNodes().apply(i2).mesh();
                Mesh3D mesh3D2 = node.mesh();
                if (mesh3D != null ? !mesh3D.equals(mesh3D2) : mesh3D2 != null) break;
                SceneMesh3D similarNode = this.transparentNodes().apply(i2);
                instancer.schedule(this.nodeToInstance(similarNode));
                ++i2;
            }
            instancer.flush();
        }
    }

    private InstanceRenderer<MeshVertex3D, MeshInstance3D> getInstancer(Mesh3D mesh) {
        return this.instancers().getOrElseUpdate(mesh, (Function0<InstanceRenderer<MeshVertex3D, MeshInstance3D>>)(Function0<InstanceRenderer> & Serializable)() -> new InstanceRenderer(mesh, MeshInstance3D$.MODULE$, this.shaderProgram()));
    }

    private MeshInstance3D nodeToInstance(SceneMesh3D node) {
        return new MeshInstance3D(node.color().toRGBANorm(), node.transform(), node.uvTransform(), node.lightingFactor(), node.textureFactor());
    }

    @Override
    public void freeResource() {
        Resource.freeResource$(this);
        this.textureColor().freeResource();
        this.textureDepth().freeResource();
        this.shaderProgram().freeResource();
        this.instancers().values().foreach((Function1<InstanceRenderer, Object> & Serializable)x$5 -> {
            x$5.freeResource();
            return BoxedUnit.UNIT;
        });
        ARBFramebufferObject.glDeleteFramebuffers(this.framebuffer());
    }

    public static final /* synthetic */ boolean $anonfun$draw$1(Viewport3D $this, Mesh3D x0$1, InstanceRenderer x1$1) {
        Tuple2<Mesh3D, InstanceRenderer> tuple2 = new Tuple2<Mesh3D, InstanceRenderer>(x0$1, x1$1);
        if (tuple2 != null) {
            Mesh3D mesh = tuple2._1();
            InstanceRenderer instancer = tuple2._2();
            boolean retain = $this.usedMeshes().contains(mesh);
            if (!retain) {
                instancer.freeResource();
            }
            return retain;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$collectOpaque$2(Viewport3D $this, SceneMesh3D node) {
        InstanceRenderer<MeshVertex3D, MeshInstance3D> instancer = $this.getInstancer(node.mesh());
        $this.usedMeshes().$plus$eq(node.mesh());
        instancer.schedule($this.nodeToInstance(node));
    }

    public static final /* synthetic */ boolean $anonfun$collectTransparent$1(SceneMesh3D x$2) {
        return !x$2.isOpaque();
    }

    public static final /* synthetic */ boolean $anonfun$sortOpaque$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$sortOpaque$3(Scene3D scene$1, Vector3D meshCenter$1, MeshInstance3D a2, MeshInstance3D b2) {
        float bDist;
        float aDist = scene$1.camera().distanceTo(a2.transform().$times(meshCenter$1));
        return aDist < (bDist = scene$1.camera().distanceTo(b2.transform().$times(meshCenter$1)));
    }

    public static final /* synthetic */ void $anonfun$sortOpaque$2(Scene3D scene$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            Mesh3D mesh = (Mesh3D)tuple2._1();
            InstanceRenderer instancer = (InstanceRenderer)tuple2._2();
            Vector3D meshCenter = mesh.boundingBox().center();
            instancer.sort((Function2<MeshInstance3D, MeshInstance3D, Object> & Serializable)(a2, b2) -> BoxesRunTime.boxToBoolean(Viewport3D.$anonfun$sortOpaque$3(scene$1, meshCenter, a2, b2)));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$sortTransparent$1(Scene3D scene$2, SceneMesh3D a2, SceneMesh3D b2) {
        float aDist = scene$2.camera().distanceTo(a2.transform().$times(a2.mesh().boundingBox().center()));
        float bDist = scene$2.camera().distanceTo(b2.transform().$times(b2.mesh().boundingBox().center()));
        return a2.priority() < b2.priority() || aDist > bDist;
    }

    public Viewport3D(int width, int height) {
        this.width = width;
        this.height = height;
        Resource.$init$(this);
        Logging.$init$(this);
        this.textureColor = new Texture(width, height, 35905, 5121, 6407);
        this.textureDepth = new Texture(width, height, 6402, 5126);
        this.framebuffer = ARBFramebufferObject.glGenFramebuffers();
        GL30.glBindFramebuffer(36160, this.framebuffer());
        GL30.glFramebufferTexture2D(36160, 36064, 3553, this.textureColor().texture(), 0);
        GL30.glFramebufferTexture2D(36160, 36096, 3553, this.textureDepth().texture(), 0);
        GL30.glBindFramebuffer(36160, 0);
        this.shaderProgram = new ShaderProgram("general_3d");
        this.shaderProgram().set("uTexture", 0);
        this.instancers = new HashMap();
        this.usedMeshes = new HashSet();
        this.transparentNodes = new ArrayBuffer();
        Statics.releaseFence();
    }
}

