/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.ui.widget;

import ocelot.desktop.ColorScheme$;
import ocelot.desktop.color.Color;
import ocelot.desktop.color.Color$;
import ocelot.desktop.graphics.Graphics;
import ocelot.desktop.graphics.IconSource$;
import ocelot.desktop.ui.widget.Widget;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.FloatRef;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000554Aa\u0004\t\u00013!)a\u0004\u0001C\u0001?!9\u0011\u0005\u0001a\u0001\n\u0003\u0011\u0003bB\u0016\u0001\u0001\u0004%\t\u0001\f\u0005\u0007k\u0001\u0001\u000b\u0015B\u0012\t\u000fY\u0002\u0001\u0019!C\u0001E!9q\u0007\u0001a\u0001\n\u0003A\u0004B\u0002\u001e\u0001A\u0003&1\u0005C\u0004<\u0001\u0001\u0007I\u0011\u0001\u001f\t\u000f!\u0003\u0001\u0019!C\u0001\u0013\"11\n\u0001Q!\nuBQ\u0001\u0014\u0001\u0005\n5CQA\u0016\u0001\u0005\n]CQa\u001a\u0001\u0005\n!DQA\u001b\u0001\u0005B-\u0014\u0011\u0002S5ti><'/Y7\u000b\u0005E\u0011\u0012AB<jI\u001e,GO\u0003\u0002\u0014)\u0005\u0011Q/\u001b\u0006\u0003+Y\tq\u0001Z3tWR|\u0007OC\u0001\u0018\u0003\u0019y7-\u001a7pi\u000e\u00011C\u0001\u0001\u001b!\tYB$D\u0001\u0011\u0013\ti\u0002C\u0001\u0004XS\u0012<W\r^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"a\u0007\u0001\u0002\u000bY\fG.^3\u0016\u0003\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\t1\fgn\u001a\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0004TiJLgnZ\u0001\nm\u0006dW/Z0%KF$\"!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\tUs\u0017\u000e\u001e\u0005\bi\r\t\t\u00111\u0001$\u0003\rAH%M\u0001\u0007m\u0006dW/\u001a\u0011\u0002\u000bQLG\u000f\\3\u0002\u0013QLG\u000f\\3`I\u0015\fHCA\u0017:\u0011\u001d!d!!AA\u0002\r\na\u0001^5uY\u0016\u0004\u0013a\u00025jgR|'/_\u000b\u0002{A\u0019ahQ#\u000e\u0003}R!\u0001Q!\u0002\u000f5,H/\u00192mK*\u0011!iL\u0001\u000bG>dG.Z2uS>t\u0017B\u0001#@\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u000592\u0015BA$0\u0005\u00151En\\1u\u0003-A\u0017n\u001d;pef|F%Z9\u0015\u00055R\u0005b\u0002\u001b\n\u0003\u0003\u0005\r!P\u0001\tQ&\u001cHo\u001c:zA\u0005AAM]1x\u0005\u0006\u00148\u000f\u0006\u0002.\u001d\")qj\u0003a\u0001!\u0006\tq\r\u0005\u0002R)6\t!K\u0003\u0002T)\u0005AqM]1qQ&\u001c7/\u0003\u0002V%\nAqI]1qQ&\u001c7/\u0001\u0005ee\u0006<H+\u001a=u)\u0011i\u0003,W.\t\u000b=c\u0001\u0019\u0001)\t\u000bic\u0001\u0019A#\u0002\u0003aDQ\u0001\u0018\u0007A\u0002u\u000bA\u0001^3yiB\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001Y\u0018\u000e\u0003\u0005T!A\u0019\r\u0002\rq\u0012xn\u001c;?\u0013\t!w&\u0001\u0004Qe\u0016$WMZ\u0005\u0003U\u0019T!\u0001Z\u0018\u0002\u001b\u0011\u0014\u0018m\u001e%jgR|wM]1n)\ti\u0013\u000eC\u0003P\u001b\u0001\u0007\u0001+\u0001\u0003ee\u0006<HCA\u0017m\u0011\u0015ye\u00021\u0001Q\u0001")
public class Histogram
extends Widget {
    private String value = "N/A";
    private String title = "Hello world";
    private ArrayBuffer<Object> history = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapFloatArray(new float[]{50.0f}));

    public String value() {
        return this.value;
    }

    public void value_$eq(String x$1) {
        this.value = x$1;
    }

    public String title() {
        return this.title;
    }

    public void title_$eq(String x$1) {
        this.title = x$1;
    }

    public ArrayBuffer<Object> history() {
        return this.history;
    }

    public void history_$eq(ArrayBuffer<Object> x$1) {
        this.history = x$1;
    }

    private void drawBars(Graphics g2) {
        float ratio = BoxesRunTime.unboxToFloat(this.history().last());
        int fillBars = RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper(ratio * (float)10));
        int emptyBars = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(9 - fillBars), 0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), emptyBars).foreach$mVc$sp(i2 -> this.drawBarSegment$1(i2, ColorScheme$.MODULE$.apply("HistogramBarEmpty"), g2));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(emptyBars + 1), 10).foreach$mVc$sp(i2 -> this.drawBarSegment$1(i2, ColorScheme$.MODULE$.apply("HistogramBarFill"), g2));
        this.drawBarSegment$1(emptyBars, ColorScheme$.MODULE$.apply("HistogramBarTop"), g2);
        this.drawText(g2, this.position().x() + (float)17, this.value());
    }

    private void drawText(Graphics g2, float x, String text) {
        g2.setSmallFont();
        g2.background_$eq(Color$.MODULE$.Transparent());
        g2.text(x - (float)(text.length() * 4), this.position().y() + (float)62, text, g2.text$default$4());
        g2.setNormalFont();
    }

    private void drawHistogram(Graphics g2) {
        int marginLeft = 41;
        int marginBottom = 12;
        FloatRef x = FloatRef.create(this.position().x() + (float)marginLeft);
        float cellThickness = 2.0f;
        float cellSize = 11.0f;
        int horizontalLineCount = (int)((this.height() - cellThickness - (float)marginBottom) / cellSize);
        int verticalLineCount = (int)((this.width() - cellThickness - (float)marginLeft) / cellSize);
        float gridWidth = (float)verticalLineCount * cellSize;
        float gridHeight = (float)horizontalLineCount * cellSize;
        this.drawText(g2, x.elem + gridWidth / (float)2, this.title());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), horizontalLineCount + 1).foreach$mVc$sp(i2 -> g2.rect(x$1.elem, this.position().y() + (float)i2 * cellSize, gridWidth, cellThickness, ColorScheme$.MODULE$.apply("HistogramGrid")));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), verticalLineCount + 1).foreach$mVc$sp(i2 -> {
            boolean lesserThenPreLast = i2 < verticalLineCount - 1;
            g2.rect(x$1.elem, this.position().y(), cellThickness, lesserThenPreLast ? gridHeight : gridHeight + cellThickness, ColorScheme$.MODULE$.apply("HistogramGrid"));
            int historyIndex = this.history().length() - verticalLineCount + i2 - 1;
            float historyValueWidth = i2 < verticalLineCount ? cellSize : cellThickness;
            float historyValueHeight = cellThickness;
            if (historyIndex > 0) {
                float historyValue = BoxesRunTime.unboxToFloat(this.history().apply(historyIndex));
                historyValueHeight = RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(historyValue * (gridHeight + cellThickness)), cellThickness);
                g2.rect(x$1.elem, this.position().y() + gridHeight + cellThickness - historyValueHeight, historyValueWidth, historyValueHeight, ColorScheme$.MODULE$.apply("HistogramFill"));
            }
            g2.rect(x$1.elem, this.position().y() + gridHeight + cellThickness - historyValueHeight, historyValueWidth, cellThickness, ColorScheme$.MODULE$.apply("HistogramEdge"));
            x$1.elem += cellSize;
        });
    }

    @Override
    public void draw(Graphics g2) {
        this.drawBars(g2);
        this.drawHistogram(g2);
    }

    private final void drawBarSegment$1(int i2, Color color, Graphics g$1) {
        g$1.sprite(IconSource$.MODULE$.BarSegment(), this.position().x(), this.position().y() + (float)(i2 * 6), 16.0f, 4.0f, color);
        g$1.sprite(IconSource$.MODULE$.BarSegment(), this.position().x() + (float)18, this.position().y() + (float)(i2 * 6), 16.0f, 4.0f, color);
    }
}

