/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.util;

import java.io.Serializable;
import ocelot.desktop.util.Profiler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class Profiler$ {
    public static final Profiler$ MODULE$ = new Profiler$();
    private static final HashMap<String, Profiler.TimeEntry> timeEntries = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);

    private HashMap<String, Profiler.TimeEntry> timeEntries() {
        return timeEntries;
    }

    public void measure(String name, Function0<BoxedUnit> f2) {
        this.startTimeMeasurement(name);
        try {
            f2.apply$mcV$sp();
        }
        finally {
            this.endTimeMeasurement(name);
        }
    }

    private void startTimeMeasurement(String name) {
        Profiler.TimeEntry entry = this.timeEntries().getOrElseUpdate(name, (Function0<Profiler.TimeEntry> & Serializable)() -> new Profiler.TimeEntry());
        entry.startTime_$eq((double)System.nanoTime() / 1.0E9);
    }

    private void endTimeMeasurement(String name) {
        Profiler.TimeEntry entry = this.timeEntries().getOrElseUpdate(name, (Function0<Profiler.TimeEntry> & Serializable)() -> new Profiler.TimeEntry());
        entry.addSample((double)System.nanoTime() / 1.0E9 - entry.startTime());
    }

    public String[] report() {
        ObjectRef<String[]> res = ObjectRef.create((String[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        int width = BoxesRunTime.unboxToInt(((IterableOnceOps)this.timeEntries().map((Function1<Tuple2, Object> & Serializable)x$1 -> BoxesRunTime.boxToInteger(Profiler$.$anonfun$report$1(x$1)))).max(Ordering$Int$.MODULE$));
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.reverse$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])this.timeEntries().iterator().toArray(ClassTag$.MODULE$.apply(Tuple2.class))), (Function1<Tuple2, String> & Serializable)x$2 -> (String)x$2._1(), Ordering$String$.MODULE$)))), (Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(Profiler$.$anonfun$report$3(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$4 -> {
            Profiler$.$anonfun$report$4(res, width, x$4);
            return BoxedUnit.UNIT;
        });
        return (String[])res.elem;
    }

    private String formatTime(double v) {
        Tuple2<String, Double> unit = v < 1.0E-6 ? new Tuple2<String, Double>("ns", BoxesRunTime.boxToDouble(1.0E-9)) : (v < 0.001 ? new Tuple2<String, Double>("us", BoxesRunTime.boxToDouble(1.0E-6)) : (v < 1.0 ? new Tuple2<String, Double>("ms", BoxesRunTime.boxToDouble(0.001)) : new Tuple2<String, Double>("s", BoxesRunTime.boxToDouble(1.0))));
        return StringOps$.MODULE$.format$extension("%6.2f %s", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(v / unit._2$mcD$sp()), unit._1()}));
    }

    public static final /* synthetic */ int $anonfun$report$1(Tuple2 x$1) {
        return ((String)x$1._1()).length();
    }

    public static final /* synthetic */ boolean $anonfun$report$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$report$4(ObjectRef res$1, int width$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            Profiler.TimeEntry entry = (Profiler.TimeEntry)tuple2._2();
            Tuple3<Object, Object, Object> tuple3 = entry.percentiles();
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            double p5 = BoxesRunTime.unboxToDouble(tuple3._1());
            double p50 = BoxesRunTime.unboxToDouble(tuple3._2());
            double p95 = BoxesRunTime.unboxToDouble(tuple3._3());
            Tuple3<Double, Double, Double> tuple32 = new Tuple3<Double, Double, Double>(BoxesRunTime.boxToDouble(p5), BoxesRunTime.boxToDouble(p50), BoxesRunTime.boxToDouble(p95));
            double p52 = BoxesRunTime.unboxToDouble(tuple32._1());
            double p502 = BoxesRunTime.unboxToDouble(tuple32._2());
            double p952 = BoxesRunTime.unboxToDouble(tuple32._3());
            res$1.elem = (String[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((String[])res$1.elem), new StringBuilder(28).append(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(name), width$1, ' ')).append(" \u2502 5% ").append(MODULE$.formatTime(p52)).append(" \u2502 50% ").append(MODULE$.formatTime(p502)).append(" \u2502 95% ").append(MODULE$.formatTime(p952)).append(" \u2502 last ").append(MODULE$.formatTime(entry.lastSample())).toString(), ClassTag$.MODULE$.apply(String.class));
            return;
        }
        throw new MatchError(tuple2);
    }

    private Profiler$() {
    }
}

