/*
 * Decompiled with CFR 0.152.
 */
package ocelot.desktop.util;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URL;
import javax.imageio.ImageIO;
import ocelot.desktop.geometry.Rect2D;
import ocelot.desktop.geometry.Size2D;
import ocelot.desktop.geometry.Size2D$;
import ocelot.desktop.graphics.IconSource;
import ocelot.desktop.graphics.Texture;
import ocelot.desktop.util.Logging;
import ocelot.desktop.util.Resource;
import org.apache.logging.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.mutable.HashMap;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;

public final class Spritesheet$
implements Resource,
Logging {
    public static final Spritesheet$ MODULE$ = new Spritesheet$();
    private static final HashMap<String, Rect2D> sprites;
    private static Texture texture;
    private static Size2D resolution;
    private static Logger logger;

    static {
        Resource.$init$(MODULE$);
        Logging.$init$(MODULE$);
        sprites = new HashMap();
    }

    @Override
    public Logger logger() {
        return logger;
    }

    @Override
    public void ocelot$desktop$util$Logging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public HashMap<String, Rect2D> sprites() {
        return sprites;
    }

    public Texture texture() {
        return texture;
    }

    public void texture_$eq(Texture x$1) {
        texture = x$1;
    }

    private Size2D resolution() {
        return resolution;
    }

    private void resolution_$eq(Size2D x$1) {
        resolution = x$1;
    }

    public Size2D spriteSize(String sprite) {
        return this.sprites().apply(sprite).size().$times(this.resolution());
    }

    public Size2D spriteSize(IconSource icon) {
        Option<IconSource.Animation> option = icon.animation();
        if (option instanceof Some) {
            Some some = (Some)option;
            IconSource.Animation animation = (IconSource.Animation)some.value();
            Option<Size2D> option2 = animation.frameSize();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Size2D size = (Size2D)some2.value();
                return size;
            }
            if (None$.MODULE$.equals(option2)) {
                Size2D size = this.spriteSize(icon.path());
                return new Size2D(size.width(), size.width());
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return this.spriteSize(icon.path());
        }
        throw new MatchError(option);
    }

    public void load() {
        this.logger().info("Loading sprites...");
        URL imageURL = this.getClass().getResource("/ocelot/desktop/images/spritesheet/spritesheet.png");
        BufferedImage image = ImageIO.read(imageURL);
        this.texture_$eq(new Texture(image));
        this.resolution_$eq(Size2D$.MODULE$.apply(image.getWidth(), image.getHeight()));
        BufferedSource txt = Source$.MODULE$.fromURL(this.getClass().getResource("/ocelot/desktop/images/spritesheet/spritesheet.txt"), Codec$.MODULE$.fallbackSystemCodec());
        txt.getLines().foreach((Function1<String, HashMap> & Serializable)line -> {
            String[] split = line.split("\\s+");
            return (HashMap)MODULE$.sprites().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps(split))), new Rect2D(StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(split[1])) / MODULE$.resolution().width(), StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(split[2])) / MODULE$.resolution().height(), StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(split[3])) / MODULE$.resolution().width(), StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(split[4])) / MODULE$.resolution().height())));
        });
        txt.close();
        this.logger().info(new StringBuilder(15).append("Loaded ").append(this.sprites().size()).append(" sprites").toString());
    }

    @Override
    public void freeResource() {
        Resource.freeResource$(this);
        this.texture().freeResource();
    }

    private Spritesheet$() {
    }
}

