/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import java.util.Arrays;
import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;

public class Sigmoid
implements UnivariateDifferentiableFunction,
DifferentiableUnivariateFunction {
    private final double lo;
    private final double hi;

    public Sigmoid() {
        this(0.0, 1.0);
    }

    public Sigmoid(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    @Deprecated
    public UnivariateFunction derivative() {
        return FunctionUtils.toDifferentiableUnivariateFunction(this).derivative();
    }

    public double value(double x) {
        return Sigmoid.value(x, this.lo, this.hi);
    }

    private static double value(double x, double lo, double hi) {
        return lo + (hi - lo) / (1.0 + FastMath.exp(-x));
    }

    public DerivativeStructure value(DerivativeStructure t) throws DimensionMismatchException {
        double[] f2 = new double[t.getOrder() + 1];
        double exp2 = FastMath.exp(-t.getValue());
        if (Double.isInfinite(exp2)) {
            f2[0] = this.lo;
            Arrays.fill(f2, 1, f2.length, 0.0);
        } else {
            double[] p = new double[f2.length];
            double inv = 1.0 / (1.0 + exp2);
            double coeff = this.hi - this.lo;
            for (int n2 = 0; n2 < f2.length; ++n2) {
                double v = 0.0;
                p[n2] = 1.0;
                for (int k2 = n2; k2 >= 0; --k2) {
                    v = v * exp2 + p[k2];
                    if (k2 > 1) {
                        p[k2 - 1] = (double)(n2 - k2 + 2) * p[k2 - 2] - (double)(k2 - 1) * p[k2 - 1];
                        continue;
                    }
                    p[0] = 0.0;
                }
                f2[n2] = (coeff *= inv) * v;
            }
            f2[0] = f2[0] + this.lo;
        }
        return t.compose(f2);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double x, double ... param2) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param2);
            return Sigmoid.value(x, param2[0], param2[1]);
        }

        public double[] gradient(double x, double ... param2) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(param2);
            double invExp1 = 1.0 / (1.0 + FastMath.exp(-x));
            return new double[]{1.0 - invExp1, invExp1};
        }

        private void validateParameters(double[] param2) throws NullArgumentException, DimensionMismatchException {
            if (param2 == null) {
                throw new NullArgumentException();
            }
            if (param2.length != 2) {
                throw new DimensionMismatchException(param2.length, 2);
            }
        }
    }
}

