/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.util.FastMath;

public class MullerSolver2
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public MullerSolver2() {
        this(1.0E-6);
    }

    public MullerSolver2(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public MullerSolver2(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    protected double doSolve() throws TooManyEvaluationsException, NumberIsTooLargeException, NoBracketingException {
        double min2 = this.getMin();
        double max2 = this.getMax();
        this.verifyInterval(min2, max2);
        double relativeAccuracy = this.getRelativeAccuracy();
        double absoluteAccuracy = this.getAbsoluteAccuracy();
        double functionValueAccuracy = this.getFunctionValueAccuracy();
        double x0 = min2;
        double y0 = this.computeObjectiveValue(x0);
        if (FastMath.abs(y0) < functionValueAccuracy) {
            return x0;
        }
        double x1 = max2;
        double y1 = this.computeObjectiveValue(x1);
        if (FastMath.abs(y1) < functionValueAccuracy) {
            return x1;
        }
        if (y0 * y1 > 0.0) {
            throw new NoBracketingException(x0, x1, y0, y1);
        }
        double x2 = 0.5 * (x0 + x1);
        double y2 = this.computeObjectiveValue(x2);
        double oldx = Double.POSITIVE_INFINITY;
        while (true) {
            double x;
            double denominator;
            double c2;
            double a2;
            double q;
            double b2;
            double delta;
            if ((delta = (b2 = (2.0 * (q = (x2 - x1) / (x1 - x0)) + 1.0) * y2 - (1.0 + q) * (1.0 + q) * y1 + q * q * y0) * b2 - 4.0 * (a2 = q * (y2 - (1.0 + q) * y1 + q * y0)) * (c2 = (1.0 + q) * y2)) >= 0.0) {
                double dplus = b2 + FastMath.sqrt(delta);
                double dminus = b2 - FastMath.sqrt(delta);
                denominator = FastMath.abs(dplus) > FastMath.abs(dminus) ? dplus : dminus;
            } else {
                denominator = FastMath.sqrt(b2 * b2 - delta);
            }
            if (denominator != 0.0) {
                for (x = x2 - 2.0 * c2 * (x2 - x1) / denominator; x == x1 || x == x2; x += absoluteAccuracy) {
                }
            } else {
                x = min2 + FastMath.random() * (max2 - min2);
                oldx = Double.POSITIVE_INFINITY;
            }
            double y = this.computeObjectiveValue(x);
            double tolerance = FastMath.max(relativeAccuracy * FastMath.abs(x), absoluteAccuracy);
            if (FastMath.abs(x - oldx) <= tolerance || FastMath.abs(y) <= functionValueAccuracy) {
                return x;
            }
            x0 = x1;
            y0 = y1;
            x1 = x2;
            y1 = y2;
            x2 = x;
            y2 = y;
            oldx = x;
        }
    }
}

