/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.spherical.oned;

import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.geometry.partitioning.Region;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

public class Arc {
    private final double lower;
    private final double upper;
    private final double middle;
    private final double tolerance;

    public Arc(double lower2, double upper2, double tolerance) throws NumberIsTooLargeException {
        this.tolerance = tolerance;
        if (Precision.equals(lower2, upper2, 0) || upper2 - lower2 >= Math.PI * 2) {
            this.lower = 0.0;
            this.upper = Math.PI * 2;
            this.middle = Math.PI;
        } else if (lower2 <= upper2) {
            this.lower = MathUtils.normalizeAngle(lower2, Math.PI);
            this.upper = this.lower + (upper2 - lower2);
            this.middle = 0.5 * (this.lower + this.upper);
        } else {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.ENDPOINTS_NOT_AN_INTERVAL, (Number)lower2, upper2, true);
        }
    }

    public double getInf() {
        return this.lower;
    }

    public double getSup() {
        return this.upper;
    }

    public double getSize() {
        return this.upper - this.lower;
    }

    public double getBarycenter() {
        return this.middle;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public Region.Location checkPoint(double point) {
        double normalizedPoint = MathUtils.normalizeAngle(point, this.middle);
        if (normalizedPoint < this.lower - this.tolerance || normalizedPoint > this.upper + this.tolerance) {
            return Region.Location.OUTSIDE;
        }
        if (normalizedPoint > this.lower + this.tolerance && normalizedPoint < this.upper - this.tolerance) {
            return Region.Location.INSIDE;
        }
        return this.getSize() >= Math.PI * 2 - this.tolerance ? Region.Location.INSIDE : Region.Location.BOUNDARY;
    }
}

