/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.io.Serializable;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

public class DiagonalMatrix
extends AbstractRealMatrix
implements Serializable {
    private static final long serialVersionUID = 20121229L;
    private final double[] data;

    public DiagonalMatrix(int dimension) throws NotStrictlyPositiveException {
        super(dimension, dimension);
        this.data = new double[dimension];
    }

    public DiagonalMatrix(double[] d2) {
        this(d2, true);
    }

    public DiagonalMatrix(double[] d2, boolean copyArray) throws NullArgumentException {
        MathUtils.checkNotNull(d2);
        this.data = copyArray ? (double[])d2.clone() : d2;
    }

    public RealMatrix createMatrix(int rowDimension, int columnDimension) throws NotStrictlyPositiveException, DimensionMismatchException {
        if (rowDimension != columnDimension) {
            throw new DimensionMismatchException(rowDimension, columnDimension);
        }
        return new DiagonalMatrix(rowDimension);
    }

    public RealMatrix copy() {
        return new DiagonalMatrix(this.data);
    }

    public DiagonalMatrix add(DiagonalMatrix m2) throws MatrixDimensionMismatchException {
        MatrixUtils.checkAdditionCompatible(this, m2);
        int dim = this.getRowDimension();
        double[] outData = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            outData[i2] = this.data[i2] + m2.data[i2];
        }
        return new DiagonalMatrix(outData, false);
    }

    public DiagonalMatrix subtract(DiagonalMatrix m2) throws MatrixDimensionMismatchException {
        MatrixUtils.checkSubtractionCompatible(this, m2);
        int dim = this.getRowDimension();
        double[] outData = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            outData[i2] = this.data[i2] - m2.data[i2];
        }
        return new DiagonalMatrix(outData, false);
    }

    public DiagonalMatrix multiply(DiagonalMatrix m2) throws DimensionMismatchException {
        MatrixUtils.checkMultiplicationCompatible(this, m2);
        int dim = this.getRowDimension();
        double[] outData = new double[dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            outData[i2] = this.data[i2] * m2.data[i2];
        }
        return new DiagonalMatrix(outData, false);
    }

    public RealMatrix multiply(RealMatrix m2) throws DimensionMismatchException {
        if (m2 instanceof DiagonalMatrix) {
            return this.multiply((DiagonalMatrix)m2);
        }
        MatrixUtils.checkMultiplicationCompatible(this, m2);
        int nRows = m2.getRowDimension();
        int nCols = m2.getColumnDimension();
        double[][] product = new double[nRows][nCols];
        for (int r = 0; r < nRows; ++r) {
            for (int c2 = 0; c2 < nCols; ++c2) {
                product[r][c2] = this.data[r] * m2.getEntry(r, c2);
            }
        }
        return new Array2DRowRealMatrix(product, false);
    }

    public double[][] getData() {
        int dim = this.getRowDimension();
        double[][] out = new double[dim][dim];
        for (int i2 = 0; i2 < dim; ++i2) {
            out[i2][i2] = this.data[i2];
        }
        return out;
    }

    public double[] getDataRef() {
        return this.data;
    }

    public double getEntry(int row, int column) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, row, column);
        return row == column ? this.data[row] : 0.0;
    }

    public void setEntry(int row, int column, double value) throws OutOfRangeException, NumberIsTooLargeException {
        if (row == column) {
            MatrixUtils.checkRowIndex(this, row);
            this.data[row] = value;
        } else {
            this.ensureZero(value);
        }
    }

    public void addToEntry(int row, int column, double increment) throws OutOfRangeException, NumberIsTooLargeException {
        if (row == column) {
            MatrixUtils.checkRowIndex(this, row);
            int n2 = row;
            this.data[n2] = this.data[n2] + increment;
        } else {
            this.ensureZero(increment);
        }
    }

    public void multiplyEntry(int row, int column, double factor) throws OutOfRangeException {
        if (row == column) {
            MatrixUtils.checkRowIndex(this, row);
            int n2 = row;
            this.data[n2] = this.data[n2] * factor;
        }
    }

    public int getRowDimension() {
        return this.data.length;
    }

    public int getColumnDimension() {
        return this.data.length;
    }

    public double[] operate(double[] v) throws DimensionMismatchException {
        return this.multiply(new DiagonalMatrix(v, false)).getDataRef();
    }

    public double[] preMultiply(double[] v) throws DimensionMismatchException {
        return this.operate(v);
    }

    public RealVector preMultiply(RealVector v) throws DimensionMismatchException {
        double[] vectorData = v instanceof ArrayRealVector ? ((ArrayRealVector)v).getDataRef() : v.toArray();
        return MatrixUtils.createRealVector(this.preMultiply(vectorData));
    }

    private void ensureZero(double value) throws NumberIsTooLargeException {
        if (!Precision.equals(0.0, value, 1)) {
            throw new NumberIsTooLargeException(FastMath.abs(value), (Number)0, true);
        }
    }

    public DiagonalMatrix inverse() throws SingularMatrixException {
        return this.inverse(0.0);
    }

    public DiagonalMatrix inverse(double threshold) throws SingularMatrixException {
        if (this.isSingular(threshold)) {
            throw new SingularMatrixException();
        }
        double[] result2 = new double[this.data.length];
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            result2[i2] = 1.0 / this.data[i2];
        }
        return new DiagonalMatrix(result2, false);
    }

    public boolean isSingular(double threshold) {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            if (!Precision.equals(this.data[i2], 0.0, threshold)) continue;
            return true;
        }
        return false;
    }
}

