/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.oned;

import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.ml.neuralnet.FeatureInitializer;
import org.apache.commons.math3.ml.neuralnet.Network;

public class NeuronString
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Network network;
    private final int size;
    private final boolean wrap;
    private final long[] identifiers;

    NeuronString(boolean wrap2, double[][] featuresList) {
        this.size = featuresList.length;
        if (this.size < 2) {
            throw new NumberIsTooSmallException(this.size, (Number)2, true);
        }
        this.wrap = wrap2;
        int fLen = featuresList[0].length;
        this.network = new Network(0L, fLen);
        this.identifiers = new long[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.identifiers[i2] = this.network.createNeuron(featuresList[i2]);
        }
        this.createLinks();
    }

    public NeuronString(int num, boolean wrap2, FeatureInitializer[] featureInit) {
        if (num < 2) {
            throw new NumberIsTooSmallException(num, (Number)2, true);
        }
        this.size = num;
        this.wrap = wrap2;
        this.identifiers = new long[num];
        int fLen = featureInit.length;
        this.network = new Network(0L, fLen);
        for (int i2 = 0; i2 < num; ++i2) {
            double[] features = new double[fLen];
            for (int fIndex = 0; fIndex < fLen; ++fIndex) {
                features[fIndex] = featureInit[fIndex].value();
            }
            this.identifiers[i2] = this.network.createNeuron(features);
        }
        this.createLinks();
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getSize() {
        return this.size;
    }

    public double[] getFeatures(int i2) {
        if (i2 < 0 || i2 >= this.size) {
            throw new OutOfRangeException(i2, (Number)0, this.size - 1);
        }
        return this.network.getNeuron(this.identifiers[i2]).getFeatures();
    }

    private void createLinks() {
        int i2;
        for (i2 = 0; i2 < this.size - 1; ++i2) {
            this.network.addLink(this.network.getNeuron(i2), this.network.getNeuron(i2 + 1));
        }
        for (i2 = this.size - 1; i2 > 0; --i2) {
            this.network.addLink(this.network.getNeuron(i2), this.network.getNeuron(i2 - 1));
        }
        if (this.wrap) {
            this.network.addLink(this.network.getNeuron(0L), this.network.getNeuron(this.size - 1));
            this.network.addLink(this.network.getNeuron(this.size - 1), this.network.getNeuron(0L));
        }
    }

    private void readObject(ObjectInputStream in) {
        throw new IllegalStateException();
    }

    private Object writeReplace() {
        double[][] featuresList = new double[this.size][];
        for (int i2 = 0; i2 < this.size; ++i2) {
            featuresList[i2] = this.getFeatures(i2);
        }
        return new SerializationProxy(this.wrap, featuresList);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 20130226L;
        private final boolean wrap;
        private final double[][] featuresList;

        SerializationProxy(boolean wrap2, double[][] featuresList) {
            this.wrap = wrap2;
            this.featuresList = featuresList;
        }

        private Object readResolve() {
            return new NeuronString(this.wrap, this.featuresList);
        }
    }
}

