/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

@Deprecated
public class MultivariateFunctionPenaltyAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final double[] lower;
    private final double[] upper;
    private final double offset;
    private final double[] scale;

    public MultivariateFunctionPenaltyAdapter(MultivariateFunction bounded, double[] lower2, double[] upper2, double offset, double[] scale) {
        MathUtils.checkNotNull(lower2);
        MathUtils.checkNotNull(upper2);
        MathUtils.checkNotNull(scale);
        if (lower2.length != upper2.length) {
            throw new DimensionMismatchException(lower2.length, upper2.length);
        }
        if (lower2.length != scale.length) {
            throw new DimensionMismatchException(lower2.length, scale.length);
        }
        for (int i2 = 0; i2 < lower2.length; ++i2) {
            if (upper2[i2] >= lower2[i2]) continue;
            throw new NumberIsTooSmallException(upper2[i2], (Number)lower2[i2], true);
        }
        this.bounded = bounded;
        this.lower = (double[])lower2.clone();
        this.upper = (double[])upper2.clone();
        this.offset = offset;
        this.scale = (double[])scale.clone();
    }

    public double value(double[] point) {
        for (int i2 = 0; i2 < this.scale.length; ++i2) {
            if (!(point[i2] < this.lower[i2]) && !(point[i2] > this.upper[i2])) continue;
            double sum = 0.0;
            for (int j2 = i2; j2 < this.scale.length; ++j2) {
                double overshoot = point[j2] < this.lower[j2] ? this.scale[j2] * (this.lower[j2] - point[j2]) : (point[j2] > this.upper[j2] ? this.scale[j2] * (point[j2] - this.upper[j2]) : 0.0);
                sum += FastMath.sqrt(overshoot);
            }
            return this.offset + sum;
        }
        return this.bounded.value(point);
    }
}

