/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public abstract class BitsStreamGenerator
implements RandomGenerator,
Serializable {
    private static final long serialVersionUID = 20130104L;
    private double nextGaussian = Double.NaN;

    public abstract void setSeed(int var1);

    public abstract void setSeed(int[] var1);

    public abstract void setSeed(long var1);

    protected abstract int next(int var1);

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public void nextBytes(byte[] bytes) {
        int random2;
        int i2;
        int iEnd = bytes.length - 3;
        for (i2 = 0; i2 < iEnd; i2 += 4) {
            random2 = this.next(32);
            bytes[i2] = (byte)(random2 & 0xFF);
            bytes[i2 + 1] = (byte)(random2 >> 8 & 0xFF);
            bytes[i2 + 2] = (byte)(random2 >> 16 & 0xFF);
            bytes[i2 + 3] = (byte)(random2 >> 24 & 0xFF);
        }
        random2 = this.next(32);
        while (i2 < bytes.length) {
            bytes[i2++] = (byte)(random2 & 0xFF);
            random2 >>= 8;
        }
    }

    public double nextDouble() {
        long high = (long)this.next(26) << 26;
        int low = this.next(26);
        return (double)(high | (long)low) * 2.220446049250313E-16;
    }

    public float nextFloat() {
        return (float)this.next(23) * 1.1920929E-7f;
    }

    public double nextGaussian() {
        double random2;
        if (Double.isNaN(this.nextGaussian)) {
            double x = this.nextDouble();
            double y = this.nextDouble();
            double alpha = Math.PI * 2 * x;
            double r = FastMath.sqrt(-2.0 * FastMath.log(y));
            random2 = r * FastMath.cos(alpha);
            this.nextGaussian = r * FastMath.sin(alpha);
        } else {
            random2 = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return random2;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n2) throws IllegalArgumentException {
        if (n2 > 0) {
            int val;
            int bits;
            if ((n2 & -n2) == n2) {
                return (int)((long)n2 * (long)this.next(31) >> 31);
            }
            while ((bits = this.next(31)) - (val = bits % n2) + (n2 - 1) < 0) {
            }
            return val;
        }
        throw new NotStrictlyPositiveException(n2);
    }

    public long nextLong() {
        long high = (long)this.next(32) << 32;
        long low = (long)this.next(32) & 0xFFFFFFFFL;
        return high | low;
    }

    public long nextLong(long n2) throws IllegalArgumentException {
        if (n2 > 0L) {
            long bits;
            long val;
            do {
                bits = (long)this.next(31) << 32;
            } while ((bits |= (long)this.next(32) & 0xFFFFFFFFL) - (val = bits % n2) + (n2 - 1L) < 0L);
            return val;
        }
        throw new NotStrictlyPositiveException(n2);
    }

    public void clear() {
        this.nextGaussian = Double.NaN;
    }
}

