/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.correlation;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Pair;

public class KendallsCorrelation {
    private final RealMatrix correlationMatrix;

    public KendallsCorrelation() {
        this.correlationMatrix = null;
    }

    public KendallsCorrelation(double[][] data) {
        this(MatrixUtils.createRealMatrix(data));
    }

    public KendallsCorrelation(RealMatrix matrix) {
        this.correlationMatrix = this.computeCorrelationMatrix(matrix);
    }

    public RealMatrix getCorrelationMatrix() {
        return this.correlationMatrix;
    }

    public RealMatrix computeCorrelationMatrix(RealMatrix matrix) {
        int nVars = matrix.getColumnDimension();
        BlockRealMatrix outMatrix = new BlockRealMatrix(nVars, nVars);
        for (int i2 = 0; i2 < nVars; ++i2) {
            for (int j2 = 0; j2 < i2; ++j2) {
                double corr = this.correlation(matrix.getColumn(i2), matrix.getColumn(j2));
                outMatrix.setEntry(i2, j2, corr);
                outMatrix.setEntry(j2, i2, corr);
            }
            outMatrix.setEntry(i2, i2, 1.0);
        }
        return outMatrix;
    }

    public RealMatrix computeCorrelationMatrix(double[][] matrix) {
        return this.computeCorrelationMatrix(new BlockRealMatrix(matrix));
    }

    public double correlation(double[] xArray, double[] yArray) throws DimensionMismatchException {
        if (xArray.length != yArray.length) {
            throw new DimensionMismatchException(xArray.length, yArray.length);
        }
        int n2 = xArray.length;
        long numPairs = KendallsCorrelation.sum(n2 - 1);
        Pair[] pairs = new Pair[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            pairs[i2] = new Pair<Double, Double>(xArray[i2], yArray[i2]);
        }
        Arrays.sort(pairs, new Comparator<Pair<Double, Double>>(){

            @Override
            public int compare(Pair<Double, Double> pair1, Pair<Double, Double> pair2) {
                int compareFirst = pair1.getFirst().compareTo(pair2.getFirst());
                return compareFirst != 0 ? compareFirst : pair1.getSecond().compareTo(pair2.getSecond());
            }
        });
        long tiedXPairs = 0L;
        long tiedXYPairs = 0L;
        long consecutiveXTies = 1L;
        long consecutiveXYTies = 1L;
        Pair prev = pairs[0];
        for (int i3 = 1; i3 < n2; ++i3) {
            Pair curr = pairs[i3];
            if (((Double)curr.getFirst()).equals(prev.getFirst())) {
                ++consecutiveXTies;
                if (((Double)curr.getSecond()).equals(prev.getSecond())) {
                    ++consecutiveXYTies;
                } else {
                    tiedXYPairs += KendallsCorrelation.sum(consecutiveXYTies - 1L);
                    consecutiveXYTies = 1L;
                }
            } else {
                tiedXPairs += KendallsCorrelation.sum(consecutiveXTies - 1L);
                consecutiveXTies = 1L;
                tiedXYPairs += KendallsCorrelation.sum(consecutiveXYTies - 1L);
                consecutiveXYTies = 1L;
            }
            prev = curr;
        }
        tiedXPairs += KendallsCorrelation.sum(consecutiveXTies - 1L);
        tiedXYPairs += KendallsCorrelation.sum(consecutiveXYTies - 1L);
        int swaps = 0;
        Pair[] pairsDestination = new Pair[n2];
        for (int segmentSize = 1; segmentSize < n2; segmentSize <<= 1) {
            for (int offset = 0; offset < n2; offset += 2 * segmentSize) {
                int iEnd;
                int i4 = offset;
                int j2 = iEnd = FastMath.min(i4 + segmentSize, n2);
                int jEnd = FastMath.min(j2 + segmentSize, n2);
                int copyLocation = offset;
                while (i4 < iEnd || j2 < jEnd) {
                    if (i4 < iEnd) {
                        if (j2 < jEnd) {
                            if (((Double)pairs[i4].getSecond()).compareTo((Double)pairs[j2].getSecond()) <= 0) {
                                pairsDestination[copyLocation] = pairs[i4];
                                ++i4;
                            } else {
                                pairsDestination[copyLocation] = pairs[j2];
                                ++j2;
                                swaps += iEnd - i4;
                            }
                        } else {
                            pairsDestination[copyLocation] = pairs[i4];
                            ++i4;
                        }
                    } else {
                        pairsDestination[copyLocation] = pairs[j2];
                        ++j2;
                    }
                    ++copyLocation;
                }
            }
            Pair[] pairsTemp = pairs;
            pairs = pairsDestination;
            pairsDestination = pairsTemp;
        }
        long tiedYPairs = 0L;
        long consecutiveYTies = 1L;
        prev = pairs[0];
        for (int i5 = 1; i5 < n2; ++i5) {
            Pair curr = pairs[i5];
            if (((Double)curr.getSecond()).equals(prev.getSecond())) {
                ++consecutiveYTies;
            } else {
                tiedYPairs += KendallsCorrelation.sum(consecutiveYTies - 1L);
                consecutiveYTies = 1L;
            }
            prev = curr;
        }
        long concordantMinusDiscordant = numPairs - tiedXPairs - (tiedYPairs += KendallsCorrelation.sum(consecutiveYTies - 1L)) + tiedXYPairs - (long)(2 * swaps);
        double nonTiedPairsMultiplied = (double)(numPairs - tiedXPairs) * (double)(numPairs - tiedYPairs);
        return (double)concordantMinusDiscordant / FastMath.sqrt(nonTiedPairsMultiplied);
    }

    private static long sum(long n2) {
        return n2 * (n2 + 1L) / 2L;
    }
}

