/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.ThirdMoment;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public class Skewness
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 7101857578996691352L;
    protected ThirdMoment moment = null;
    protected boolean incMoment;

    public Skewness() {
        this.incMoment = true;
        this.moment = new ThirdMoment();
    }

    public Skewness(ThirdMoment m3) {
        this.incMoment = false;
        this.moment = m3;
    }

    public Skewness(Skewness original) throws NullArgumentException {
        Skewness.copy(original, this);
    }

    public void increment(double d2) {
        if (this.incMoment) {
            this.moment.increment(d2);
        }
    }

    public double getResult() {
        if (this.moment.n < 3L) {
            return Double.NaN;
        }
        double variance = this.moment.m2 / (double)(this.moment.n - 1L);
        if (variance < 1.0E-19) {
            return 0.0;
        }
        double n0 = this.moment.getN();
        return n0 * this.moment.m3 / ((n0 - 1.0) * (n0 - 2.0) * FastMath.sqrt(variance) * variance);
    }

    public long getN() {
        return this.moment.getN();
    }

    public void clear() {
        if (this.incMoment) {
            this.moment.clear();
        }
    }

    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        double skew = Double.NaN;
        if (this.test(values, begin, length) && length > 2) {
            Mean mean = new Mean();
            double m2 = mean.evaluate(values, begin, length);
            double accum2 = 0.0;
            double accum22 = 0.0;
            for (int i2 = begin; i2 < begin + length; ++i2) {
                double d2 = values[i2] - m2;
                accum2 += d2 * d2;
                accum22 += d2;
            }
            double variance = (accum2 - accum22 * accum22 / (double)length) / (double)(length - 1);
            double accum3 = 0.0;
            for (int i3 = begin; i3 < begin + length; ++i3) {
                double d3 = values[i3] - m2;
                accum3 += d3 * d3 * d3;
            }
            double n0 = length;
            skew = n0 / ((n0 - 1.0) * (n0 - 2.0)) * (accum3 /= variance * FastMath.sqrt(variance));
        }
        return skew;
    }

    public Skewness copy() {
        Skewness result2 = new Skewness();
        Skewness.copy(this, result2);
        return result2;
    }

    public static void copy(Skewness source, Skewness dest) throws NullArgumentException {
        MathUtils.checkNotNull(source);
        MathUtils.checkNotNull(dest);
        dest.setData(source.getDataRef());
        dest.moment = new ThirdMoment(source.moment.copy());
        dest.incMoment = source.incMoment;
    }
}

